/*****************************************************************************
 * packet_handler.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#ifndef _PACKAGEHANDLER_H_
#define _PACKAGEHANDLER_H_

#include "users.h"
#include "pmnotebook.h"

extern int need_room_list; /* for captcha */

/* added PhrozenSmoke: some variables needed for voice chat */
extern char current_chat_serial[50];
extern char current_chat_cookie[120];
extern char current_chat_user[75];
extern char current_chat_name[75];

extern int real_show_colors;
extern int enable_pm_searches;
extern char *yalias_name;  /* for Yahoo 'nick name' handling */

extern int test_automute(char *who);

void handle_logoff();
void check_connection_timedout();
extern void handle_dead_connection (int broken_pipe, int disable_reconn, int disable_dialog, char *reason);

void append_timestamp(GtkWidget *somewidget, GtkWidget *somewidget2);

extern char *ymsg_field(char *key);

extern int upload_new_buddy_image();
void update_my_buddy_image(PM_SESSION *pm_sess, int is_me);
extern void handle_yahoo_packet();
extern void clear_offline_messages();
extern void send_automated_response(char *inuser, char *inalias, char *myinmsg);
extern int get_pm_perms(char *who);
extern void focus_pm_entry(PM_SESSION *pm_sess);

extern void show_incoming_pm(PM_SESSION *gpm_sess, TYPING_STATUS mesg);
void send_rejection_message(int is_pm_spam);
extern void append_to_open_pms(char *who, char *mytext, int with_timestamp);

#endif /* #ifndef _PACKAGEHANDLER_H_ */






