/*****************************************************************************
 * pmnotebook.h
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2006, Greg Hosler
 * (ghosler ['at'] users.sourceforge.net)
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/


#ifndef _PMNOTEBOOK_H_
#define _PMNOTEBOOK_H_

typedef enum {
        TYPING,
	TYPED,
	UNSEEN_TEXT,
	UNSEEN_EVENT,
	SENT_TEXT,
	SELECT_PAGE,
	FOCUS
} TYPING_STATUS;

#define TEXT_BLACK  "#000000"
#define TEXT_GREEN  "#47A046"
#define TEXT_ORANGE "#DF421E"
#define TEXT_BLUE   "#0D4E91"


/* generic routines used in session initialization */
void pm_notebook_save();
void pm_notebook_add_window(GtkWidget *pm_window, char *label_text);
void pm_notebook_set_typing_status(PM_SESSION *pm_sess, TYPING_STATUS status);
void pm_notebook_focus_page(PM_SESSION *pm_sess);
void pm_notebook_select_tab(GYACHI_NOTEBOOK_INTERFACE *, char *name);
void pm_notebook_set_flashing_status(PM_SESSION *pm_sess, int status);

#endif /* #ifndef _PMWINDOW_H_ */
