/*****************************************************************************
 * roomui.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/
/*
	exported by PhrozenSmoke from interface.c, to reduce monstrous size of 
	interface.c (can cause 'out of memory' errors while compiling)...
	all room list, create a room, and room 'favorites' UI functions
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <malloc.h>

#include "callbacks.h"
#include "interface.h"
#include "util.h"
#include "profname.h"
#include "gytreeview.h"
#include "roomlist.h"

/* local to this module */
GList *roomintllist = NULL;

GtkWidget *get_intl_room_bar(GtkWidget *room_list)  {
	GtkWidget *hbox12, *intlcombo, *reload_room_list;

	hbox12 = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox12), gtk_label_new(_("Location")), FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox12), gtk_label_new(":  "), FALSE, FALSE, 0);

	if (!roomintllist) {
		roomintllist = g_list_append( roomintllist, "us" );
		roomintllist = g_list_append( roomintllist, "ar" );
		roomintllist = g_list_append( roomintllist, "au" );
		roomintllist = g_list_append( roomintllist, "br" );
		roomintllist = g_list_append( roomintllist, "ca" );
		roomintllist = g_list_append( roomintllist, "cf" );
		roomintllist = g_list_append( roomintllist, "cn" );
		roomintllist = g_list_append( roomintllist, "ct" );
		roomintllist = g_list_append( roomintllist, "de" );
		roomintllist = g_list_append( roomintllist, "dk" );
		roomintllist = g_list_append( roomintllist, "e1" );
		roomintllist = g_list_append( roomintllist, "es" );
		roomintllist = g_list_append( roomintllist, "fr" );
		roomintllist = g_list_append( roomintllist, "hk" );
		roomintllist = g_list_append( roomintllist, "hu" );
		roomintllist = g_list_append( roomintllist, "in" );
		roomintllist = g_list_append( roomintllist, "jp" );
		roomintllist = g_list_append( roomintllist, "kr" );
		roomintllist = g_list_append( roomintllist, "it" );
		roomintllist = g_list_append( roomintllist, "mx" );
		roomintllist = g_list_append( roomintllist, "no" );
		roomintllist = g_list_append( roomintllist, "se" );
		roomintllist = g_list_append( roomintllist, "sr" );
		roomintllist = g_list_append( roomintllist, "sg" );
		roomintllist = g_list_append( roomintllist, "tw" );
		roomintllist = g_list_append( roomintllist, "uk" );
	}

	intlcombo=gtk_combo_new();
	set_tooltip(intlcombo,_("Location"));
	g_object_set_data(G_OBJECT(room_list), "intlcombo",intlcombo);
	gtk_combo_set_popdown_strings( GTK_COMBO(intlcombo), roomintllist );
	gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(intlcombo)->entry),FALSE );
	gtk_box_pack_start (GTK_BOX (hbox12), intlcombo, FALSE, FALSE, 2);

	if (room_list_country_code) {
		char *intls=strdup(room_list_country_code);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(intlcombo)->entry), intls);
		free(intls);
	}
	else {
		char *intls=strdup("us");
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(intlcombo)->entry), intls);
		free(intls);
	}

	reload_room_list = get_pixmapped_button(_(" Reload "), GTK_STOCK_REFRESH);
	set_tooltip(reload_room_list,_(" Reload "));
	g_object_set_data(G_OBJECT(room_list), "reload_room_list",reload_room_list);
	gtk_box_pack_start (GTK_BOX (hbox12), reload_room_list, TRUE, TRUE, 3);

	gtk_widget_show_all (hbox12);
	return hbox12;
}

GtkWidget* create_room_list(GtkWidget *parent)
{
  GtkWidget *room_list, *profwidget;
  GtkWidget *vbox10;
  GtkWidget *scrolledwindow6;
  GtkWidget *room_tree; 
  GtkWidget *hbox11;
  GtkWidget *goto_room;
  GtkWidget *cancel_room;
  GtkWidget *reload_room_list;
  GtkWidget *hbox12;
  char *col_headers[]={"",NULL};

  room_list = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (room_list), "gyachERooms", "GyachI");
  g_object_set_data(G_OBJECT(room_list), "room_list", room_list);
  gtk_window_set_title (GTK_WINDOW (room_list), _("Yahoo! Room List"));
  gtk_window_set_default_size (GTK_WINDOW (room_list), 515, 350);
  gtk_window_set_position (GTK_WINDOW (room_list), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_transient_for(GTK_WINDOW(room_list), GTK_WINDOW(parent));
  gtk_window_set_destroy_with_parent(GTK_WINDOW(room_list), TRUE);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (room_list), vbox10);
  gtk_widget_show (vbox10);
  gtk_container_set_border_width(GTK_CONTAINER(vbox10),2);

  scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow6);
  g_object_set_data_full(G_OBJECT(room_list), "scrolledwindow6", scrolledwindow6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox10), scrolledwindow6, TRUE, TRUE, 2);
  gtk_widget_show (scrolledwindow6);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_SHADOW_ETCHED_IN);

  room_tree = GTK_WIDGET(create_gy_treeview(GYTV_TYPE_TREE,GYLIST_TYPE_ROOM, 0, 1, col_headers));
  gtk_widget_ref (room_tree);
  g_object_set_data_full(G_OBJECT(room_list), "room_tree", room_tree,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (scrolledwindow6), room_tree);
  gtk_widget_show (room_tree);

  /* loading_status = gtk_label_new (_("Loading Room List..."));
  gtk_widget_ref (loading_status);
  g_object_set_data_full(G_OBJECT(room_list), "loading_status", loading_status,
                            (GtkDestroyNotify) gtk_widget_unref);
			    gtk_box_pack_start (GTK_BOX (vbox10), loading_status, FALSE, FALSE, 3);
  gtk_widget_show (loading_status); */

  hbox12=get_intl_room_bar(room_list);
  gtk_box_pack_start (GTK_BOX (vbox10), hbox12, FALSE, FALSE, 2);
  reload_room_list=g_object_get_data(G_OBJECT(room_list),"reload_room_list");

  profwidget=get_profile_name_component(1);
  gtk_box_pack_start (GTK_BOX (vbox10), profwidget, FALSE, FALSE, 2);

  hbox11 = gtk_hbox_new (TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox10), hbox11, FALSE, TRUE, 2);
  gtk_widget_show (hbox11);
  gtk_container_set_border_width(GTK_CONTAINER(hbox11),3);
  gtk_container_set_border_width(GTK_CONTAINER(hbox12),5);

  goto_room = get_pixmapped_button(_(" Join Room "), GTK_STOCK_APPLY);
  g_object_set_data(G_OBJECT(goto_room),PROFNAMESTR , retrieve_profname_entry (profwidget) );
  g_object_set_data(G_OBJECT(room_tree),PROFNAMESTR , retrieve_profname_entry (profwidget) );
  g_object_set_data(G_OBJECT(room_list),"profcombo" ,g_object_get_data(G_OBJECT(profwidget), "profcombo") );

  set_tooltip(goto_room,_(" Join Room "));
  gtk_widget_ref (goto_room);
  g_object_set_data_full(G_OBJECT(room_list), "goto_room", goto_room,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox11), goto_room, TRUE, TRUE, 0);
  gtk_widget_show (goto_room);

  gtk_box_pack_start (GTK_BOX (hbox11), gtk_label_new(" "), TRUE, TRUE, 0);

  cancel_room = get_pixmapped_button(_(" Close "), GTK_STOCK_CANCEL);
  set_tooltip(cancel_room,_(" Close "));
  gtk_widget_ref (cancel_room);
  g_object_set_data_full(G_OBJECT(room_list), "cancel_room", cancel_room,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox11), cancel_room, TRUE, TRUE, 0);
  gtk_widget_show (cancel_room);

  g_signal_connect_after(G_OBJECT(room_list), "delete_event",
                            G_CALLBACK(on_room_list_delete_event),
                            NULL);
  g_signal_connect(G_OBJECT(room_tree), "button_press_event",
                      G_CALLBACK(on_room_tree_button_press_event),
                      NULL);
  g_signal_connect (room_tree, "row-activated", (GCallback) onRoomListActivated,
                      NULL);
  g_signal_connect (room_tree, "popup-menu", (GCallback) on_room_tree_kb_popup, NULL);
  g_signal_connect_after (room_tree,  "row-expanded",
                            (GCallback)  on_room_tree_tree_expand,
                            NULL);
  g_signal_connect(G_OBJECT(goto_room), "clicked",
                      G_CALLBACK(on_goto_room_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(reload_room_list), "clicked",
                      G_CALLBACK(on_reload_room_list_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(cancel_room), "clicked",
                      G_CALLBACK(on_cancel_room_clicked),
                      NULL);

  return room_list;
}



GtkWidget* create_favorites(GtkWidget *parent)
{
  GtkWidget *favorites;
  GtkWidget *vbox6;
  GtkWidget *table2;
  GtkWidget *scrolledwindow11;
  GtkWidget *fav_room_list;
  GtkWidget *hbox7;
  GtkWidget *goto_fav;
  GtkWidget *cancel_favs;
  GtkWidget *profwidget;
  char *col_headers[]={"",NULL};

  favorites = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (favorites), "gyachEFavorites", "GyachI");
  g_object_set_data(G_OBJECT(favorites), "favorites", favorites);
  gtk_window_set_title (GTK_WINDOW (favorites), _("Favorite Yahoo! Rooms"));
  gtk_window_set_position (GTK_WINDOW (favorites), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_transient_for(GTK_WINDOW(favorites), GTK_WINDOW(parent));
  gtk_window_set_destroy_with_parent(GTK_WINDOW(favorites), TRUE);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  g_object_set_data_full(G_OBJECT(favorites), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (favorites), vbox6);
  gtk_widget_show (vbox6);

  table2 = gtk_table_new (1, 1, FALSE);
  gtk_widget_ref (table2);
  g_object_set_data_full(G_OBJECT(favorites), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox6), table2, FALSE, TRUE, 0);
  gtk_widget_show (table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 5);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 5);

  scrolledwindow11 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow11);
  g_object_set_data_full(G_OBJECT(favorites), "scrolledwindow11", scrolledwindow11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_table_attach (GTK_TABLE (table2), scrolledwindow11, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_widget_set_size_request(scrolledwindow11, 200, 328);
  gtk_widget_show (scrolledwindow11);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow11), GTK_SHADOW_ETCHED_IN);

  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow11), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  col_headers[0]=_("Favorite Rooms");
  fav_room_list = GTK_WIDGET(create_gy_treeview(GYTV_TYPE_LIST,GYLIST_TYPE_SINGLE, 1, 
	1, col_headers));
  gtk_widget_ref (fav_room_list);
  g_object_set_data_full(G_OBJECT(favorites), "fav_room_list", fav_room_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_container_add (GTK_CONTAINER (scrolledwindow11), fav_room_list);
  gtk_widget_set_size_request(fav_room_list, 300, 328);
  gtk_widget_show (fav_room_list);

  profwidget=get_profile_name_component(1);
  gtk_box_pack_start (GTK_BOX (vbox6), profwidget, TRUE, FALSE, 2);

  hbox7 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox7);
  g_object_set_data_full(G_OBJECT(favorites), "hbox7", hbox7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox7, TRUE, FALSE, 0);
  gtk_widget_show (hbox7);
  gtk_container_set_border_width (GTK_CONTAINER (hbox7), 5);

  goto_fav = get_pixmapped_button(_(" Join Room "), GTK_STOCK_APPLY);
  set_tooltip(goto_fav,_(" Join Room "));
  g_object_set_data(G_OBJECT(goto_fav),PROFNAMESTR , retrieve_profname_entry (profwidget) );
  g_object_set_data(G_OBJECT(favorites),"profcombo" ,g_object_get_data(G_OBJECT(profwidget), "profcombo") );
  gtk_widget_ref (goto_fav);
  g_object_set_data_full(G_OBJECT(favorites), "goto_fav", goto_fav,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox7), goto_fav, FALSE, FALSE, 0);
  gtk_widget_show (goto_fav);

  cancel_favs = get_pixmapped_button(_(" Cancel "), GTK_STOCK_CANCEL);
  set_tooltip( cancel_favs,_(" Cancel "));
  gtk_widget_ref (cancel_favs);
  g_object_set_data_full(G_OBJECT(favorites), "cancel_favs", cancel_favs,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_box_pack_start (GTK_BOX (hbox7), cancel_favs, FALSE, FALSE, 0);
  gtk_widget_show (cancel_favs);

  g_object_set_data(G_OBJECT(goto_fav),PROFNAMESTR , retrieve_profname_entry (profwidget) );
  g_object_set_data(G_OBJECT(fav_room_list),PROFNAMESTR , retrieve_profname_entry (profwidget) );

  g_signal_connect_after(G_OBJECT(favorites), "delete_event",
                            G_CALLBACK(on_favorites_destroy_event),
                            NULL);
  g_signal_connect(G_OBJECT(fav_room_list), "button_press_event",
                      G_CALLBACK(on_favroom_list_button_press_event),
                      favorites);
  g_signal_connect (fav_room_list, "popup-menu", (GCallback) on_favoriteroom_tree_kb_popup, favorites);
  g_signal_connect (fav_room_list, "row-activated", (GCallback) onFavoriteRoomRowActivated,
                      NULL);
  g_signal_connect(G_OBJECT(goto_fav), "clicked",
                      G_CALLBACK(on_goto_fav_clicked),
                      NULL);
  g_signal_connect(G_OBJECT(cancel_favs), "clicked",
                      G_CALLBACK(on_cancel_favs_clicked),
                      NULL);
  gtk_window_set_default_size(GTK_WINDOW (favorites), 410, -1);
  return favorites;
}


GtkWidget* create_addfavroom_menu ()
{
    GtkWidget *setup_menu;
    GtkWidget *setup_insert;

    setup_menu = gtk_menu_new ();
    g_object_set_data(G_OBJECT(setup_menu), "setup_menu", setup_menu);

    setup_insert = gtk_image_menu_item_new_with_label (_("Add To Favorites"));
    gtk_widget_ref (setup_insert);
    g_object_set_data_full(G_OBJECT(setup_menu), "setup_insert", setup_insert,
                            (GtkDestroyNotify) gtk_widget_unref);
                            
    gtk_container_add (GTK_CONTAINER (setup_menu), setup_insert);
    gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(setup_insert), 
	GTK_WIDGET(gtk_image_new_from_stock(GTK_STOCK_ADD, GTK_ICON_SIZE_MENU) ));

    g_signal_connect(G_OBJECT(setup_insert), "activate",
                      G_CALLBACK(on_addfavroom_insert_activate),
                      NULL);
    gtk_widget_show_all(setup_menu);
    return setup_menu;
}



