/******************************************************************************
 * GYachI-Voiceclient
 * Copyright (C) 2006  Stefan Sikora <hoshy[at]schrauberstube.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "protocol.h"
#include "sound.h"

void on_gyv_menu_connect_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_on"), FALSE);
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_off"), TRUE);
	StartYVoice();
}


void on_gyv_menu_disconnect_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	StopYVoice();
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_off"), FALSE);
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_on"), TRUE);
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_talk"), FALSE);
}


void on_gyv_menu_debugging_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (debugger) debugger = 0;
	else debugger = 1;
}


void on_quit1_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	StopYVoice();
	gtk_main_quit();
}


void on_about1_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *dialog;
	
	dialog = gtk_message_dialog_new_with_markup(GTK_WINDOW(gyv_mainwindow),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_INFO,
                                  GTK_BUTTONS_CLOSE,
                                  "<span size=\"medium\" weight=\"bold\">GYachI Voiceclient</span>\nVersion %s\n\n\n"
						    "Copyright (c) 2006 Stefan Sikora <i>[hoshy@schrauberstube.de]</i>\n\n"
						    "This program is free software; you can redistribute it and/or "
						    "modify it under the terms of the GNU General Public License as "
						    "published by the Free Software Foundation; either "
						    "version 2 of the License, or (at your option) any later version. "
						    "This program is distributed in the hope that it will be useful, "
						    "but WITHOUT ANY WARRANTY; without even the implied warranty of "
						    "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU "
						    "General Public License for more details.\n\n"
						    "Neither GYachI-Voicechat nor its author are in anyway endorsed by or "
						    "affiliated with Yahoo! (tm) or DSP Group's TrueSpeech (tm).\n\n"
						    "Yahoo! (tm) is a registered trademark of Yahoo! Communications.\n"
						    "TrueSpeech (tm) is a registered trademark of DSP Group. The TrueSpeech (tm) "
						    "codec and format are patented  by DSP Group.\n\n"
						    "Project homepage: http://gyachi.sourceforge.net",
                                  VERSION);
	gtk_dialog_run (GTK_DIALOG (dialog));
	gtk_widget_destroy (dialog);
}


void on_gyv_mainwindow_destroy(GtkObject *object, gpointer user_data)
{
	StopYVoice();
	gtk_main_quit();
}


void on_gyv_button_on_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	gtk_widget_set_sensitive (lookup_widget(gyv_mainwindow, "gyv_button_off"), TRUE);
	StartYVoice();
}


void on_gyv_button_off_clicked(GtkButton *button, gpointer user_data)
{
	GtkToggleButton *toggle_button = GTK_TOGGLE_BUTTON(lookup_widget(gyv_mainwindow, "gyv_button_talk"));

	gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	gtk_widget_set_sensitive (lookup_widget(gyv_mainwindow, "gyv_button_on"), TRUE);
	if (gtk_toggle_button_get_active(toggle_button)) {
		gtk_toggle_button_set_active(toggle_button, FALSE);
	}
	gtk_widget_set_sensitive(lookup_widget(gyv_mainwindow, "gyv_button_talk"), FALSE);
	StopYVoice();
}


void on_gyv_treeview_row_activated(GtkTreeView *treeview,
                                   GtkTreePath *path,
                                   GtkTreeViewColumn *column, gpointer user_data)
{

}


void on_gyv_treeview_columns_changed(GtkTreeView *treeview, gpointer user_data)
{

}

void on_gyv_button_talk_clicked(GtkButton *button, gpointer user_data)
{
	if (recording) {
		stop_recording();
	} else {
		start_recording();
	}
}

