/******************************************************************************
 * GYachI-Voiceclient
 * Copyright (C) 2006  Stefan Sikora <hoshy[at]schrauberstube.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "protocol.h"

int main (int argc, char *argv[]) {
	GtkWidget *tree;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *col;
	
#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
 	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

	// create mainwindow
	gyv_mainwindow = create_gyv_mainwindow ();

	// init chatter-list
	store = gtk_list_store_new(NUM_COLS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN);

	// set columns-rendering of treeview-widget
	tree = lookup_widget(gyv_mainwindow, "gyv_treeview");
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW(tree), -1, "Nickname", renderer, "text", COL_NICK, NULL);
	col = gtk_tree_view_column_new();
	renderer = gtk_cell_renderer_text_new();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW(tree), -1, "Alias", renderer, "text", COL_ALIAS, NULL);
	renderer = gtk_cell_renderer_toggle_new();
	gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW(tree), -1, "Ignore", renderer, "active", COL_IGN, NULL);
	gtk_tree_view_set_model(GTK_TREE_VIEW(tree), GTK_TREE_MODEL(store));

	//TODO: Handle ignore-list


	// show everything
  	gtk_widget_show (gyv_mainwindow);

	debugger = 0;		// no Packet-debugger by default

	// check for changing rooms every 3 seconds
	g_timeout_add(3*1000, RoomChange, NULL);
	
	// Enter mainloop
	gtk_main ();

	return 0;
}
