#include <pthread.h>

// Globals
#define max_tspchunks 200		// How many tsp-chunks the soundbuffer holds
#define tspdelay 10			// minimum packets before playback starts
unsigned char soundbuffer[max_tspchunks*1440];
unsigned char recordbuffer[1440];

int recvchunk;					// Where to put in next chunk
int playchunk;					// how many unplayed chunks are in soundbuffer
int silence;
int playing;
int recording;

pthread_cond_t data_cond;
pthread_mutex_t data_mutex;

// ui function
void reset_talk_labels();

// General sound-functions
int init_sound();
void uninit_sound();
void stop_recording();
void start_recording();

// Truespeech-functions
int tsp_conversion(char *src, char *dst, int srclen, int dstlen);
