/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

class Request {
    final int piece;
    final byte[] bs;
    final int off;
    final int len;
    long sendTime;

    Request(int piece, byte[] bs, int off, int len) {
        this.piece = piece;
        this.bs = bs;
        this.off = off;
        this.len = len;
        if (piece < 0 || off < 0 || len <= 0 || off + len > bs.length) {
            throw new IndexOutOfBoundsException("Illegal Request " + this.toString());
        }
    }

    public int hashCode() {
        return this.piece ^ this.off ^ this.len;
    }

    public boolean equals(Object o) {
        if (o instanceof Request) {
            Request req = (Request)o;
            return req.piece == this.piece && req.off == this.off && req.len == this.len;
        }
        return false;
    }

    public String toString() {
        return "(" + this.piece + "," + this.off + "," + this.len + ")";
    }
}

