/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Snark;

public class SnarkManager
implements Snark.CompleteListener {
    private static SnarkManager _instance = new SnarkManager();
    private Map _snarks = new HashMap();
    private Object _addSnarkLock = new Object();
    private String _configFile;
    private Properties _config;
    private I2PAppContext _context = I2PAppContext.getGlobalContext();
    private Log _log = this._context.logManager().getLog(SnarkManager.class);
    private List _messages = new ArrayList(16);
    public static final String PROP_I2CP_HOST = "i2psnark.i2cpHost";
    public static final String PROP_I2CP_PORT = "i2psnark.i2cpPort";
    public static final String PROP_I2CP_OPTS = "i2psnark.i2cpOptions";
    public static final String PROP_EEP_HOST = "i2psnark.eepHost";
    public static final String PROP_EEP_PORT = "i2psnark.eepPort";
    public static final String PROP_UPLOADERS_TOTAL = "i2psnark.uploaders.total";
    public static final String PROP_UPBW_MAX = "i2psnark.upbw.max";
    public static final String PROP_DIR = "i2psnark.dir";
    public static final String PROP_META_PREFIX = "i2psnark.zmeta.";
    public static final String PROP_META_BITFIELD_SUFFIX = ".bitfield";
    public static final String PROP_AUTO_START = "i2snark.autoStart";
    public static final String DEFAULT_AUTO_START = "false";
    public static final String PROP_USE_OPENTRACKERS = "i2psnark.useOpentrackers";
    public static final String DEFAULT_USE_OPENTRACKERS = "true";
    public static final String PROP_OPENTRACKERS = "i2psnark.opentrackers";
    public static final String DEFAULT_OPENTRACKERS = "http://tracker.welterde.i2p/a";
    public static final String PROP_LINK_PREFIX = "i2psnark.linkPrefix";
    public static final String DEFAULT_LINK_PREFIX = "file:///";
    public static final int MIN_UP_BW = 2;
    public static final int DEFAULT_MAX_UP_BW = 10;
    private static final int MAX_MESSAGES = 5;
    private static final int MAX_FILES_PER_TORRENT = 128;
    private static final String[] DEFAULT_TRACKERS = new String[]{"Postman", "http://YRgrgTLGnbTq2aZOZDJQ~o6Uk5k6TK-OZtx0St9pb0G-5EGYURZioxqYG8AQt~LgyyI~NCj6aYWpPO-150RcEvsfgXLR~CxkkZcVpgt6pns8SRc3Bi-QSAkXpJtloapRGcQfzTtwllokbdC-aMGpeDOjYLd8b5V9Im8wdCHYy7LRFxhEtGb~RL55DA8aYOgEXcTpr6RPPywbV~Qf3q5UK55el6Kex-6VCxreUnPEe4hmTAbqZNR7Fm0hpCiHKGoToRcygafpFqDw5frLXToYiqs9d4liyVB-BcOb0ihORbo0nS3CLmAwZGvdAP8BZ7cIYE3Z9IU9D1G8JCMxWarfKX1pix~6pIA-sp1gKlL1HhYhPMxwyxvuSqx34o3BqU7vdTYwWiLpGM~zU1~j9rHL7x60pVuYaXcFQDR4-QVy26b6Pt6BlAZoFmHhPcAuWfu-SFhjyZYsqzmEmHeYdAwa~HojSbofg0TMUgESRXMw6YThK1KXWeeJVeztGTz25sL8AAAA.i2p/announce.php=http://tracker.postman.i2p/", "welterde", "http://BGKmlDOoH3RzFbPRfRpZV2FjpVj8~3moFftw5-dZfDf2070TOe8Tf2~DAVeaM6ZRLdmFEt~9wyFL8YMLMoLoiwGEH6IGW6rc45tstN68KsBDWZqkTohV1q9XFgK9JnCwE~Oi89xLBHsLMTHOabowWM6dkC8nI6QqJC2JODqLPIRfOVrDdkjLwtCrsckzLybNdFmgfoqF05UITDyczPsFVaHtpF1sRggOVmdvCM66otyonlzNcJbn59PA-R808vUrCPMGU~O9Wys0i-NoqtIbtWfOKnjCRFMNw5ex4n9m5Sxm9e20UkpKG6qzEuvKZWi8vTLe1NW~CBrj~vG7I3Ok4wybUFflBFOaBabxYJLlx4xTE1zJIVxlsekmAjckB4v-cQwulFeikR4LxPQ6mCQknW2HZ4JQIq6hL9AMabxjOlYnzh7kjOfRGkck8YgeozcyTvcDUcUsOuSTk06L4kdrv8h2Cozjbloi5zl6KTbj5ZTciKCxi73Pn9grICn-HQqEAAAA.i2p/a=http://tracker.welterde.i2p/stats?mode=top5"};
    public static final String PROP_TRACKERS = "i2psnark.trackers";
    private static Map trackerMap = null;

    public static SnarkManager instance() {
        return _instance;
    }

    private SnarkManager() {
        this.loadConfig("i2psnark.config");
        int minutes = this.getStartupDelayMinutes();
        this._messages.add("Adding torrents in " + minutes + (minutes == 1 ? " minute" : " minutes"));
        I2PThread monitor = new I2PThread(new DirMonitor(), "Snark DirMonitor");
        monitor.setDaemon(true);
        monitor.start();
        if (this._context instanceof RouterContext) {
            ((RouterContext)this._context).router().addShutdownTask((Runnable)new SnarkManagerShutdown());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(String message) {
        List list = this._messages;
        synchronized (list) {
            this._messages.add(message);
            while (this._messages.size() > 5) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("MSG: " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMessages() {
        List list = this._messages;
        synchronized (list) {
            return new ArrayList(this._messages);
        }
    }

    public boolean shouldAutoStart() {
        return Boolean.valueOf(this._config.getProperty(PROP_AUTO_START, DEFAULT_AUTO_START));
    }

    public boolean shouldUseOpenTrackers() {
        return Boolean.valueOf(this._config.getProperty(PROP_USE_OPENTRACKERS, DEFAULT_USE_OPENTRACKERS));
    }

    public String linkPrefix() {
        return this._config.getProperty(PROP_LINK_PREFIX, DEFAULT_LINK_PREFIX + this.getDataDir().getAbsolutePath() + File.separatorChar);
    }

    private int getStartupDelayMinutes() {
        return 3;
    }

    public File getDataDir() {
        String dir = this._config.getProperty(PROP_DIR);
        if (dir == null || dir.trim().length() <= 0) {
            dir = "i2psnark";
        }
        return new File(dir);
    }

    public void loadConfig(String filename) {
        File cfg;
        this._configFile = filename;
        if (this._config == null) {
            this._config = new Properties();
        }
        if ((cfg = new File(filename)).exists()) {
            try {
                DataHelper.loadProps(this._config, cfg);
            }
            catch (IOException ioe) {
                this._log.error("Error loading I2PSnark config '" + filename + "'", ioe);
            }
        }
        if (!this._config.containsKey(PROP_I2CP_HOST)) {
            this._config.setProperty(PROP_I2CP_HOST, "localhost");
        }
        if (!this._config.containsKey(PROP_I2CP_PORT)) {
            this._config.setProperty(PROP_I2CP_PORT, "7654");
        }
        if (!this._config.containsKey(PROP_I2CP_OPTS)) {
            this._config.setProperty(PROP_I2CP_OPTS, "inbound.length=2 inbound.lengthVariance=0 outbound.length=2 outbound.lengthVariance=0");
        }
        if (!this._config.containsKey(PROP_EEP_HOST)) {
            this._config.setProperty(PROP_EEP_HOST, "localhost");
        }
        if (!this._config.containsKey(PROP_EEP_PORT)) {
            this._config.setProperty(PROP_EEP_PORT, "4444");
        }
        if (!this._config.containsKey(PROP_UPLOADERS_TOTAL)) {
            this._config.setProperty(PROP_UPLOADERS_TOTAL, "10");
        }
        if (!this._config.containsKey(PROP_UPBW_MAX)) {
            try {
                if (this._context instanceof RouterContext) {
                    this._config.setProperty(PROP_UPBW_MAX, "" + ((RouterContext)this._context).bandwidthLimiter().getOutboundKBytesPerSecond() / 2);
                } else {
                    this._config.setProperty(PROP_UPBW_MAX, "10");
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                this._config.setProperty(PROP_UPBW_MAX, "10");
            }
        }
        if (!this._config.containsKey(PROP_DIR)) {
            this._config.setProperty(PROP_DIR, "i2psnark");
        }
        if (!this._config.containsKey(PROP_AUTO_START)) {
            this._config.setProperty(PROP_AUTO_START, DEFAULT_AUTO_START);
        }
        this.updateConfig();
    }

    private void updateConfig() {
        String i2cpHost = this._config.getProperty(PROP_I2CP_HOST);
        int i2cpPort = this.getInt(PROP_I2CP_PORT, 7654);
        String opts = this._config.getProperty(PROP_I2CP_OPTS);
        HashMap<String, String> i2cpOpts = new HashMap<String, String>();
        if (opts != null) {
            StringTokenizer tok = new StringTokenizer(opts, " ");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                i2cpOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
        }
        if (i2cpHost != null) {
            I2PSnarkUtil.instance().setI2CPConfig(i2cpHost, i2cpPort, i2cpOpts);
            this._log.debug("Configuring with I2CP options " + i2cpOpts);
        }
        String eepHost = this._config.getProperty(PROP_EEP_HOST);
        int eepPort = this.getInt(PROP_EEP_PORT, 4444);
        if (eepHost != null) {
            I2PSnarkUtil.instance().setProxy(eepHost, eepPort);
        }
        I2PSnarkUtil.instance().setMaxUploaders(this.getInt(PROP_UPLOADERS_TOTAL, 10));
        I2PSnarkUtil.instance().setMaxUpBW(this.getInt(PROP_UPBW_MAX, 10));
        this.getDataDir().mkdirs();
    }

    private int getInt(String prop, int defaultVal) {
        String p = this._config.getProperty(prop);
        try {
            if (p != null && p.trim().length() > 0) {
                return Integer.parseInt(p.trim());
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultVal;
    }

    public void updateConfig(String dataDir, boolean autoStart, String seedPct, String eepHost, String eepPort, String i2cpHost, String i2cpPort, String i2cpOpts, String upLimit, String upBW, boolean useOpenTrackers, String openTrackers) {
        int limit;
        boolean changed = false;
        if (eepHost != null) {
            int port = I2PSnarkUtil.instance().getEepProxyPort();
            try {
                port = Integer.parseInt(eepPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String host = I2PSnarkUtil.instance().getEepProxyHost();
            if (!(eepHost.trim().length() <= 0 || port <= 0 || host.equals(eepHost) && port == I2PSnarkUtil.instance().getEepProxyPort())) {
                I2PSnarkUtil.instance().setProxy(eepHost, port);
                changed = true;
                this._config.setProperty(PROP_EEP_HOST, eepHost);
                this._config.setProperty(PROP_EEP_PORT, eepPort + "");
                this.addMessage("EepProxy location changed to " + eepHost + ":" + port);
            }
        }
        if (upLimit != null) {
            limit = I2PSnarkUtil.instance().getMaxUploaders();
            try {
                limit = Integer.parseInt(upLimit);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (limit != I2PSnarkUtil.instance().getMaxUploaders()) {
                if (limit >= 4) {
                    I2PSnarkUtil.instance().setMaxUploaders(limit);
                    changed = true;
                    this._config.setProperty(PROP_UPLOADERS_TOTAL, "" + limit);
                    this.addMessage("Total uploaders limit changed to " + limit);
                } else {
                    this.addMessage("Minimum total uploaders limit is 4");
                }
            }
        }
        if (upBW != null) {
            limit = I2PSnarkUtil.instance().getMaxUpBW();
            try {
                limit = Integer.parseInt(upBW);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (limit != I2PSnarkUtil.instance().getMaxUpBW()) {
                if (limit >= 2) {
                    I2PSnarkUtil.instance().setMaxUpBW(limit);
                    changed = true;
                    this._config.setProperty(PROP_UPBW_MAX, "" + limit);
                    this.addMessage("Up BW limit changed to " + limit + "KBps");
                } else {
                    this.addMessage("Minimum Up BW limit is 2KBps");
                }
            }
        }
        if (i2cpHost != null) {
            int oldI2CPPort = I2PSnarkUtil.instance().getI2CPPort();
            String oldI2CPHost = I2PSnarkUtil.instance().getI2CPHost();
            int port = oldI2CPPort;
            try {
                port = Integer.parseInt(i2cpPort);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            String host = oldI2CPHost;
            HashMap<String, String> opts = new HashMap<String, String>();
            if (i2cpOpts == null) {
                i2cpOpts = "";
            }
            StringTokenizer tok = new StringTokenizer(i2cpOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                opts.put(pair.substring(0, split), pair.substring(split + 1));
            }
            HashMap<String, String> oldOpts = new HashMap<String, String>();
            String oldI2CPOpts = this._config.getProperty(PROP_I2CP_OPTS);
            if (oldI2CPOpts == null) {
                oldI2CPOpts = "";
            }
            tok = new StringTokenizer(oldI2CPOpts, " \t\n");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                oldOpts.put(pair.substring(0, split), pair.substring(split + 1));
            }
            if (!(i2cpHost.trim().length() <= 0 || port <= 0 || host.equals(i2cpHost) && port == I2PSnarkUtil.instance().getI2CPPort() && ((Object)oldOpts).equals(opts))) {
                boolean snarksActive = false;
                Set names = this.listTorrentFiles();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    Snark snark = this.getTorrent((String)iter.next());
                    if (snark == null || snark.stopped) continue;
                    snarksActive = true;
                    break;
                }
                if (snarksActive) {
                    this.addMessage("Cannot change the I2CP settings while torrents are active");
                    this._log.debug("i2cp host [" + i2cpHost + "] i2cp port " + port + " opts [" + opts + "] oldOpts [" + oldOpts + "]");
                } else {
                    if (I2PSnarkUtil.instance().connected()) {
                        I2PSnarkUtil.instance().disconnect();
                        this.addMessage("Disconnecting old I2CP destination");
                    }
                    Properties p = new Properties();
                    p.putAll((Map<?, ?>)opts);
                    this.addMessage("I2CP settings changed to " + i2cpHost + ":" + port + " (" + i2cpOpts.trim() + ")");
                    I2PSnarkUtil.instance().setI2CPConfig(i2cpHost, port, p);
                    boolean ok = I2PSnarkUtil.instance().connect();
                    if (!ok) {
                        this.addMessage("Unable to connect with the new settings, reverting to the old I2CP settings");
                        I2PSnarkUtil.instance().setI2CPConfig(oldI2CPHost, oldI2CPPort, oldOpts);
                        ok = I2PSnarkUtil.instance().connect();
                        if (!ok) {
                            this.addMessage("Unable to reconnect with the old settings!");
                        }
                    } else {
                        this.addMessage("Reconnected on the new I2CP destination");
                        this._config.setProperty(PROP_I2CP_HOST, i2cpHost.trim());
                        this._config.setProperty(PROP_I2CP_PORT, "" + port);
                        this._config.setProperty(PROP_I2CP_OPTS, i2cpOpts.trim());
                        changed = true;
                        for (String name : names) {
                            Snark snark = this.getTorrent(name);
                            if (snark == null || snark.acceptor == null) continue;
                            snark.acceptor.restart();
                            this.addMessage("I2CP listener restarted for " + snark.meta.getName());
                        }
                    }
                }
                changed = true;
            }
        }
        if (this.shouldAutoStart() != autoStart) {
            this._config.setProperty(PROP_AUTO_START, autoStart + "");
            this.addMessage("Adjusted autostart to " + autoStart);
            changed = true;
        }
        if (this.shouldUseOpenTrackers() != useOpenTrackers) {
            this._config.setProperty(PROP_USE_OPENTRACKERS, useOpenTrackers + "");
            this.addMessage((useOpenTrackers ? "En" : "Dis") + "abled open trackers - torrent restart required to take effect");
            changed = true;
        }
        if (openTrackers != null && openTrackers.trim().length() > 0 && !openTrackers.trim().equals(this.getOpenTrackerString())) {
            this._config.setProperty(PROP_OPENTRACKERS, openTrackers.trim());
            this.addMessage("Open Tracker list changed - torrent restart required to take effect");
            changed = true;
        }
        if (changed) {
            this.saveConfig();
        } else {
            this.addMessage("Configuration unchanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfig() {
        try {
            String string = this._configFile;
            synchronized (string) {
                DataHelper.storeProps(this._config, new File(this._configFile));
            }
        }
        catch (IOException ioe) {
            this.addMessage("Unable to save the config to '" + this._configFile + "'");
        }
    }

    public Properties getConfig() {
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set listTorrentFiles() {
        Map map = this._snarks;
        synchronized (map) {
            return new HashSet(this._snarks.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark getTorrent(String filename) {
        Map map = this._snarks;
        synchronized (map) {
            return (Snark)this._snarks.get(filename);
        }
    }

    public void addTorrent(String filename) {
        this.addTorrent(filename, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addTorrent(String filename, boolean dontAutoStart) {
        Snark torrent;
        block31: {
            if (!dontAutoStart && !I2PSnarkUtil.instance().connected()) {
                this.addMessage("Connecting to I2P");
                boolean ok = I2PSnarkUtil.instance().connect();
                if (!ok) {
                    this.addMessage("Error connecting to I2P - check your I2CP settings");
                    return;
                }
            }
            File sfile = new File(filename);
            try {
                filename = sfile.getCanonicalPath();
            }
            catch (IOException ioe) {
                this._log.error("Unable to add the torrent " + filename, ioe);
                this.addMessage("ERR: Could not add the torrent '" + filename + "': " + ioe.getMessage());
                return;
            }
            File dataDir = this.getDataDir();
            torrent = null;
            Object object = this._snarks;
            synchronized (object) {
                torrent = (Snark)this._snarks.get(filename);
            }
            if (torrent != null) return;
            object = this._addSnarkLock;
            synchronized (object) {
                FileInputStream fis;
                block30: {
                    Map map = this._snarks;
                    synchronized (map) {
                        if (this._snarks.get(filename) != null) {
                            return;
                        }
                    }
                    fis = null;
                    try {
                        fis = new FileInputStream(sfile);
                        MetaInfo info = new MetaInfo(fis);
                        fis.close();
                        fis = null;
                        String rejectMessage = this.locked_validateTorrent(info);
                        if (rejectMessage != null) {
                            sfile.delete();
                            this.addMessage(rejectMessage);
                            break block30;
                        }
                        torrent = new Snark(filename, null, -1, null, null, false, dataDir.getPath());
                        torrent.completeListener = this;
                        Map map2 = this._snarks;
                        synchronized (map2) {
                            this._snarks.put(filename, torrent);
                            break block31;
                        }
                    }
                    catch (IOException ioe) {
                        this.addMessage("Torrent in " + sfile.getName() + " is invalid: " + ioe.getMessage());
                        if (!sfile.exists()) return;
                        sfile.delete();
                        return;
                    }
                }
                return;
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        File f = new File(filename);
        if (!dontAutoStart && this.shouldAutoStart()) {
            torrent.startTorrent();
            this.addMessage("Torrent added and started: '" + f.getName() + "'");
            return;
        }
        this.addMessage("Torrent added: '" + f.getName() + "'");
    }

    public long getSavedTorrentTime(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String time = this._config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        if (time == null) {
            return 0L;
        }
        int comma = time.indexOf(44);
        if (comma <= 0) {
            return 0L;
        }
        time = time.substring(0, comma);
        try {
            return Long.parseLong(time);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public BitField getSavedTorrentBitField(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String bf = this._config.getProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        if (bf == null) {
            return null;
        }
        int comma = bf.indexOf(44);
        if (comma <= 0) {
            return null;
        }
        bf = bf.substring(comma + 1).trim();
        int len = metainfo.getPieces();
        if (bf.equals(".")) {
            BitField bitfield = new BitField(len);
            for (int i = 0; i < len; ++i) {
                bitfield.set(i);
            }
            return bitfield;
        }
        byte[] bitfield = Base64.decode(bf);
        if (bitfield == null) {
            return null;
        }
        if (bitfield.length * 8 < len) {
            return null;
        }
        return new BitField(bitfield, len);
    }

    public void saveTorrentStatus(MetaInfo metainfo, BitField bitfield) {
        String bfs;
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        String now = "" + System.currentTimeMillis();
        if (bitfield.complete()) {
            bfs = ".";
        } else {
            byte[] bf = bitfield.getFieldBytes();
            bfs = Base64.encode(bf);
        }
        this._config.setProperty(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX, now + "," + bfs);
        this.saveConfig();
    }

    public void removeTorrentStatus(MetaInfo metainfo) {
        byte[] ih = metainfo.getInfoHash();
        String infohash = Base64.encode(ih);
        infohash = infohash.replace('=', '$');
        this._config.remove(PROP_META_PREFIX + infohash + PROP_META_BITFIELD_SUFFIX);
        this.saveConfig();
    }

    private String locked_validateTorrent(MetaInfo info) throws IOException {
        String announce = info.getAnnounce();
        if (!announce.startsWith("http://") || announce.indexOf(".i2p/") < 0) {
            return "Non-i2p tracker in " + info.getName() + ", deleting it";
        }
        List files = info.getFiles();
        if (files != null && files.size() > 128) {
            return "Too many files in " + info.getName() + " (" + files.size() + "), deleting it";
        }
        if (info.getPieces() <= 0) {
            return "No pieces in " + info.getName() + "?  deleting it";
        }
        if (info.getPieceLength(0) > 0x100000) {
            return "Pieces are too large in " + info.getName() + " (" + info.getPieceLength(0) / 1024 + "KB), deleting it";
        }
        if (info.getTotalLength() > 0x280000000L) {
            System.out.println("torrent info: " + info.toString());
            List lengths = info.getLengths();
            if (lengths != null) {
                for (int i = 0; i < lengths.size(); ++i) {
                    System.out.println("File " + i + " is " + lengths.get(i) + " long");
                }
            }
            return "Torrents larger than 10GB are not supported yet (because we're paranoid): " + info.getName() + ", deleting it";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Snark stopTorrent(String filename, boolean shouldRemove) {
        File sfile = new File(filename);
        try {
            filename = sfile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this._log.error("Unable to remove the torrent " + filename, ioe);
            this.addMessage("ERR: Could not remove the torrent '" + filename + "': " + ioe.getMessage());
            return null;
        }
        int remaining = 0;
        Snark torrent = null;
        Map map = this._snarks;
        synchronized (map) {
            torrent = shouldRemove ? (Snark)this._snarks.remove(filename) : (Snark)this._snarks.get(filename);
            remaining = this._snarks.size();
        }
        if (torrent != null) {
            boolean wasStopped = torrent.stopped;
            torrent.stopTorrent();
            if (remaining == 0) {
                // empty if block
            }
            if (!wasStopped) {
                this.addMessage("Torrent stopped: '" + sfile.getName() + "'");
            }
        }
        return torrent;
    }

    public void removeTorrent(String filename) {
        Snark torrent = this.stopTorrent(filename, true);
        if (torrent != null) {
            File torrentFile = new File(filename);
            torrentFile.delete();
            if (torrent.storage != null) {
                this.removeTorrentStatus(torrent.storage.getMetaInfo());
            }
            this.addMessage("Torrent removed: '" + torrentFile.getName() + "'");
        }
    }

    public void torrentComplete(Snark snark) {
        File f = new File(snark.torrent);
        long len = snark.meta.getTotalLength();
        this.addMessage("Download complete of " + f.getName() + (len < 0x500000L ? " (size: " + len / 1024L + "KB)" : " (size: " + len / 0x100000L + "MB)"));
    }

    private void monitorTorrents(File dir) {
        String[] fileNames = dir.list(TorrentFilenameFilter.instance());
        ArrayList<String> foundNames = new ArrayList<String>(0);
        if (fileNames != null) {
            for (int i = 0; i < fileNames.length; ++i) {
                try {
                    foundNames.add(new File(dir, fileNames[i]).getCanonicalPath());
                    continue;
                }
                catch (IOException ioe) {
                    this._log.error("Error resolving '" + fileNames[i] + "' in '" + dir, ioe);
                }
            }
        }
        Set existingNames = this.listTorrentFiles();
        for (int i = 0; i < foundNames.size(); ++i) {
            if (existingNames.contains(foundNames.get(i))) continue;
            if (this.shouldAutoStart() && !I2PSnarkUtil.instance().connect()) {
                this.addMessage("Unable to connect to I2P");
            }
            this.addTorrent((String)foundNames.get(i), !this.shouldAutoStart());
        }
        for (String name : existingNames) {
            if (foundNames.contains(name)) continue;
            this.stopTorrent(name, true);
        }
    }

    public Map getTrackers() {
        if (trackerMap != null) {
            return trackerMap;
        }
        TreeMap<String, String> rv = new TreeMap<String, String>();
        String trackers = this._config.getProperty(PROP_TRACKERS);
        if (trackers == null || trackers.trim().length() <= 0) {
            trackers = this._context.getProperty(PROP_TRACKERS);
        }
        if (trackers == null || trackers.trim().length() <= 0) {
            for (int i = 0; i < DEFAULT_TRACKERS.length; i += 2) {
                rv.put(DEFAULT_TRACKERS[i], DEFAULT_TRACKERS[i + 1]);
            }
        } else {
            StringTokenizer tok = new StringTokenizer(trackers, ",");
            while (tok.hasMoreTokens()) {
                String pair = tok.nextToken();
                int split = pair.indexOf(61);
                if (split <= 0) continue;
                String name = pair.substring(0, split).trim();
                String url = pair.substring(split + 1).trim();
                if (name.length() <= 0 || url.length() <= 0) continue;
                rv.put(name, url);
            }
        }
        trackerMap = rv;
        return trackerMap;
    }

    public String getOpenTrackerString() {
        return this._config.getProperty(PROP_OPENTRACKERS, DEFAULT_OPENTRACKERS);
    }

    public List getOpenTrackers() {
        if (!this.shouldUseOpenTrackers()) {
            return null;
        }
        ArrayList<String> rv = new ArrayList<String>(1);
        String trackers = this.getOpenTrackerString();
        StringTokenizer tok = new StringTokenizer(trackers, ", ");
        while (tok.hasMoreTokens()) {
            rv.add(tok.nextToken());
        }
        if (rv.size() <= 0) {
            return null;
        }
        return rv;
    }

    public class SnarkManagerShutdown
    extends I2PThread {
        public void run() {
            Set names = SnarkManager.this.listTorrentFiles();
            Iterator iter = names.iterator();
            while (iter.hasNext()) {
                Snark snark = SnarkManager.this.getTorrent((String)iter.next());
                if (snark == null || snark.stopped) continue;
                snark.stopTorrent();
            }
        }
    }

    private static class TorrentFilenameFilter
    implements FilenameFilter {
        private static final TorrentFilenameFilter _filter = new TorrentFilenameFilter();

        private TorrentFilenameFilter() {
        }

        public static TorrentFilenameFilter instance() {
            return _filter;
        }

        public boolean accept(File dir, String name) {
            return name != null && name.endsWith(".torrent");
        }
    }

    private class DirMonitor
    implements Runnable {
        private DirMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(60000 * SnarkManager.this.getStartupDelayMinutes());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            List ie = SnarkManager.this._messages;
            synchronized (ie) {
                if (SnarkManager.this._messages.size() == 1) {
                    SnarkManager.this._messages.remove(0);
                }
            }
            while (true) {
                File dir = SnarkManager.this.getDataDir();
                SnarkManager.this._log.debug("Directory Monitor loop over " + dir.getAbsolutePath());
                try {
                    SnarkManager.this.monitorTorrents(dir);
                }
                catch (Exception e) {
                    SnarkManager.this._log.error("Error in the DirectoryMonitor", e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

