/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.Peer;
import org.klomp.snark.PeerID;
import org.klomp.snark.Snark;
import org.klomp.snark.bencode.BDecoder;
import org.klomp.snark.bencode.BEValue;
import org.klomp.snark.bencode.InvalidBEncodingException;

public class TrackerInfo {
    private final String failure_reason;
    private final int interval;
    private final Set peers;

    public TrackerInfo(InputStream in, byte[] my_id, MetaInfo metainfo) throws IOException {
        this(new BDecoder(in), my_id, metainfo);
    }

    public TrackerInfo(BDecoder be, byte[] my_id, MetaInfo metainfo) throws IOException {
        this(be.bdecodeMap().getMap(), my_id, metainfo);
    }

    public TrackerInfo(Map m, byte[] my_id, MetaInfo metainfo) throws IOException {
        BEValue reason = (BEValue)m.get("failure reason");
        if (reason != null) {
            this.failure_reason = reason.getString();
            this.interval = -1;
            this.peers = null;
        } else {
            this.failure_reason = null;
            BEValue beInterval = (BEValue)m.get("interval");
            if (beInterval == null) {
                throw new InvalidBEncodingException("No interval given");
            }
            this.interval = beInterval.getInt();
            BEValue bePeers = (BEValue)m.get("peers");
            if (bePeers == null) {
                throw new InvalidBEncodingException("No peer list");
            }
            this.peers = TrackerInfo.getPeers(bePeers.getList(), my_id, metainfo);
        }
    }

    public static Set getPeers(InputStream in, byte[] my_id, MetaInfo metainfo) throws IOException {
        return TrackerInfo.getPeers(new BDecoder(in), my_id, metainfo);
    }

    public static Set getPeers(BDecoder be, byte[] my_id, MetaInfo metainfo) throws IOException {
        return TrackerInfo.getPeers(be.bdecodeList().getList(), my_id, metainfo);
    }

    public static Set getPeers(List l, byte[] my_id, MetaInfo metainfo) throws IOException {
        HashSet<Peer> peers = new HashSet<Peer>(l.size());
        Iterator it = l.iterator();
        while (it.hasNext()) {
            PeerID peerID;
            try {
                peerID = new PeerID(((BEValue)it.next()).getMap());
            }
            catch (InvalidBEncodingException ibe) {
                Snark.debug("Discarding peer from list: " + ibe, 1);
                continue;
            }
            peers.add(new Peer(peerID, my_id, metainfo));
        }
        return peers;
    }

    public Set getPeers() {
        return this.peers;
    }

    public String getFailureReason() {
        return this.failure_reason;
    }

    public int getInterval() {
        return this.interval;
    }

    public String toString() {
        if (this.failure_reason != null) {
            return "TrackerInfo[FAILED: " + this.failure_reason + "]";
        }
        return "TrackerInfo[interval=" + this.interval + ", peers=" + this.peers + "]";
    }
}

