/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

class ByteCollector {
    byte[] contents;
    int size;
    private static final int INITIAL_CAPACITY = 1024;
    private static final int SHORT_CAPACITY = 80;

    public ByteCollector() {
        this(1024);
    }

    public ByteCollector(int capacity) {
        this.contents = new byte[capacity];
        this.size = 0;
    }

    public ByteCollector(byte[] b) {
        this();
        this.append(b);
    }

    public ByteCollector(byte b) {
        this();
        this.append(b);
    }

    public ByteCollector append(byte b) {
        this.ensureCapacity(this.size + 1);
        this.contents[this.size++] = b;
        return this;
    }

    public ByteCollector append(byte[] b) {
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.contents, this.size, b.length);
        this.size += b.length;
        return this;
    }

    public ByteCollector append(byte[] b, int len) {
        return this.append(b, 0, len);
    }

    public ByteCollector append(byte[] b, int off, int len) {
        this.ensureCapacity(this.size + len);
        System.arraycopy(b, off, this.contents, this.size, len);
        this.size += len;
        return this;
    }

    public ByteCollector append(ByteCollector bc) {
        return this.append(bc.toByteArray());
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.size];
        System.arraycopy(this.contents, 0, result, 0, this.size);
        return result;
    }

    public byte[] startToByteArray(int maxlen) {
        if (this.size < maxlen) {
            byte[] res = this.toByteArray();
            this.clear();
            return res;
        }
        byte[] result = new byte[maxlen];
        System.arraycopy(this.contents, 0, result, 0, maxlen);
        System.arraycopy(this.contents, maxlen, this.contents, 0, this.size - maxlen);
        this.size -= maxlen;
        return result;
    }

    public int getCurrentSize() {
        return this.size;
    }

    public boolean ensureCapacity(int cap) {
        if (this.contents.length < cap) {
            int l = this.contents.length;
            while (l < cap) {
                l = l * 3 / 2 + 1;
            }
            byte[] newcont = new byte[l];
            System.arraycopy(this.contents, 0, newcont, 0, this.size);
            this.contents = newcont;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int indexOf(ByteCollector bc) {
        return this.indexOf(bc.toByteArray());
    }

    public int indexOf(byte b) {
        return this.indexOf(new byte[]{b});
    }

    public int indexOf(byte[] ba) {
        block0: for (int i = 0; i < this.size - ba.length + 1; ++i) {
            for (int j = 0; j < ba.length; ++j) {
                if (this.contents[i + j] != ba[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public void clear() {
        this.size = 0;
    }

    public void clearAndShorten() {
        this.size = 0;
        this.contents = new byte[80];
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h += this.contents[i] * this.contents[i];
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof ByteCollector) {
            ByteCollector by = (ByteCollector)o;
            if (this.size != by.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (this.contents[i] == by.contents[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte removeFirst() throws IllegalArgumentException {
        byte bb = this.contents[0];
        if (this.size == 0) {
            throw new IllegalArgumentException("ByteCollector is empty");
        }
        if (this.size > 1) {
            System.arraycopy(this.contents, 1, this.contents, 0, --this.size);
        } else {
            this.size = 0;
        }
        return bb;
    }
}

