/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.I2PServerSocket;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.util.Clock;
import net.i2p.util.Log;

class I2PServerSocketImpl
implements I2PServerSocket {
    private static final Log _log = new Log(I2PServerSocketImpl.class);
    private I2PSocketManager mgr;
    private List pendingSockets = Collections.synchronizedList(new ArrayList(4));
    private volatile boolean closing = false;
    private Object socketAcceptedLock = new Object();
    private Object socketAddedLock = new Object();

    public void setSoTimeout(long x) {
    }

    public long getSoTimeout() {
        return -1L;
    }

    public I2PServerSocketImpl(I2PSocketManager mgr) {
        this.mgr = mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket accept() throws I2PException, ConnectException {
        if (_log.shouldLog(10)) {
            _log.debug("accept() called, pending: " + this.pendingSockets.size());
        }
        Object ret = null;
        while (ret == null && !this.closing) {
            Object object;
            while (this.pendingSockets.size() <= 0) {
                if (this.closing) {
                    throw new ConnectException("I2PServerSocket closed");
                }
                try {
                    object = this.socketAddedLock;
                    synchronized (object) {
                        this.socketAddedLock.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            object = this.pendingSockets;
            synchronized (object) {
                if (this.pendingSockets.size() > 0) {
                    ret = (I2PSocket)this.pendingSockets.remove(0);
                }
            }
            if (ret == null) continue;
            object = this.socketAcceptedLock;
            synchronized (object) {
                this.socketAcceptedLock.notifyAll();
            }
        }
        if (_log.shouldLog(10)) {
            _log.debug("TIMING: handed out accept result " + ret.hashCode());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWaitForAccept(I2PSocket s, long timeoutMs) {
        if (_log.shouldLog(10)) {
            _log.debug("addWaitForAccept [new socket arrived [" + s.toString() + "], pending: " + this.pendingSockets.size());
        }
        if (this.closing) {
            if (_log.shouldLog(30)) {
                _log.warn("Already closing the socket");
            }
            return false;
        }
        Clock clock = I2PAppContext.getGlobalContext().clock();
        long start = clock.now();
        long end = start + timeoutMs;
        this.pendingSockets.add(s);
        Object object = this.socketAddedLock;
        synchronized (object) {
            this.socketAddedLock.notifyAll();
        }
        while (this.pendingSockets.contains(s)) {
            long now = clock.now();
            if (now >= end) {
                if (_log.shouldLog(20)) {
                    _log.info("Expired while waiting for accept (time elapsed =" + (now - start) + "ms) for socket " + s.toString());
                }
                this.pendingSockets.remove(s);
                return false;
            }
            if (this.closing) {
                if (_log.shouldLog(30)) {
                    _log.warn("Server socket closed while waiting for accept");
                }
                this.pendingSockets.remove(s);
                return false;
            }
            long remaining = end - now;
            try {
                Object object2 = this.socketAcceptedLock;
                synchronized (object2) {
                    this.socketAcceptedLock.wait(remaining);
                }
            }
            catch (InterruptedException ie) {
            }
        }
        long now = clock.now();
        if (_log.shouldLog(10)) {
            _log.info("Socket accepted after " + (now - start) + "ms for socket " + s.toString());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closing = true;
        Object object = this.socketAddedLock;
        synchronized (object) {
            this.socketAddedLock.notifyAll();
        }
        object = this.socketAcceptedLock;
        synchronized (object) {
            this.socketAcceptedLock.notifyAll();
        }
    }

    public I2PSocketManager getManager() {
        return this.mgr;
    }
}

