/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.util.Log;

public class I2PSocketManagerFactory {
    private static final Log _log = new Log(I2PSocketManagerFactory.class);
    public static final String PROP_MANAGER = "i2p.streaming.manager";
    public static final String DEFAULT_MANAGER = "net.i2p.client.streaming.I2PSocketManagerFull";

    public static I2PSocketManager createManager() {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), System.getProperties());
    }

    public static I2PSocketManager createManager(Properties opts) {
        return I2PSocketManagerFactory.createManager(I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts);
    }

    public static I2PSocketManager createManager(String host, int port) {
        return I2PSocketManagerFactory.createManager(host, port, System.getProperties());
    }

    public static I2PSocketManager createManager(String i2cpHost, int i2cpPort, Properties opts) {
        I2PClient client = I2PClientFactory.createClient();
        ByteArrayOutputStream keyStream = new ByteArrayOutputStream(512);
        try {
            client.createDestination((OutputStream)keyStream);
            ByteArrayInputStream in = new ByteArrayInputStream(keyStream.toByteArray());
            return I2PSocketManagerFactory.createManager(in, i2cpHost, i2cpPort, opts);
        }
        catch (IOException ioe) {
            _log.error("Error creating the destination for socket manager", (Throwable)ioe);
            return null;
        }
        catch (I2PException ie) {
            _log.error("Error creating the destination for socket manager", (Throwable)ie);
            return null;
        }
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), System.getProperties());
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, Properties opts) {
        return I2PSocketManagerFactory.createManager(myPrivateKeyStream, I2PSocketManagerFactory.getHost(), I2PSocketManagerFactory.getPort(), opts);
    }

    public static I2PSocketManager createManager(InputStream myPrivateKeyStream, String i2cpHost, int i2cpPort, Properties opts) {
        I2PClient client = I2PClientFactory.createClient();
        if (opts == null) {
            opts = new Properties();
        }
        for (String string : System.getProperties().keySet()) {
            if (opts.containsKey(string)) continue;
            opts.setProperty(string, System.getProperty(string));
        }
        boolean oldLib = DEFAULT_MANAGER.equals(opts.getProperty(PROP_MANAGER, DEFAULT_MANAGER));
        if (oldLib) {
            // empty if block
        }
        opts.setProperty("i2cp.messageReliability", "BestEffort");
        if (i2cpHost != null) {
            opts.setProperty("i2cp.tcp.host", i2cpHost);
        }
        if (i2cpPort > 0) {
            opts.setProperty("i2cp.tcp.port", "" + i2cpPort);
        }
        try {
            I2PSession i2PSession = client.createSession(myPrivateKeyStream, opts);
            i2PSession.connect();
            I2PSocketManager sockMgr = I2PSocketManagerFactory.createManager(i2PSession, opts, "manager");
            return sockMgr;
        }
        catch (I2PSessionException i2PSessionException) {
            _log.error("Error creating session for socket manager", (Throwable)i2PSessionException);
            return null;
        }
    }

    private static I2PSocketManager createManager(I2PSession session, Properties opts, String name) {
        String classname = opts.getProperty(PROP_MANAGER, DEFAULT_MANAGER);
        if (classname != null) {
            try {
                Class<?> cls = Class.forName(classname);
                Object obj = cls.newInstance();
                if (obj instanceof I2PSocketManager) {
                    I2PSocketManager mgr = (I2PSocketManager)obj;
                    I2PAppContext context = I2PAppContext.getGlobalContext();
                    mgr.init(context, session, opts, name);
                    return mgr;
                }
                throw new IllegalStateException("Invalid manager class [" + classname + "]");
            }
            catch (ClassNotFoundException cnfe) {
                _log.error("Error loading " + classname, (Throwable)cnfe);
                throw new IllegalStateException("Invalid manager class [" + classname + "] - not found");
            }
            catch (InstantiationException ie) {
                _log.error("Error loading " + classname, (Throwable)ie);
                throw new IllegalStateException("Invalid manager class [" + classname + "] - unable to instantiate");
            }
            catch (IllegalAccessException iae) {
                _log.error("Error loading " + classname, (Throwable)iae);
                throw new IllegalStateException("Invalid manager class [" + classname + "] - illegal access");
            }
        }
        throw new IllegalStateException("No manager class specified");
    }

    private static String getHost() {
        return System.getProperty("i2cp.tcp.host", "localhost");
    }

    private static int getPort() {
        int i2cpPort = 7654;
        String i2cpPortStr = System.getProperty("i2cp.tcp.port");
        if (i2cpPortStr != null) {
            try {
                i2cpPort = Integer.parseInt(i2cpPortStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return i2cpPort;
    }
}

