/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class DataMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(DataMessage.class);
    public static final int MESSAGE_TYPE = 20;
    private byte[] _data = null;
    private static final int MAX_SIZE = 65536;

    public DataMessage(I2PAppContext context) {
        super(context);
    }

    public byte[] getData() {
        this.verifyUnwritten();
        return this._data;
    }

    public void setData(byte[] data) {
        this.verifyUnwritten();
        this._data = data;
    }

    public int getSize() {
        this.verifyUnwritten();
        return this._data.length;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 20) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        long size = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
        curIndex += 4;
        if (size > 65536L) {
            throw new I2NPMessageException("wtf, size=" + size);
        }
        this._data = new byte[(int)size];
        System.arraycopy(data, curIndex, this._data, 0, (int)size);
    }

    protected int calculateWrittenLength() {
        if (this._data == null) {
            return 4;
        }
        return 4 + this._data.length;
    }

    protected int writeMessageBody(byte[] out, int curIndex) {
        this.verifyUnwritten();
        if (this._data == null) {
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
            out[curIndex++] = 0;
        } else {
            byte[] len = DataHelper.toLong((int)4, (long)this._data.length);
            System.arraycopy(len, 0, out, curIndex, 4);
            System.arraycopy(this._data, 0, out, curIndex += 4, this._data.length);
            curIndex += this._data.length;
        }
        return curIndex;
    }

    protected void written() {
        super.written();
        this._data = null;
    }

    public int getType() {
        return 20;
    }

    public int hashCode() {
        return DataHelper.hashCode((byte[])this.getData());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DataMessage) {
            DataMessage msg = (DataMessage)object;
            return DataHelper.eq((byte[])this.getData(), (byte[])msg.getData());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DataMessage: ");
        buf.append("\n\tData: ").append(DataHelper.toString((byte[])this.getData(), (int)64));
        buf.append("]");
        return buf.toString();
    }
}

