/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class DatabaseStoreMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(DatabaseStoreMessage.class);
    public static final int MESSAGE_TYPE = 1;
    private Hash _key;
    private int _type;
    private LeaseSet _leaseSet;
    private RouterInfo _info;
    private byte[] _leaseSetCache;
    private byte[] _routerInfoCache;
    private long _replyToken;
    private TunnelId _replyTunnel;
    private Hash _replyGateway;
    public static final int KEY_TYPE_ROUTERINFO = 0;
    public static final int KEY_TYPE_LEASESET = 1;

    public DatabaseStoreMessage(I2PAppContext context) {
        super(context);
        this.setValueType(-1);
        this.setKey(null);
        this.setLeaseSet(null);
        this.setRouterInfo(null);
        this.setReplyToken(0L);
        this.setReplyTunnel(null);
        this.setReplyGateway(null);
    }

    public Hash getKey() {
        return this._key;
    }

    public void setKey(Hash key) {
        this._key = key;
    }

    public RouterInfo getRouterInfo() {
        return this._info;
    }

    public void setRouterInfo(RouterInfo routerInfo) {
        this._info = routerInfo;
        if (this._info != null) {
            this.setValueType(0);
        }
    }

    public LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    public void setLeaseSet(LeaseSet leaseSet) {
        this._leaseSet = leaseSet;
        if (this._leaseSet != null) {
            this.setValueType(1);
        }
    }

    public int getValueType() {
        return this._type;
    }

    public void setValueType(int type) {
        this._type = type;
    }

    public long getReplyToken() {
        return this._replyToken;
    }

    public void setReplyToken(long token) throws IllegalArgumentException {
        if (token > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Token too large: " + token + " (max=" + 0xFFFFFFFFL + ")");
        }
        if (token < 0L) {
            throw new IllegalArgumentException("Token too small: " + token);
        }
        this._replyToken = token;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyTunnel(TunnelId id) {
        this._replyTunnel = id;
    }

    public Hash getReplyGateway() {
        return this._replyGateway;
    }

    public void setReplyGateway(Hash peer) {
        this._replyGateway = peer;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 1) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        byte[] keyData = new byte[32];
        System.arraycopy(data, curIndex, keyData, 0, 32);
        this._key = new Hash(keyData);
        this._type = (int)DataHelper.fromLong((byte[])data, (int)(curIndex += 32), (int)1);
        this._replyToken = DataHelper.fromLong((byte[])data, (int)(++curIndex), (int)4);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long tunnel = DataHelper.fromLong((byte[])data, (int)curIndex, (int)4);
            if (tunnel > 0L) {
                this._replyTunnel = new TunnelId(tunnel);
            }
            byte[] gw = new byte[32];
            System.arraycopy(data, curIndex += 4, gw, 0, 32);
            curIndex += 32;
            this._replyGateway = new Hash(gw);
        } else {
            this._replyTunnel = null;
            this._replyGateway = null;
        }
        if (this._type == 1) {
            this._leaseSet = new LeaseSet();
            try {
                this._leaseSet.readBytes((InputStream)new ByteArrayInputStream(data, curIndex, data.length - curIndex));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the leaseSet", dfe);
            }
        } else if (this._type == 0) {
            this._info = new RouterInfo();
            int compressedSize = (int)DataHelper.fromLong((byte[])data, (int)curIndex, (int)2);
            curIndex += 2;
            try {
                byte[] decompressed = DataHelper.decompress((byte[])data, (int)curIndex, (int)compressedSize);
                this._info.readBytes((InputStream)new ByteArrayInputStream(decompressed));
            }
            catch (DataFormatException dfe) {
                throw new I2NPMessageException("Error reading the routerInfo", dfe);
            }
            catch (IOException ioe) {
                throw new I2NPMessageException("Compressed routerInfo was corrupt", ioe);
            }
        } else {
            throw new I2NPMessageException("Invalid type of key read from the structure - " + this._type);
        }
    }

    protected int calculateWrittenLength() {
        int len = 37;
        if (this._replyToken > 0L) {
            len += 36;
        }
        if (this._type == 1) {
            this._leaseSetCache = this._leaseSet.toByteArray();
            len += this._leaseSetCache.length;
        } else if (this._type == 0) {
            byte[] uncompressed = this._info.toByteArray();
            byte[] compressed = DataHelper.compress((byte[])uncompressed);
            this._routerInfoCache = compressed;
            len += compressed.length + 2;
        }
        return len;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._key == null) {
            throw new I2NPMessageException("Invalid key");
        }
        if (this._type != 1 && this._type != 0) {
            throw new I2NPMessageException("Invalid key type");
        }
        if (this._type == 1 && this._leaseSet == null) {
            throw new I2NPMessageException("Missing lease set");
        }
        if (this._type == 0 && this._info == null) {
            throw new I2NPMessageException("Missing router info");
        }
        System.arraycopy(this._key.getData(), 0, out, curIndex, 32);
        curIndex += 32;
        byte[] type = DataHelper.toLong((int)1, (long)this._type);
        out[curIndex++] = type[0];
        byte[] tok = DataHelper.toLong((int)4, (long)this._replyToken);
        System.arraycopy(tok, 0, out, curIndex, 4);
        curIndex += 4;
        if (this._replyToken > 0L) {
            long replyTunnel = 0L;
            if (this._replyTunnel != null) {
                replyTunnel = this._replyTunnel.getTunnelId();
            }
            byte[] id = DataHelper.toLong((int)4, (long)replyTunnel);
            System.arraycopy(id, 0, out, curIndex, 4);
            System.arraycopy(this._replyGateway.getData(), 0, out, curIndex += 4, 32);
            curIndex += 32;
        }
        if (this._type == 1) {
            System.arraycopy(this._leaseSetCache, 0, out, curIndex, this._leaseSetCache.length);
            curIndex += this._leaseSetCache.length;
        } else if (this._type == 0) {
            byte[] len = DataHelper.toLong((int)2, (long)this._routerInfoCache.length);
            out[curIndex++] = len[0];
            out[curIndex++] = len[1];
            System.arraycopy(this._routerInfoCache, 0, out, curIndex, this._routerInfoCache.length);
            curIndex += this._routerInfoCache.length;
        }
        return curIndex;
    }

    public int getType() {
        return 1;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getKey()) + DataHelper.hashCode((Object)this.getLeaseSet()) + DataHelper.hashCode((Object)this.getRouterInfo()) + this.getValueType() + (int)this.getReplyToken() + DataHelper.hashCode((Object)this.getReplyTunnel()) + DataHelper.hashCode((Object)this.getReplyGateway());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DatabaseStoreMessage) {
            DatabaseStoreMessage msg = (DatabaseStoreMessage)object;
            return DataHelper.eq((Object)this.getKey(), (Object)msg.getKey()) && DataHelper.eq((Object)this.getLeaseSet(), (Object)msg.getLeaseSet()) && DataHelper.eq((Object)this.getRouterInfo(), (Object)msg.getRouterInfo()) && DataHelper.eq((int)this.getValueType(), (int)msg.getValueType()) && this.getReplyToken() == msg.getReplyToken() && DataHelper.eq((Object)this.getReplyTunnel(), (Object)msg.getReplyTunnel()) && DataHelper.eq((Object)this.getReplyGateway(), (Object)msg.getReplyGateway());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DatabaseStoreMessage: ");
        buf.append("\n\tExpiration: ").append(this.getMessageExpiration());
        buf.append("\n\tUnique ID: ").append(this.getUniqueId());
        buf.append("\n\tKey: ").append(this.getKey());
        buf.append("\n\tValue Type: ").append(this.getValueType());
        buf.append("\n\tRouter Info: ").append(this.getRouterInfo());
        buf.append("\n\tLease Set: ").append(this.getLeaseSet());
        buf.append("\n\tReply token: ").append(this.getReplyToken());
        buf.append("\n\tReply tunnel: ").append(this.getReplyTunnel());
        buf.append("\n\tReply gateway: ").append(this.getReplyGateway());
        buf.append("]");
        return buf.toString();
    }
}

