/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class DateMessage
extends I2NPMessageImpl {
    private static final Log _log = new Log(DateMessage.class);
    public static final int MESSAGE_TYPE = 16;
    private long _now;

    public DateMessage(I2PAppContext context) {
        super(context);
        this._now = context.clock().now();
    }

    public long getNow() {
        return this._now;
    }

    public void setNow(long now) {
        this._now = now;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 16) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        int curIndex = offset;
        this._now = DataHelper.fromLong((byte[])data, (int)curIndex, (int)8);
    }

    protected int calculateWrittenLength() {
        return 8;
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        if (this._now <= 0L) {
            throw new I2NPMessageException("Not enough data to write out");
        }
        DataHelper.toLong((byte[])out, (int)curIndex, (int)8, (long)this._now);
        return curIndex += 8;
    }

    public int getType() {
        return 16;
    }

    public int hashCode() {
        return (int)this.getNow();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DateMessage) {
            DateMessage msg = (DateMessage)object;
            return msg.getNow() == this.getNow();
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[DateMessage: ");
        buf.append("Now: ").append(this._now);
        buf.append("]");
        return buf.toString();
    }
}

