/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;

public class TunnelBuildReplyMessage
extends I2NPMessageImpl {
    private ByteArray[] _records = new ByteArray[8];
    public static final int MESSAGE_TYPE = 22;
    public static final int RECORD_COUNT = 8;
    public static final int RECORD_SIZE = 528;

    public TunnelBuildReplyMessage(I2PAppContext context) {
        super(context);
    }

    public void setRecord(int index, ByteArray record) {
        this._records[index] = record;
    }

    public ByteArray getRecord(int index) {
        return this._records[index];
    }

    protected int calculateWrittenLength() {
        return 4224;
    }

    public int getType() {
        return 22;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 22) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if (dataSize != this.calculateWrittenLength()) {
            throw new I2NPMessageException("Wrong length (expects " + this.calculateWrittenLength() + ", recv " + dataSize + ")");
        }
        for (int i = 0; i < 8; ++i) {
            int off = offset + i * 528;
            int len = 528;
            byte[] rec = new byte[528];
            System.arraycopy(data, off, rec, 0, 528);
            this.setRecord(i, new ByteArray(rec));
        }
    }

    protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
        int remaining = out.length - (curIndex + this.calculateWrittenLength());
        if (remaining < 0) {
            throw new I2NPMessageException("Not large enough (too short by " + remaining + ")");
        }
        for (int i = 0; i < 8; ++i) {
            System.arraycopy(this._records[i].getData(), this._records[i].getOffset(), out, curIndex, 528);
            curIndex += 528;
        }
        return curIndex;
    }
}

