/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import java.io.IOException;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class TunnelCreateMessage
extends I2NPMessageImpl {
    private Log _log;
    public static final int MESSAGE_TYPE = 6;
    private Hash _nextRouter;
    private TunnelId _nextTunnelId;
    private int _durationSeconds;
    private SessionKey _layerKey;
    private SessionKey _ivKey;
    private Properties _options;
    private Hash _replyGateway;
    private TunnelId _replyTunnel;
    private SessionTag _replyTag;
    private SessionKey _replyKey;
    private boolean _isGateway;
    private long _nonce;
    private Certificate _certificate;
    private byte[] _optionsCache;
    private byte[] _certificateCache;
    public static final long MAX_NONCE_VALUE = 0xFFFFFFFFL;
    private static final Hash INVALID_HASH = new Hash(new byte[32]);
    private static final TunnelId INVALID_TUNNEL = TunnelId.INVALID;

    public TunnelCreateMessage(I2PAppContext context) {
        super(context);
        this._log = context.logManager().getLog(TunnelCreateMessage.class);
    }

    public void setNextRouter(Hash routerIdentityHash) {
        this._nextRouter = routerIdentityHash;
    }

    public Hash getNextRouter() {
        return this._nextRouter;
    }

    public void setNextTunnelId(TunnelId id) {
        this._nextTunnelId = id;
    }

    public TunnelId getNextTunnelId() {
        return this._nextTunnelId;
    }

    public void setDurationSeconds(int seconds) {
        this._durationSeconds = seconds;
    }

    public int getDurationSeconds() {
        return this._durationSeconds;
    }

    public void setLayerKey(SessionKey key) {
        this._layerKey = key;
    }

    public SessionKey getLayerKey() {
        return this._layerKey;
    }

    public void setIVKey(SessionKey key) {
        this._ivKey = key;
    }

    public SessionKey getIVKey() {
        return this._ivKey;
    }

    public void setCertificate(Certificate cert) {
        this._certificate = cert;
    }

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setReplyTag(SessionTag tag) {
        this._replyTag = tag;
    }

    public SessionTag getReplyTag() {
        return this._replyTag;
    }

    public void setReplyKey(SessionKey key) {
        this._replyKey = key;
    }

    public SessionKey getReplyKey() {
        return this._replyKey;
    }

    public void setReplyTunnel(TunnelId id) {
        this._replyTunnel = id;
    }

    public TunnelId getReplyTunnel() {
        return this._replyTunnel;
    }

    public void setReplyGateway(Hash peer) {
        this._replyGateway = peer;
    }

    public Hash getReplyGateway() {
        return this._replyGateway;
    }

    public void setNonce(long nonce) {
        this._nonce = nonce;
    }

    public long getNonce() {
        return this._nonce;
    }

    public void setIsGateway(boolean isGateway) {
        this._isGateway = isGateway;
    }

    public boolean getIsGateway() {
        return this._isGateway;
    }

    public Properties getOptions() {
        return this._options;
    }

    public void setOptions(Properties opts) {
        this._options = opts;
    }

    public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
        if (type != 6) {
            throw new I2NPMessageException("Message type is incorrect for this message");
        }
        if (DataHelper.eq((byte[])INVALID_HASH.getData(), (int)0, (byte[])data, (int)offset, (int)32)) {
            this._nextRouter = null;
        } else {
            this._nextRouter = new Hash(new byte[32]);
            System.arraycopy(data, offset, this._nextRouter.getData(), 0, 32);
        }
        long id = DataHelper.fromLong((byte[])data, (int)(offset += 32), (int)4);
        if (id > 0L) {
            this._nextTunnelId = new TunnelId(id);
        }
        this._durationSeconds = (int)DataHelper.fromLong((byte[])data, (int)(offset += 4), (int)2);
        this._layerKey = new SessionKey(new byte[32]);
        System.arraycopy(data, offset += 2, this._layerKey.getData(), 0, 32);
        this._ivKey = new SessionKey(new byte[32]);
        System.arraycopy(data, offset += 32, this._ivKey.getData(), 0, 32);
        offset += 32;
        try {
            Properties opts;
            this._options = opts = new Properties();
            offset = DataHelper.fromProperties((byte[])data, (int)offset, (Properties)opts);
        }
        catch (DataFormatException dfe) {
            throw new I2NPMessageException("Error reading the options", dfe);
        }
        this._replyGateway = new Hash(new byte[32]);
        System.arraycopy(data, offset, this._replyGateway.getData(), 0, 32);
        this._replyTunnel = new TunnelId(DataHelper.fromLong((byte[])data, (int)(offset += 32), (int)4));
        this._replyTag = new SessionTag(new byte[32]);
        System.arraycopy(data, offset += 4, this._replyTag.getData(), 0, 32);
        this._replyKey = new SessionKey(new byte[32]);
        System.arraycopy(data, offset += 32, this._replyKey.getData(), 0, 32);
        this._nonce = DataHelper.fromLong((byte[])data, (int)(offset += 32), (int)4);
        offset += 4;
        try {
            Certificate cert;
            this._certificate = cert = new Certificate();
            offset += cert.readBytes(data, offset);
        }
        catch (DataFormatException dfe) {
            throw new I2NPMessageException("Error reading the certificate", dfe);
        }
        Boolean b = DataHelper.fromBoolean((byte[])data, (int)offset);
        if (b == null) {
            throw new I2NPMessageException("isGateway == unknown?!");
        }
        this._isGateway = b;
        ++offset;
    }

    protected int calculateWrittenLength() {
        int length = 0;
        length += 32;
        length += 4;
        length += 2;
        length += 32;
        length += 32;
        if (this._optionsCache == null) {
            this._optionsCache = DataHelper.toProperties((Properties)this._options);
        }
        length += this._optionsCache.length;
        length += 32;
        length += 4;
        length += 32;
        length += 32;
        length += 4;
        if (this._certificateCache == null) {
            this._certificateCache = this._certificate.toByteArray();
        }
        length += this._certificateCache.length;
        return ++length;
    }

    protected int writeMessageBody(byte[] data, int offset) throws I2NPMessageException {
        if (this._nextRouter == null) {
            System.arraycopy(INVALID_HASH.getData(), 0, data, offset, 32);
        } else {
            System.arraycopy(this._nextRouter.getData(), 0, data, offset, 32);
        }
        offset += 32;
        if (this._nextTunnelId == null) {
            DataHelper.toLong((byte[])data, (int)offset, (int)4, (long)0L);
        } else {
            DataHelper.toLong((byte[])data, (int)offset, (int)4, (long)this._nextTunnelId.getTunnelId());
        }
        DataHelper.toLong((byte[])data, (int)(offset += 4), (int)2, (long)this._durationSeconds);
        System.arraycopy(this._layerKey.getData(), 0, data, offset += 2, 32);
        System.arraycopy(this._ivKey.getData(), 0, data, offset += 32, 32);
        offset += 32;
        if (this._optionsCache == null) {
            this._optionsCache = DataHelper.toProperties((Properties)this._options);
        }
        System.arraycopy(this._optionsCache, 0, data, offset, this._optionsCache.length);
        System.arraycopy(this._replyGateway.getData(), 0, data, offset += this._optionsCache.length, 32);
        DataHelper.toLong((byte[])data, (int)(offset += 32), (int)4, (long)this._replyTunnel.getTunnelId());
        System.arraycopy(this._replyTag.getData(), 0, data, offset += 4, 32);
        System.arraycopy(this._replyKey.getData(), 0, data, offset += 32, 32);
        DataHelper.toLong((byte[])data, (int)(offset += 32), (int)4, (long)this._nonce);
        offset += 4;
        if (this._certificateCache == null) {
            this._certificateCache = this._certificate.toByteArray();
        }
        System.arraycopy(this._certificateCache, 0, data, offset, this._certificateCache.length);
        DataHelper.toBoolean((byte[])data, (int)(offset += this._certificateCache.length), (boolean)this._isGateway);
        return ++offset;
    }

    public byte[] toByteArray() {
        byte[] rv = super.toByteArray();
        if (rv == null) {
            throw new RuntimeException("unable to toByteArray(): " + this.toString());
        }
        return rv;
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this.getNextRouter()) + DataHelper.hashCode((Object)this.getNextTunnelId()) + DataHelper.hashCode((Object)this.getReplyGateway()) + DataHelper.hashCode((Object)this.getReplyTunnel());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof TunnelCreateMessage) {
            TunnelCreateMessage msg = (TunnelCreateMessage)object;
            return DataHelper.eq((Object)this.getNextRouter(), (Object)msg.getNextRouter()) && DataHelper.eq((Object)this.getNextTunnelId(), (Object)msg.getNextTunnelId()) && DataHelper.eq((Object)this.getReplyGateway(), (Object)msg.getReplyGateway()) && DataHelper.eq((Object)this.getReplyTunnel(), (Object)msg.getReplyTunnel());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[TunnelCreateMessage: ");
        buf.append("\n\tNext Router: ").append(this.getNextRouter());
        buf.append("\n\tNext Tunnel: ").append(this.getNextTunnelId());
        buf.append("\n\tReply Tunnel: ").append(this.getReplyTunnel());
        buf.append("\n\tReply Peer: ").append(this.getReplyGateway());
        buf.append("]");
        return buf.toString();
    }

    public int getType() {
        return 6;
    }
}

