/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Properties;
import net.i2p.router.ClientMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.OutboundClientMessageOneShotJob;
import net.i2p.util.Log;

public class ClientMessagePool {
    private Log _log;
    private RouterContext _context;

    public ClientMessagePool(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessagePool.class);
    }

    public void add(ClientMessage msg) {
        this.add(msg, false);
    }

    public void add(ClientMessage msg, boolean isDefinitelyRemote) {
        if (!isDefinitelyRemote || this._context.clientManager().isLocal(msg.getDestination()) || this._context.clientManager().isLocal(msg.getDestinationHash())) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding message for local delivery");
            }
            this._context.clientManager().messageReceived(msg);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding message for remote delivery");
            }
            OutboundClientMessageOneShotJob j = new OutboundClientMessageOneShotJob(this._context, msg);
            j.runJob();
        }
    }

    private boolean isGuaranteed(ClientMessage msg) {
        Properties opts = null;
        if (msg.getSenderConfig() != null) {
            opts = msg.getSenderConfig().getOptions();
        }
        if (opts != null) {
            String val = opts.getProperty("i2cp.messageReliability", "BestEffort");
            return val.equals("Guaranteed");
        }
        return false;
    }
}

