/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.Certificate;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DataMessage;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class LoadTestManager {
    private RouterContext _context;
    private Log _log;
    private Writer _out;
    private List _untestedPeers;
    private List _active;
    private static final String PROP_LOG_DATA = "router.loadTestLog";
    private static final String DEFAULT_LOG_DATA = "false";
    public static final boolean TEST_LIVE_TUNNELS = true;
    private static final int CONCURRENT_PEERS = 1;
    private static final int CONCURRENT_MESSAGES = 1;
    private static final boolean DEFAULT_ENABLE = false;
    public static final boolean FORCE_DISABLE = true;
    private static final boolean SMALL_PAYLOAD = false;
    private long TEST_PERIOD_MAX = 300000L;
    private long TEST_PERIOD_MIN = 60000L;

    public LoadTestManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(LoadTestManager.class);
        this._active = Collections.synchronizedList(new ArrayList());
        if (Boolean.valueOf(ctx.getProperty(PROP_LOG_DATA, DEFAULT_LOG_DATA)).booleanValue()) {
            try {
                this._out = new BufferedWriter(new FileWriter("loadtest.log", true));
                this._out.write("startup at " + ctx.clock().now() + "\n");
            }
            catch (IOException ioe) {
                this._log.log(50, "error creating log", (Throwable)ioe);
            }
        }
        this._context.statManager().createRateStat("test.lifetimeSuccessful", "How many messages we can pump through a load test during a tunnel's lifetime", "test", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("test.lifetimeFailed", "How many messages we fail to pump through (period == successful)", "test", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("test.timeoutAfter", "How many messages have we successfully pumped through a tunnel when one particular message times out", "test", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("test.rtt", "How long it takes to get a reply", "test", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("test.rttHigh", "How long it takes to get a reply, if it is a slow rtt", "test", new long[]{60000L, 300000L, 3600000L});
    }

    public static boolean isEnabled(I2PAppContext ctx) {
        return false;
    }

    public static void setEnableLoadTesting(RouterContext ctx, boolean enable) {
        if (enable) {
            ctx.router().setConfigSetting("router.enableLoadTesting", "true");
        } else {
            ctx.router().setConfigSetting("router.enableLoadTesting", DEFAULT_LOG_DATA);
        }
    }

    private int getConcurrency() {
        if (!LoadTestManager.isEnabled(this._context)) {
            return 0;
        }
        int rv = 1;
        try {
            rv = Integer.parseInt(this._context.getProperty("router.loadTestConcurrency", "1"));
        }
        catch (NumberFormatException nfe) {
            rv = 1;
        }
        if (rv < 0) {
            rv = 0;
        }
        if (rv > 50) {
            rv = 50;
        }
        return rv;
    }

    private int getPeerMessages() {
        String msgsPerPeer = this._context.getProperty("router.loadTestMessagesPerPeer");
        int rv = 1;
        if (msgsPerPeer != null) {
            try {
                rv = Integer.parseInt(msgsPerPeer);
            }
            catch (NumberFormatException nfe) {
                rv = 1;
            }
        }
        if (rv < 1) {
            rv = 1;
        }
        if (rv > 50) {
            rv = 50;
        }
        return rv;
    }

    private void runTest(LoadTestTunnelConfig tunnel) {
        if (!LoadTestManager.isEnabled(this._context)) {
            return;
        }
        this.log(tunnel, "start");
        int peerMessages = this.getPeerMessages();
        if (this._log.shouldLog(10)) {
            this._log.debug("Run test on " + tunnel + " with " + peerMessages + " messages");
        }
        for (int i = 0; i < peerMessages; ++i) {
            this.sendTestMessage(tunnel);
        }
    }

    private void pickTunnels(LoadTestTunnelConfig tunnel) {
        TunnelInfo inbound = null;
        TunnelInfo outbound = null;
        if (tunnel.getTunnel().isInbound()) {
            inbound = this._context.tunnelManager().getTunnelInfo(tunnel.getReceiveTunnelId(0));
            if (inbound == null && this._log.shouldLog(30)) {
                this._log.warn("where are we?  inbound tunnel isn't known: " + tunnel, (Throwable)new Exception("source"));
            }
            outbound = tunnel.getTunnel().getDestination() != null ? this._context.tunnelManager().selectOutboundTunnel(tunnel.getTunnel().getDestination()) : this._context.tunnelManager().selectOutboundTunnel();
        } else {
            outbound = this._context.tunnelManager().getTunnelInfo(tunnel.getSendTunnelId(0));
            if (outbound == null && this._log.shouldLog(30)) {
                this._log.warn("where are we?  outbound tunnel isn't known: " + tunnel, (Throwable)new Exception("source"));
            }
            inbound = tunnel.getTunnel().getDestination() != null ? this._context.tunnelManager().selectInboundTunnel(tunnel.getTunnel().getDestination()) : this._context.tunnelManager().selectInboundTunnel();
        }
        tunnel.setInbound(inbound);
        tunnel.setOutbound(outbound);
    }

    private void sendTestMessage(LoadTestTunnelConfig tunnel) {
        long now = this._context.clock().now();
        if (now > tunnel.getExpiration()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Not sending a test message to " + tunnel + " because it expired");
            }
            tunnel.logComplete();
            this._active.remove(tunnel);
            return;
        }
        TunnelInfo inbound = tunnel.getInbound();
        TunnelInfo outbound = tunnel.getOutbound();
        if (inbound == null || outbound == null) {
            this.pickTunnels(tunnel);
            inbound = tunnel.getInbound();
            outbound = tunnel.getOutbound();
        }
        if (inbound == null) {
            this.log(tunnel, "No inbound tunnels found");
            this._active.remove(tunnel);
            return;
        }
        if (outbound == null) {
            this.log(tunnel, "No outbound tunnels found");
            tunnel.logComplete();
            this._active.remove(tunnel);
            return;
        }
        if (now >= inbound.getExpiration() || now >= outbound.getExpiration()) {
            tunnel.logComplete();
            this._active.remove(tunnel);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("inbound and outbound found for " + tunnel);
        }
        I2NPMessage payloadMessage = this.createPayloadMessage();
        if (this._log.shouldLog(10)) {
            this._log.debug("testing live tunnels with inbound [" + inbound + "] and outbound [" + outbound + "]");
        }
        long uniqueId = -1L;
        if (payloadMessage == null) {
            tunnel.logComplete();
            this._active.remove(tunnel);
            return;
        }
        uniqueId = payloadMessage.getUniqueId();
        this._context.messageRegistry().registerPending(new Selector(tunnel, uniqueId), new SendAgain(this._context, tunnel, uniqueId, true), new SendAgain(this._context, tunnel, uniqueId, false), 10000);
        this._context.tunnelDispatcher().dispatchOutbound(payloadMessage, outbound.getSendTunnelId(0), inbound.getReceiveTunnelId(0), inbound.getPeer(0));
    }

    private boolean useSmallPayload() {
        return Boolean.valueOf(this._context.getProperty("router.loadTestSmall", DEFAULT_LOG_DATA));
    }

    private I2NPMessage createPayloadMessage() {
        if (this.useSmallPayload()) {
            DeliveryStatusMessage m = new DeliveryStatusMessage(this._context);
            long now = this._context.clock().now();
            m.setArrival(now);
            m.setMessageExpiration(now + 10000L);
            m.setMessageId(this._context.random().nextLong(0xFFFFFFFFL));
            return m;
        }
        DataMessage m = new DataMessage(this._context);
        byte[] data = new byte[4096];
        this._context.random().nextBytes(data);
        m.setData(data);
        long now = this._context.clock().now();
        m.setMessageExpiration(now + 10000L);
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(0);
        PayloadGarlicConfig payload = new PayloadGarlicConfig();
        payload.setCertificate(new Certificate(0, null));
        payload.setId(this._context.random().nextLong(0xFFFFFFFFL));
        payload.setId(m.getUniqueId());
        payload.setPayload(m);
        payload.setRecipient(this._context.router().getRouterInfo());
        payload.setDeliveryInstructions(instructions);
        payload.setRequestAck(false);
        payload.setExpiration(m.getMessageExpiration());
        SessionKey encryptKey = this._context.keyGenerator().generateSessionKey();
        SessionTag encryptTag = new SessionTag(true);
        SessionKey sentKey = new SessionKey();
        Set sentTags = null;
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(this._context, payload, sentKey, sentTags, this._context.keyManager().getPublicKey(), encryptKey, encryptTag);
        HashSet<SessionTag> encryptTags = new HashSet<SessionTag>(1);
        encryptTags.add(encryptTag);
        this._context.sessionKeyManager().tagsReceived(encryptKey, encryptTags);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(LoadTestTunnelConfig tunnel, String msg) {
        if (this._out == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(128);
        if (tunnel.getInbound() == null) {
            for (int i = 0; i < tunnel.getLength() - 1; ++i) {
                Hash peer = tunnel.getPeer(i);
                if (peer != null && peer.equals((Object)this._context.routerHash())) continue;
                if (peer != null) {
                    buf.append(peer.toBase64());
                } else {
                    buf.append("[unknown_peer]");
                }
                buf.append(" ");
                TunnelId id = tunnel.getReceiveTunnelId(i);
                if (id != null) {
                    buf.append(id.getTunnelId());
                } else {
                    buf.append("[unknown_tunnel]");
                }
                buf.append(" ");
                buf.append(this._context.clock().now()).append(" hop ").append(i).append(" ").append(msg).append("\n");
            }
        } else {
            TunnelId id;
            Hash peer;
            int i;
            int hop = 0;
            TunnelInfo info = tunnel.getOutbound();
            for (i = 0; info != null && i < info.getLength(); ++i) {
                peer = info.getPeer(i);
                if (peer != null && peer.equals((Object)this._context.routerHash())) continue;
                if (peer != null) {
                    buf.append(peer.toBase64());
                } else {
                    buf.append("[unknown_peer]");
                }
                buf.append(" ");
                id = info.getReceiveTunnelId(i);
                if (id != null) {
                    buf.append(id.getTunnelId());
                } else {
                    buf.append("[unknown_tunnel]");
                }
                buf.append(" ");
                buf.append(this._context.clock().now()).append(" out_hop ").append(hop).append(" ").append(msg).append("\n");
                ++hop;
            }
            info = tunnel.getInbound();
            for (i = 0; info != null && i < info.getLength(); ++i) {
                peer = info.getPeer(i);
                if (peer != null && peer.equals((Object)this._context.routerHash())) continue;
                if (peer != null) {
                    buf.append(peer.toBase64());
                } else {
                    buf.append("[unknown_peer]");
                }
                buf.append(" ");
                id = info.getReceiveTunnelId(i);
                if (id != null) {
                    buf.append(id.getTunnelId());
                } else {
                    buf.append("[unknown_tunnel]");
                }
                buf.append(" ");
                buf.append(this._context.clock().now()).append(" in_hop ").append(hop).append(" ").append(msg).append("\n");
                ++hop;
            }
        }
        try {
            Writer hop = this._out;
            synchronized (hop) {
                this._out.write(buf.toString());
            }
        }
        catch (IOException ioe) {
            this._log.error("error logging [" + msg + "]", (Throwable)ioe);
        }
    }

    public void addTunnelTestCandidate(TunnelCreatorConfig cfg) {
        LoadTestTunnelConfig ltCfg = new LoadTestTunnelConfig(cfg);
        if (this.wantToTest(ltCfg)) {
            long delay = this._context.random().nextInt(30000) + 30000;
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new BeginTest(ltCfg), delay);
            if (this._log.shouldLog(20)) {
                this._log.info("Testing " + cfg + ", with " + this._active.size() + " active");
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Not testing " + cfg + " because we have " + this._active.size() + " active: " + this._active);
        }
    }

    public void removeTunnelTestCandidate(TunnelCreatorConfig cfg) {
        this._active.remove(cfg);
    }

    private boolean wantToTest(LoadTestTunnelConfig cfg) {
        if (this._context.router().getUptime() <= 600000L) {
            return false;
        }
        if (this.bandwidthOverloaded()) {
            return false;
        }
        if (this._active.size() < this.getConcurrency()) {
            if (cfg.getLength() < 2) {
                return false;
            }
            this._active.add(cfg);
            return true;
        }
        return false;
    }

    private boolean bandwidthOverloaded() {
        int msgLoadBps = 512;
        int curBps = this.getBps();
        if ((curBps + (msgLoadBps *= 2)) / 1024 >= this._context.bandwidthLimiter().getOutboundKBytesPerSecond()) {
            return true;
        }
        if ((curBps + msgLoadBps) / 1024 >= this._context.bandwidthLimiter().getInboundKBytesPerSecond()) {
            return true;
        }
        return this._context.throttle().getMessageDelay() > 1000L;
    }

    private int getBps() {
        int used1s = this._context.router().get1sRate();
        int used1m = this._context.router().get1mRate();
        int used5m = this._context.router().get5mRate();
        return Math.max(used1s, Math.max(used1m, used5m));
    }

    private class LoadTestTunnelConfig {
        private TunnelCreatorConfig _cfg;
        private long _failed;
        private long _fullMessages;
        private TunnelInfo _testInbound;
        private TunnelInfo _testOutbound;
        private boolean _completed;

        public LoadTestTunnelConfig(TunnelCreatorConfig cfg) {
            this._cfg = cfg;
            this._failed = 0L;
            this._fullMessages = 0L;
            this._completed = false;
        }

        public long getExpiration() {
            return this._cfg.getExpiration();
        }

        public Hash getPeer(int peer) {
            return this._cfg.getPeer(peer);
        }

        public TunnelId getReceiveTunnelId(int peer) {
            return this._cfg.getReceiveTunnelId(peer);
        }

        public TunnelId getSendTunnelId(int peer) {
            return this._cfg.getSendTunnelId(peer);
        }

        public int getLength() {
            return this._cfg.getLength();
        }

        public void incrementFailed() {
            ++this._failed;
        }

        public long getFailedMessageCount() {
            return this._failed;
        }

        public void incrementFull() {
            ++this._fullMessages;
        }

        public long getFullMessageCount() {
            return this._fullMessages;
        }

        public TunnelCreatorConfig getTunnel() {
            return this._cfg;
        }

        public void setInbound(TunnelInfo info) {
            this._testInbound = info;
        }

        public void setOutbound(TunnelInfo info) {
            this._testOutbound = info;
        }

        public TunnelInfo getInbound() {
            return this._testInbound;
        }

        public TunnelInfo getOutbound() {
            return this._testOutbound;
        }

        public String toString() {
            return this._cfg + ": failed=" + this._failed + " full=" + this._fullMessages;
        }

        void logComplete() {
            if (this._completed) {
                return;
            }
            this._completed = true;
            LoadTestTunnelConfig cfg = this;
            LoadTestManager.this.log(cfg, "expired after sending " + cfg.getFullMessageCount() + " / " + cfg.getFailedMessageCount() + " in " + (600000L - (cfg.getExpiration() - LoadTestManager.this._context.clock().now())));
            LoadTestManager.this._context.statManager().addRateData("test.lifetimeSuccessful", cfg.getFullMessageCount(), cfg.getFailedMessageCount());
            if (cfg.getFailedMessageCount() > 0L) {
                LoadTestManager.this._context.statManager().addRateData("test.lifetimeFailed", cfg.getFailedMessageCount(), cfg.getFullMessageCount());
            }
        }
    }

    private class FailedJob
    extends JobImpl {
        private LoadTestTunnelConfig _cfg;

        public FailedJob(RouterContext ctx, LoadTestTunnelConfig cfg) {
            super(ctx);
            this._cfg = cfg;
        }

        public String getName() {
            return "Test tunnel failed";
        }

        public void runJob() {
            if (LoadTestManager.this._log.shouldLog(20)) {
                LoadTestManager.this._log.info("Tunnel failed for testing peer " + this._cfg.getPeer(0).toBase64());
            }
            LoadTestManager.this.log(this._cfg, "failed");
        }
    }

    private class Expire
    extends JobImpl {
        private LoadTestTunnelConfig _cfg;
        private boolean _removeFromDispatcher;

        public Expire(RouterContext ctx, LoadTestTunnelConfig cfg) {
            this(ctx, cfg, true);
        }

        public Expire(RouterContext ctx, LoadTestTunnelConfig cfg, boolean removeFromDispatcher) {
            long expiration;
            super(ctx);
            this._cfg = cfg;
            this._removeFromDispatcher = removeFromDispatcher;
            long duration = ctx.random().nextLong(LoadTestManager.this.TEST_PERIOD_MAX);
            if (duration < LoadTestManager.this.TEST_PERIOD_MIN) {
                duration += LoadTestManager.this.TEST_PERIOD_MIN;
            }
            if ((expiration = duration + ctx.clock().now()) > cfg.getExpiration() + 60000L) {
                expiration = cfg.getExpiration() + 60000L;
            }
            this.getTiming().setStartAfter(expiration);
        }

        public String getName() {
            return "expire test tunnel";
        }

        public void runJob() {
            if (this._removeFromDispatcher) {
                this.getContext().tunnelDispatcher().remove(this._cfg.getTunnel());
            }
            this._cfg.logComplete();
            TunnelInfo info = this._cfg.getOutbound();
            if (info != null) {
                info.incrementVerifiedBytesTransferred(0);
            }
            LoadTestManager.this._active.remove(this._cfg);
        }
    }

    private class CreatedJob
    extends JobImpl {
        private LoadTestTunnelConfig _cfg;

        public CreatedJob(RouterContext ctx, LoadTestTunnelConfig cfg) {
            super(ctx);
            this._cfg = cfg;
        }

        public String getName() {
            return "Test tunnel created";
        }

        public void runJob() {
            if (LoadTestManager.this._log.shouldLog(20)) {
                LoadTestManager.this._log.info("Tunnel created for testing peer " + this._cfg.getPeer(0).toBase64());
            }
            this.getContext().tunnelDispatcher().joinInbound(this._cfg.getTunnel());
            LoadTestManager.this._active.add(this._cfg);
            Expire j = new Expire(this.getContext(), this._cfg);
            this.getContext().jobQueue().addJob(j);
            LoadTestManager.this.runTest(this._cfg);
        }
    }

    private class BeginTest
    implements SimpleTimer.TimedEvent {
        private LoadTestTunnelConfig _cfg;

        public BeginTest(LoadTestTunnelConfig cfg) {
            this._cfg = cfg;
        }

        public void timeReached() {
            LoadTestManager.this._context.jobQueue().addJob(new Expire(LoadTestManager.this._context, this._cfg, false));
            LoadTestManager.this.runTest(this._cfg);
        }
    }

    private class Selector
    implements MessageSelector {
        private LoadTestTunnelConfig _cfg;
        private long _messageId;

        public Selector(LoadTestTunnelConfig cfg, long messageId) {
            this._cfg = cfg;
            this._messageId = messageId;
        }

        public boolean continueMatching() {
            return false;
        }

        public long getExpiration() {
            return this._cfg.getExpiration();
        }

        public boolean isMatch(I2NPMessage message) {
            if (message.getUniqueId() == this._messageId) {
                TunnelInfo info;
                long count = this._cfg.getFullMessageCount();
                this._cfg.incrementFull();
                long period = LoadTestManager.this._context.clock().now() - (message.getMessageExpiration() - 10000L);
                LoadTestManager.this.log(this._cfg, this._messageId + " " + count + " after " + period);
                LoadTestManager.this._context.statManager().addRateData("test.rtt", period, count);
                if (period > 2000L) {
                    LoadTestManager.this._context.statManager().addRateData("test.rttHigh", period, count);
                }
                if ((info = this._cfg.getOutbound()) != null) {
                    info.incrementVerifiedBytesTransferred(5120);
                }
                return true;
            }
            return false;
        }
    }

    private class SendAgain
    extends JobImpl
    implements ReplyJob {
        private LoadTestTunnelConfig _cfg;
        private long _messageId;
        private boolean _ok;
        private boolean _run;
        private long _dontStartUntil;

        public SendAgain(RouterContext ctx, LoadTestTunnelConfig cfg, long messageId, boolean ok) {
            super(ctx);
            this._cfg = cfg;
            this._messageId = messageId;
            this._ok = ok;
            this._run = false;
            this._dontStartUntil = ctx.clock().now() + 10000L;
        }

        public String getName() {
            return "send another load test";
        }

        public void runJob() {
            if (!this._ok) {
                if (!this._run) {
                    LoadTestManager.this.log(this._cfg, this._messageId + " " + this._cfg.getFullMessageCount() + " TIMEOUT");
                    this.getContext().statManager().addRateData("test.timeoutAfter", this._cfg.getFullMessageCount(), 0L);
                    if (this.getContext().clock().now() >= this._dontStartUntil) {
                        LoadTestManager.this.sendTestMessage(this._cfg);
                        this._cfg.incrementFailed();
                    } else {
                        this.getTiming().setStartAfter(this._dontStartUntil);
                        this.getContext().jobQueue().addJob(this);
                    }
                }
                this._run = true;
            } else {
                LoadTestManager.this.sendTestMessage(this._cfg);
            }
        }

        public void setMessage(I2NPMessage message) {
        }
    }
}

