/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.router.Blocklist;
import net.i2p.router.ClientManagerFacade;
import net.i2p.router.ClientMessagePool;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.DummyClientManagerFacade;
import net.i2p.router.DummyNetworkDatabaseFacade;
import net.i2p.router.DummyPeerManagerFacade;
import net.i2p.router.DummyTunnelManagerFacade;
import net.i2p.router.InNetMessagePool;
import net.i2p.router.JobQueue;
import net.i2p.router.KeyManager;
import net.i2p.router.MessageHistory;
import net.i2p.router.MessageStateMonitor;
import net.i2p.router.MessageValidator;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.OutNetMessagePool;
import net.i2p.router.PeerManagerFacade;
import net.i2p.router.ProfileManager;
import net.i2p.router.Router;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterDoSThrottle;
import net.i2p.router.RouterThrottle;
import net.i2p.router.Shitlist;
import net.i2p.router.StatisticsManager;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.admin.AdminManager;
import net.i2p.router.client.ClientManagerFacadeImpl;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.Calculator;
import net.i2p.router.peermanager.CapacityCalculator;
import net.i2p.router.peermanager.IntegrationCalculator;
import net.i2p.router.peermanager.IsFailingCalculator;
import net.i2p.router.peermanager.PeerManagerFacadeImpl;
import net.i2p.router.peermanager.ProfileManagerImpl;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.peermanager.ReliabilityCalculator;
import net.i2p.router.peermanager.SpeedCalculator;
import net.i2p.router.peermanager.StrictSpeedCalculator;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.OutboundMessageRegistry;
import net.i2p.router.transport.VMCommSystem;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.util.Clock;

public class RouterContext
extends I2PAppContext {
    private Router _router;
    private AdminManager _adminManager;
    private ClientManagerFacade _clientManagerFacade;
    private ClientMessagePool _clientMessagePool;
    private JobQueue _jobQueue;
    private InNetMessagePool _inNetMessagePool;
    private OutNetMessagePool _outNetMessagePool;
    private MessageHistory _messageHistory;
    private OutboundMessageRegistry _messageRegistry;
    private NetworkDatabaseFacade _netDb;
    private KeyManager _keyManager;
    private CommSystemFacade _commSystem;
    private ProfileOrganizer _profileOrganizer;
    private PeerManagerFacade _peerManagerFacade;
    private ProfileManager _profileManager;
    private FIFOBandwidthLimiter _bandwidthLimiter;
    private TunnelManagerFacade _tunnelManager;
    private TunnelDispatcher _tunnelDispatcher;
    private StatisticsManager _statPublisher;
    private Shitlist _shitlist;
    private Blocklist _blocklist;
    private MessageValidator _messageValidator;
    private MessageStateMonitor _messageStateMonitor;
    private RouterThrottle _throttle;
    private RouterClock _clock;
    private Calculator _isFailingCalc;
    private Calculator _integrationCalc;
    private Calculator _speedCalc;
    private Calculator _reliabilityCalc;
    private Calculator _capacityCalc;
    private Calculator _oldSpeedCalc;
    private static List _contexts = new ArrayList(1);

    public RouterContext(Router router) {
        this(router, null);
    }

    public RouterContext(Router router, Properties envProps) {
        super(RouterContext.filterProps(envProps));
        this._router = router;
        this.initAll();
        _contexts.add(this);
    }

    static final Properties filterProps(Properties envProps) {
        if (envProps == null) {
            envProps = new Properties();
        }
        if (envProps.getProperty("time.disabled") == null) {
            envProps.setProperty("time.disabled", "false");
        }
        return envProps;
    }

    private void initAll() {
        this._adminManager = new AdminManager(this);
        this._clientManagerFacade = "false".equals(this.getProperty("i2p.dummyClientFacade", "false")) ? new ClientManagerFacadeImpl(this) : new DummyClientManagerFacade(this);
        this._clientMessagePool = new ClientMessagePool(this);
        this._jobQueue = new JobQueue(this);
        this._inNetMessagePool = new InNetMessagePool(this);
        this._outNetMessagePool = new OutNetMessagePool(this);
        this._messageHistory = new MessageHistory(this);
        this._messageRegistry = new OutboundMessageRegistry(this);
        this._messageStateMonitor = new MessageStateMonitor(this);
        this._netDb = "false".equals(this.getProperty("i2p.dummyNetDb", "false")) ? new FloodfillNetworkDatabaseFacade(this) : new DummyNetworkDatabaseFacade(this);
        this._keyManager = new KeyManager(this);
        this._commSystem = "false".equals(this.getProperty("i2p.vmCommSystem", "false")) ? new CommSystemFacadeImpl(this) : new VMCommSystem(this);
        this._profileOrganizer = new ProfileOrganizer(this);
        this._peerManagerFacade = "false".equals(this.getProperty("i2p.dummyPeerManager", "false")) ? new PeerManagerFacadeImpl(this) : new DummyPeerManagerFacade();
        this._profileManager = new ProfileManagerImpl(this);
        this._bandwidthLimiter = new FIFOBandwidthLimiter(this);
        this._tunnelManager = "false".equals(this.getProperty("i2p.dummyTunnelManager", "false")) ? new TunnelPoolManager(this) : new DummyTunnelManagerFacade();
        this._tunnelDispatcher = new TunnelDispatcher(this);
        this._statPublisher = new StatisticsManager(this);
        this._shitlist = new Shitlist(this);
        this._blocklist = new Blocklist(this);
        this._messageValidator = new MessageValidator(this);
        this._throttle = new RouterDoSThrottle(this);
        this._isFailingCalc = new IsFailingCalculator(this);
        this._integrationCalc = new IntegrationCalculator(this);
        this._speedCalc = new SpeedCalculator(this);
        this._oldSpeedCalc = new StrictSpeedCalculator(this);
        this._reliabilityCalc = new ReliabilityCalculator(this);
        this._capacityCalc = new CapacityCalculator(this);
    }

    public static List listContexts() {
        return _contexts;
    }

    public Router router() {
        return this._router;
    }

    public Hash routerHash() {
        return this._router.getRouterInfo().getIdentity().getHash();
    }

    public AdminManager adminManager() {
        return this._adminManager;
    }

    public ClientManagerFacade clientManager() {
        return this._clientManagerFacade;
    }

    public ClientMessagePool clientMessagePool() {
        return this._clientMessagePool;
    }

    public InNetMessagePool inNetMessagePool() {
        return this._inNetMessagePool;
    }

    public OutNetMessagePool outNetMessagePool() {
        return this._outNetMessagePool;
    }

    public MessageHistory messageHistory() {
        return this._messageHistory;
    }

    public OutboundMessageRegistry messageRegistry() {
        return this._messageRegistry;
    }

    public MessageStateMonitor messageStateMonitor() {
        return this._messageStateMonitor;
    }

    public NetworkDatabaseFacade netDb() {
        return this._netDb;
    }

    public JobQueue jobQueue() {
        return this._jobQueue;
    }

    public KeyManager keyManager() {
        return this._keyManager;
    }

    public CommSystemFacade commSystem() {
        return this._commSystem;
    }

    public ProfileOrganizer profileOrganizer() {
        return this._profileOrganizer;
    }

    public PeerManagerFacade peerManager() {
        return this._peerManagerFacade;
    }

    public ProfileManager profileManager() {
        return this._profileManager;
    }

    public FIFOBandwidthLimiter bandwidthLimiter() {
        return this._bandwidthLimiter;
    }

    public TunnelManagerFacade tunnelManager() {
        return this._tunnelManager;
    }

    public TunnelDispatcher tunnelDispatcher() {
        return this._tunnelDispatcher;
    }

    public StatisticsManager statPublisher() {
        return this._statPublisher;
    }

    public Shitlist shitlist() {
        return this._shitlist;
    }

    public Blocklist blocklist() {
        return this._blocklist;
    }

    public MessageValidator messageValidator() {
        return this._messageValidator;
    }

    public RouterThrottle throttle() {
        return this._throttle;
    }

    public Calculator isFailingCalculator() {
        return this._isFailingCalc;
    }

    public Calculator integrationCalculator() {
        return this._integrationCalc;
    }

    public Calculator speedCalculator() {
        return this._speedCalc;
    }

    public Calculator oldSpeedCalculator() {
        return this._oldSpeedCalc;
    }

    public Calculator reliabilityCalculator() {
        return this._reliabilityCalc;
    }

    public Calculator capacityCalculator() {
        return this._capacityCalc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("RouterContext: ").append(super.toString()).append('\n');
        buf.append(this._router).append('\n');
        buf.append(this._clientManagerFacade).append('\n');
        buf.append(this._clientMessagePool).append('\n');
        buf.append(this._jobQueue).append('\n');
        buf.append(this._inNetMessagePool).append('\n');
        buf.append(this._outNetMessagePool).append('\n');
        buf.append(this._messageHistory).append('\n');
        buf.append(this._messageRegistry).append('\n');
        buf.append(this._netDb).append('\n');
        buf.append(this._keyManager).append('\n');
        buf.append(this._commSystem).append('\n');
        buf.append(this._profileOrganizer).append('\n');
        buf.append(this._peerManagerFacade).append('\n');
        buf.append(this._profileManager).append('\n');
        buf.append(this._bandwidthLimiter).append('\n');
        buf.append(this._tunnelManager).append('\n');
        buf.append(this._statPublisher).append('\n');
        buf.append(this._shitlist).append('\n');
        buf.append(this._messageValidator).append('\n');
        buf.append(this._isFailingCalc).append('\n');
        buf.append(this._integrationCalc).append('\n');
        buf.append(this._speedCalc).append('\n');
        buf.append(this._reliabilityCalc).append('\n');
        return buf.toString();
    }

    public String getProperty(String propName) {
        String val;
        if (this._router != null && (val = this._router.getConfigSetting(propName)) != null) {
            return val;
        }
        return super.getProperty(propName);
    }

    public String getProperty(String propName, String defaultVal) {
        String val;
        if (this._router != null && (val = this._router.getConfigSetting(propName)) != null) {
            return val;
        }
        return super.getProperty(propName, defaultVal);
    }

    public Clock clock() {
        if (!this._clockInitialized) {
            this.initializeClock();
        }
        return this._clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClock() {
        RouterContext routerContext = this;
        synchronized (routerContext) {
            if (this._clock == null) {
                this._clock = new RouterClock(this);
            }
            this._clockInitialized = true;
        }
    }
}

