/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;

public class SSUDemo {
    RouterContext _us;

    public static void main(String[] args) {
        SSUDemo demo = new SSUDemo();
        demo.run();
    }

    public void run() {
        String cfgFile = "router.config";
        Properties envProps = this.getEnv();
        Router r = new Router(cfgFile, envProps);
        r.runRouter();
        this._us = r.getContext();
        this.setupHandlers();
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        RouterInfo myInfo = this._us.router().getRouterInfo();
        this.storeMyInfo(myInfo);
        this.loadPeers();
    }

    private Properties getEnv() {
        Properties envProps = System.getProperties();
        envProps.setProperty("i2np.tcp.disable", "true");
        envProps.setProperty("time.disabled", "false");
        envProps.setProperty("i2np.udp.allowLocal", "true");
        envProps.setProperty("i2np.udp.host", "127.0.0.1");
        envProps.setProperty("i2np.udp.internalPort", "12000");
        envProps.setProperty("i2np.udp.port", "12000");
        envProps.setProperty("i2p.dummyClientFacade", "true");
        envProps.setProperty("i2p.dummyNetDb", "true");
        envProps.setProperty("i2p.dummyPeerManager", "true");
        envProps.setProperty("i2p.dummyTunnelManager", "true");
        envProps.setProperty("i2p.HMACMD5", "true");
        envProps.setProperty("i2p.HMACBrokenSize", "false");
        envProps.setProperty("router.publishPeerRankings", "false");
        envProps.setProperty("loggerFilenameOverride", "logs/log-router-@.txt");
        return envProps;
    }

    private void setupHandlers() {
        this._us.inNetMessagePool().registerHandlerJobBuilder(1, new DBStoreJobBuilder());
        this._us.inNetMessagePool().registerHandlerJobBuilder(17, new FooJobBuilder());
    }

    private File getInfoDir() {
        return new File("/tmp/ssuDemoInfo/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMyInfo(RouterInfo info) {
        File infoDir = this.getInfoDir();
        if (!infoDir.exists()) {
            infoDir.mkdirs();
        }
        FileOutputStream fos = null;
        File infoFile = new File(infoDir, info.getIdentity().calculateHash().toBase64());
        try {
            fos = new FileOutputStream(infoFile);
            info.writeBytes((OutputStream)fos);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
        System.out.println("Our info stored at: " + infoFile.getAbsolutePath());
    }

    private void loadPeers() {
        File infoDir = this.getInfoDir();
        if (!infoDir.exists()) {
            infoDir.mkdirs();
        }
        while (true) {
            File[] peerFiles;
            if ((peerFiles = infoDir.listFiles()) != null && peerFiles.length > 0) {
                for (int i = 0; i < peerFiles.length; ++i) {
                    if (!peerFiles[i].isFile() || peerFiles[i].isHidden() || this._us.routerHash().toBase64().equals(peerFiles[i].getName())) continue;
                    System.out.println("Reading info: " + peerFiles[i].getAbsolutePath());
                    try {
                        FileInputStream in = new FileInputStream(peerFiles[i]);
                        RouterInfo ri = new RouterInfo();
                        ri.readBytes((InputStream)in);
                        this.peerRead(ri);
                        continue;
                    }
                    catch (IOException ioe) {
                        System.err.println("Error reading " + peerFiles[i].getAbsolutePath());
                        ioe.printStackTrace();
                        continue;
                    }
                    catch (DataFormatException dfe) {
                        System.err.println("Corrupt " + peerFiles[i].getAbsolutePath());
                        dfe.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void peerRead(RouterInfo ri) {
        RouterInfo old = this._us.netDb().store(ri.getIdentity().calculateHash(), ri);
        if (old == null) {
            this.newPeerRead(ri);
        }
    }

    private void newPeerRead(RouterInfo ri) {
        OutNetMessage out = new OutNetMessage(this._us);
        out.setExpiration(this._us.clock().now() + 10000L);
        out.setPriority(100);
        out.setTarget(ri);
        FooMessage data = new FooMessage(this._us, new byte[]{0, 1, 2, 3});
        System.out.println("SEND: " + Base64.encode((byte[])data.getData()));
        out.setMessage(data);
        out.setOnFailedSendJob(null);
        out.setOnSendJob(new AfterACK());
        this._us.outNetMessagePool().add(out);
    }

    private class HandleJob
    extends JobImpl {
        private I2NPMessage _msg;

        public HandleJob(RouterContext ctx, I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            super(ctx);
            this._msg = receivedMessage;
        }

        public void runJob() {
            DatabaseStoreMessage m = (DatabaseStoreMessage)this._msg;
            try {
                SSUDemo.this._us.netDb().store(m.getKey(), m.getRouterInfo());
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
        }

        public String getName() {
            return "Handle netDb store";
        }
    }

    private class DBStoreJobBuilder
    implements HandlerJobBuilder {
        private DBStoreJobBuilder() {
        }

        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            return new HandleJob(SSUDemo.this._us, receivedMessage, from, fromHash);
        }
    }

    class FooMessage
    extends I2NPMessageImpl {
        private byte[] _data;
        public static final int MESSAGE_TYPE = 17;

        public FooMessage(I2PAppContext ctx, byte[] data) {
            super(ctx);
            this._data = data;
        }

        public byte[] getData() {
            return this._data;
        }

        public void setData(byte[] data) {
            this._data = data;
        }

        public int getType() {
            return 17;
        }

        protected int calculateWrittenLength() {
            return this._data.length;
        }

        public void readMessage(byte[] data, int offset, int dataSize, int type) throws I2NPMessageException, IOException {
            this._data = new byte[dataSize];
            System.arraycopy(data, offset, this._data, 0, dataSize);
        }

        protected int writeMessageBody(byte[] out, int curIndex) throws I2NPMessageException {
            System.arraycopy(this._data, 0, out, curIndex, this._data.length);
            return curIndex + this._data.length;
        }
    }

    private class FooBuilder
    implements I2NPMessageImpl.Builder {
        private FooBuilder() {
        }

        public I2NPMessage build(I2PAppContext ctx) {
            return new FooMessage(ctx, null);
        }
    }

    private class FooHandleJob
    extends JobImpl {
        private I2NPMessage _msg;

        public FooHandleJob(RouterContext ctx, I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            super(ctx);
            this._msg = receivedMessage;
        }

        public void runJob() {
            FooMessage m = (FooMessage)this._msg;
            System.out.println("RECV: " + Base64.encode((byte[])m.getData()));
        }

        public String getName() {
            return "Handle Foo message";
        }
    }

    private class FooJobBuilder
    implements HandlerJobBuilder {
        public FooJobBuilder() {
            I2NPMessageImpl.registerBuilder(new FooBuilder(), 17);
        }

        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            return new FooHandleJob(SSUDemo.this._us, receivedMessage, from, fromHash);
        }
    }

    private class AfterACK
    extends JobImpl {
        public AfterACK() {
            super(SSUDemo.this._us);
        }

        public void runJob() {
            System.out.println("Foo message sent completely");
        }

        public String getName() {
            return "After Foo message send";
        }
    }
}

