/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class StatisticsManager
implements Service {
    private Log _log;
    private RouterContext _context;
    private boolean _includePeerRankings;
    private int _publishedStats;
    public static final String PROP_PUBLISH_RANKINGS = "router.publishPeerRankings";
    public static final String DEFAULT_PROP_PUBLISH_RANKINGS = "true";
    public static final String PROP_MAX_PUBLISHED_PEERS = "router.publishPeerMax";
    public static final int DEFAULT_MAX_PUBLISHED_PEERS = 10;
    private final DecimalFormat _fmt;
    private final DecimalFormat _pct;
    static final boolean CommentOutIn065 = "0.6.5".equals("0.6.4");

    public StatisticsManager(RouterContext context) {
        this._context = context;
        this._fmt = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.UK));
        this._pct = new DecimalFormat("#0.00%", new DecimalFormatSymbols(Locale.UK));
        this._log = context.logManager().getLog(StatisticsManager.class);
        this._includePeerRankings = false;
    }

    public void shutdown() {
    }

    public void restart() {
        this.startup();
    }

    public void startup() {
        String val = this._context.router().getConfigSetting(PROP_PUBLISH_RANKINGS);
        try {
            boolean v;
            if (val == null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Peer publishing setting router.publishPeerRankings not set - using default true");
                }
                val = DEFAULT_PROP_PUBLISH_RANKINGS;
            } else if (this._log.shouldLog(20)) {
                this._log.info("Peer publishing setting router.publishPeerRankings set to " + val);
            }
            this._includePeerRankings = v = Boolean.TRUE.toString().equalsIgnoreCase(val);
            if (this._log.shouldLog(10)) {
                this._log.debug("Setting includePeerRankings = " + v);
            }
        }
        catch (Throwable t) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error determining whether to publish rankings [router.publishPeerRankings=" + val + "], so we're defaulting to FALSE");
            }
            this._includePeerRankings = false;
        }
        val = this._context.router().getConfigSetting(PROP_MAX_PUBLISHED_PEERS);
        if (val == null) {
            this._publishedStats = 10;
        } else {
            try {
                int num;
                this._publishedStats = num = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Invalid max number of peers to publish [" + val + "], defaulting to " + 10, (Throwable)nfe);
                }
                this._publishedStats = 10;
            }
        }
    }

    public Properties publishStatistics() {
        Properties stats = new Properties();
        stats.setProperty("router.version", "0.6.5");
        stats.setProperty("coreVersion", "0.6.5");
        if (this._includePeerRankings) {
            long publishedUptime = this._context.router().getUptime();
            if (publishedUptime > 3600000L) {
                this.includeThroughput(stats);
            }
            this.includeRate("tunnel.participatingTunnels", stats, new long[]{300000L, 3600000L});
            if (publishedUptime < 3600000L) {
                publishedUptime = 3600000L;
            } else if (publishedUptime < 0x6DDD00L) {
                publishedUptime = 5400000L;
            }
            stats.setProperty("stat_uptime", DataHelper.formatDuration((long)publishedUptime));
            if (CommentOutIn065) {
                this.includeRate("tunnel.buildRequestTime", stats, new long[]{600000L});
            }
            this.includeRate("tunnel.buildClientExpire", stats, new long[]{600000L});
            this.includeRate("tunnel.buildClientReject", stats, new long[]{600000L});
            this.includeRate("tunnel.buildClientSuccess", stats, new long[]{600000L});
            this.includeRate("tunnel.buildExploratoryExpire", stats, new long[]{600000L});
            this.includeRate("tunnel.buildExploratoryReject", stats, new long[]{600000L});
            this.includeRate("tunnel.buildExploratorySuccess", stats, new long[]{600000L});
            this._log.debug("Publishing peer rankings");
        } else {
            stats.setProperty("stat_uptime", "90m");
            this._log.debug("Not publishing peer rankings");
        }
        if (FloodfillNetworkDatabaseFacade.isFloodfill(this._context.router().getRouterInfo())) {
            stats.setProperty("netdb.knownRouters", "" + this._context.netDb().getKnownRouters());
            stats.setProperty("netdb.knownLeaseSets", "" + this._context.netDb().getKnownLeaseSets());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Building status: " + stats);
        }
        return stats;
    }

    private void includeRate(String rateName, Properties stats, long[] selectedPeriods) {
        this.includeRate(rateName, stats, selectedPeriods, false);
    }

    private void includeRate(String rateName, Properties stats, long[] selectedPeriods, boolean fudgeQuantity) {
        RateStat rate = this._context.statManager().getRate(rateName);
        if (rate == null) {
            return;
        }
        long[] periods = rate.getPeriods();
        for (int i = 0; i < periods.length; ++i) {
            Rate curRate;
            if (periods[i] > this._context.router().getUptime()) continue;
            if (selectedPeriods != null) {
                boolean found = false;
                for (int j = 0; j < selectedPeriods.length; ++j) {
                    if (selectedPeriods[j] != periods[i]) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if ((curRate = rate.getRate(periods[i])) == null || curRate.getLifetimeEventCount() <= 0L) continue;
            stats.setProperty("stat_" + rateName + '.' + this.getPeriod(curRate), this.renderRate(curRate, fudgeQuantity));
        }
    }

    private String renderRate(Rate rate, boolean fudgeQuantity) {
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.num(rate.getAverageValue())).append(';');
        buf.append(this.num(rate.getExtremeAverageValue())).append(';');
        buf.append(this.pct(rate.getPercentageOfLifetimeValue())).append(';');
        if (rate.getLifetimeTotalEventTime() > 0L) {
            buf.append(this.pct(rate.getLastEventSaturation())).append(';');
            buf.append(this.num(rate.getLastSaturationLimit())).append(';');
            buf.append(this.pct(rate.getExtremeEventSaturation())).append(';');
            buf.append(this.num(rate.getExtremeSaturationLimit())).append(';');
        }
        long numPeriods = rate.getLifetimePeriods();
        if (fudgeQuantity) {
            buf.append("666").append(';');
            if (numPeriods > 0L) {
                buf.append("666").append(';');
                buf.append("666").append(';');
            }
        } else {
            buf.append(this.num(rate.getLastEventCount())).append(';');
            if (numPeriods > 0L) {
                double avgFrequency = (double)rate.getLifetimeEventCount() / (double)numPeriods;
                buf.append(this.num(avgFrequency)).append(';');
                buf.append(this.num(rate.getExtremeEventCount())).append(';');
                buf.append(this.num(rate.getLifetimeEventCount())).append(';');
            }
        }
        return buf.toString();
    }

    private void includeThroughput(Properties stats) {
        RateStat recvRate;
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        if (sendRate != null) {
            Rate r;
            if (CommentOutIn065 && this._context.router().getUptime() > 300000L && (r = sendRate.getRate(300000L)) != null) {
                stats.setProperty("stat_bandwidthSendBps.5m", this.num(r.getAverageValue()) + ';' + this.num(r.getExtremeAverageValue()) + ";0;0;");
            }
            if (this._context.router().getUptime() > 3600000L && (r = sendRate.getRate(3600000L)) != null) {
                stats.setProperty("stat_bandwidthSendBps.60m", this.num(r.getAverageValue()) + ';' + this.num(r.getExtremeAverageValue()) + ";0;0;");
            }
        }
        if ((recvRate = this._context.statManager().getRate("bw.recvRate")) != null) {
            Rate r;
            if (CommentOutIn065 && this._context.router().getUptime() > 300000L && (r = recvRate.getRate(300000L)) != null) {
                stats.setProperty("stat_bandwidthReceiveBps.5m", this.num(r.getAverageValue()) + ';' + this.num(r.getExtremeAverageValue()) + ";0;0;");
            }
            if (this._context.router().getUptime() > 3600000L && (r = recvRate.getRate(3600000L)) != null) {
                stats.setProperty("stat_bandwidthReceiveBps.60m", this.num(r.getAverageValue()) + ';' + this.num(r.getExtremeAverageValue()) + ";0;0;");
            }
        }
    }

    private String getPeriod(Rate rate) {
        return DataHelper.formatDuration((long)rate.getPeriod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String num(double num) {
        if (num < 0.0) {
            num = 0.0;
        }
        DecimalFormat decimalFormat = this._fmt;
        synchronized (decimalFormat) {
            return this._fmt.format(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String pct(double num) {
        if (num < 0.0) {
            num = 0.0;
        }
        DecimalFormat decimalFormat = this._pct;
        synchronized (decimalFormat) {
            return this._pct.format(num);
        }
    }

    public void renderStatusHTML(Writer out) {
    }
}

