/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.BandwidthLimitedInputStream;
import net.i2p.util.HTTPSendData;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class SubmitMessageHistoryJob
extends JobImpl {
    private Log _log;
    private static final long DEFAULT_REQUEUE_DELAY = 3600000L;
    public static final String PARAM_SUBMIT_DATA = "router.submitHistory";
    public static final boolean DEFAULT_SUBMIT_DATA = true;
    public static final String PARAM_SUBMIT_URL = "router.submitHistoryURL";
    public static final String DEFAULT_SUBMIT_URL = "http://i2p.net/cgi-bin/submitMessageHistory";

    public SubmitMessageHistoryJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(SubmitMessageHistoryJob.class);
    }

    public void runJob() {
        if (this.shouldSubmit()) {
            this.submit();
        } else {
            this._log.debug("Not submitting data");
            this.requeue(this.getRequeueDelay());
        }
    }

    private void submit() {
        I2PThread t = new I2PThread(new Runnable(){

            public void run() {
                SubmitMessageHistoryJob.this._log.debug("Submitting data");
                SubmitMessageHistoryJob.this.getContext().messageHistory().setPauseFlushes(true);
                String filename = SubmitMessageHistoryJob.this.getContext().messageHistory().getFilename();
                SubmitMessageHistoryJob.this.send(filename);
                SubmitMessageHistoryJob.this.getContext().messageHistory().setPauseFlushes(false);
                SubmitMessageHistoryJob job = new SubmitMessageHistoryJob(SubmitMessageHistoryJob.this.getContext());
                job.getTiming().setStartAfter(SubmitMessageHistoryJob.this.getContext().clock().now() + SubmitMessageHistoryJob.this.getRequeueDelay());
                SubmitMessageHistoryJob.this.getContext().jobQueue().addJob(job);
            }
        });
        t.setName("SubmitData");
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    private void send(String filename) {
        String url = this.getURL();
        try {
            File dataFile = new File(filename);
            if (!dataFile.exists() || !dataFile.canRead()) {
                this._log.warn("Unable to read the message data file [" + dataFile.getAbsolutePath() + "]");
                return;
            }
            long size = dataFile.length();
            FileInputStream fin = new FileInputStream(dataFile);
            BandwidthLimitedInputStream in = new BandwidthLimitedInputStream(this.getContext(), fin, null, true);
            boolean sent = HTTPSendData.postData((String)url, (long)size, (InputStream)in);
            fin.close();
            boolean deleted = dataFile.delete();
            this._log.debug("Submitted " + size + " bytes? " + sent + " and deleted? " + deleted);
        }
        catch (IOException ioe) {
            this._log.error("Error sending the data", (Throwable)ioe);
        }
    }

    private String getURL() {
        String str = this.getContext().router().getConfigSetting(PARAM_SUBMIT_URL);
        if (str == null || str.trim().length() <= 0) {
            return DEFAULT_SUBMIT_URL;
        }
        return str.trim();
    }

    private boolean shouldSubmit() {
        String str = this.getContext().router().getConfigSetting(PARAM_SUBMIT_DATA);
        if (str == null) {
            this._log.debug("History submit config not specified [router.submitHistory], default = true");
            return true;
        }
        this._log.debug("History submit config specified [" + str + "]");
        return Boolean.TRUE.toString().equals(str);
    }

    private long getRequeueDelay() {
        return 3600000L;
    }

    public String getName() {
        return "Submit Message History";
    }
}

