/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.util.RandomSource;

public class TunnelPoolSettings {
    private Hash _destination = null;
    private String _destinationNickname = null;
    private int _quantity = 2;
    private int _backupQuantity = 0;
    private int _duration = 600000;
    private int _length = 2;
    private int _lengthVariance = 1;
    private int _lengthOverride = 0;
    private boolean _isInbound = false;
    private boolean _isExploratory = false;
    private boolean _allowZeroHop = true;
    private int _IPRestriction = 2;
    private Properties _unknownOptions = new Properties();
    private Hash _randomKey = this.generateRandomKey();
    public static final String PREFIX_DEFAULT = "router.defaultPool.";
    public static final String PREFIX_INBOUND_EXPLORATORY = "router.inboundPool.";
    public static final String PREFIX_OUTBOUND_EXPLORATORY = "router.outboundPool.";
    public static final String PROP_NICKNAME = "nickname";
    public static final String PROP_QUANTITY = "quantity";
    public static final String PROP_BACKUP_QUANTITY = "backupQuantity";
    public static final String PROP_DURATION = "duration";
    public static final String PROP_LENGTH = "length";
    public static final String PROP_LENGTH_VARIANCE = "lengthVariance";
    public static final String PROP_ALLOW_ZERO_HOP = "allowZeroHop";
    public static final String PROP_IP_RESTRICTION = "IPRestriction";
    public static final int DEFAULT_QUANTITY = 2;
    public static final int DEFAULT_BACKUP_QUANTITY = 0;
    public static final int DEFAULT_DURATION = 600000;
    public static final int DEFAULT_LENGTH = 2;
    public static final int DEFAULT_LENGTH_VARIANCE = 1;
    public static final boolean DEFAULT_ALLOW_ZERO_HOP = true;
    public static final int DEFAULT_IP_RESTRICTION = 2;

    public int getQuantity() {
        return this._quantity;
    }

    public void setQuantity(int quantity) {
        this._quantity = quantity;
    }

    public int getBackupQuantity() {
        return this._backupQuantity;
    }

    public void setBackupQuantity(int quantity) {
        this._backupQuantity = quantity;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public boolean getAllowZeroHop() {
        return this._allowZeroHop;
    }

    public void setAllowZeroHop(boolean ok) {
        this._allowZeroHop = ok;
    }

    public int getLengthVariance() {
        return this._lengthVariance;
    }

    public void setLengthVariance(int variance) {
        this._lengthVariance = variance;
    }

    public int getLengthOverride() {
        return this._lengthOverride;
    }

    public void setLengthOverride(int variance) {
        this._lengthOverride = variance;
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public void setIsInbound(boolean isInbound) {
        this._isInbound = isInbound;
    }

    public boolean isExploratory() {
        return this._isExploratory;
    }

    public void setIsExploratory(boolean isExploratory) {
        this._isExploratory = isExploratory;
    }

    public int getDuration() {
        return this._duration;
    }

    public void setDuration(int ms) {
        this._duration = ms;
    }

    public Hash getDestination() {
        return this._destination;
    }

    public void setDestination(Hash dest) {
        this._destination = dest;
    }

    public Hash getRandomKey() {
        return this._randomKey;
    }

    public String getDestinationNickname() {
        return this._destinationNickname;
    }

    public void setDestinationNickname(String name) {
        this._destinationNickname = name;
    }

    public int getIPRestriction() {
        int r = this._IPRestriction;
        if (r > 4) {
            r = 4;
        } else if (r < 0) {
            r = 0;
        }
        return r;
    }

    public void setIPRestriction(int b) {
        this._IPRestriction = b;
    }

    public Properties getUnknownOptions() {
        return this._unknownOptions;
    }

    public void readFromProperties(String prefix, Properties props) {
        for (String string : props.keySet()) {
            String value = props.getProperty(string);
            if (!string.startsWith(prefix)) continue;
            if (string.equalsIgnoreCase(prefix + PROP_ALLOW_ZERO_HOP)) {
                this._allowZeroHop = TunnelPoolSettings.getBoolean(value, true);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_BACKUP_QUANTITY)) {
                this._backupQuantity = TunnelPoolSettings.getInt(value, 0);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_DURATION)) {
                this._duration = TunnelPoolSettings.getInt(value, 600000);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_LENGTH)) {
                this._length = TunnelPoolSettings.getInt(value, 2);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_LENGTH_VARIANCE)) {
                this._lengthVariance = TunnelPoolSettings.getInt(value, 1);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_QUANTITY)) {
                this._quantity = TunnelPoolSettings.getInt(value, 2);
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_NICKNAME)) {
                this._destinationNickname = value;
                continue;
            }
            if (string.equalsIgnoreCase(prefix + PROP_IP_RESTRICTION)) {
                this._IPRestriction = TunnelPoolSettings.getInt(value, 2);
                continue;
            }
            this._unknownOptions.setProperty(string.substring(prefix != null ? prefix.length() : 0), value);
        }
    }

    public void writeToProperties(String prefix, Properties props) {
        if (props == null) {
            return;
        }
        props.setProperty(prefix + PROP_ALLOW_ZERO_HOP, "" + this._allowZeroHop);
        props.setProperty(prefix + PROP_BACKUP_QUANTITY, "" + this._backupQuantity);
        props.setProperty(prefix + PROP_DURATION, "" + this._duration);
        props.setProperty(prefix + PROP_LENGTH, "" + this._length);
        props.setProperty(prefix + PROP_LENGTH_VARIANCE, "" + this._lengthVariance);
        if (this._destinationNickname != null) {
            props.setProperty(prefix + PROP_NICKNAME, "" + this._destinationNickname);
        }
        props.setProperty(prefix + PROP_QUANTITY, "" + this._quantity);
        props.setProperty(prefix + PROP_IP_RESTRICTION, "" + this._IPRestriction);
        for (String string : this._unknownOptions.keySet()) {
            String val = this._unknownOptions.getProperty(string);
            props.setProperty(prefix + string, val);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Properties p = new Properties();
        this.writeToProperties("", p);
        buf.append("Tunnel pool settings:\n");
        buf.append("====================================\n");
        for (String string : p.keySet()) {
            String val = p.getProperty(string);
            buf.append(string).append(" = [").append(val).append("]\n");
        }
        buf.append("is inbound? ").append(this._isInbound).append("\n");
        buf.append("is exploratory? ").append(this._isExploratory).append("\n");
        buf.append("====================================\n");
        return buf.toString();
    }

    private Hash generateRandomKey() {
        byte[] hash = new byte[32];
        RandomSource.getInstance().nextBytes(hash);
        return new Hash(hash);
    }

    private static final boolean getBoolean(String str, boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        boolean v = "TRUE".equalsIgnoreCase(str) || "YES".equalsIgnoreCase(str);
        return v;
    }

    private static final int getInt(String str, int defaultValue) {
        return (int)TunnelPoolSettings.getLong(str, defaultValue);
    }

    private static final long getLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            long val = Long.parseLong(str);
            return val;
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }
}

