/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class TunnelSettings
extends DataStructureImpl {
    private I2PAppContext _context;
    private int _depth;
    private long _msgsPerMinuteAvg;
    private long _bytesPerMinuteAvg;
    private long _msgsPerMinutePeak;
    private long _bytesPerMinutePeak;
    private boolean _includeDummy;
    private boolean _reorder;
    private long _expiration;
    private long _created;

    public TunnelSettings(I2PAppContext context) {
        this._context = context;
        this._depth = 0;
        this._msgsPerMinuteAvg = 0L;
        this._msgsPerMinutePeak = 0L;
        this._bytesPerMinuteAvg = 0L;
        this._bytesPerMinutePeak = 0L;
        this._includeDummy = false;
        this._reorder = false;
        this._expiration = 0L;
        this._created = this._context.clock().now();
    }

    public int getDepth() {
        return this._depth;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    public long getMessagesPerMinuteAverage() {
        return this._msgsPerMinuteAvg;
    }

    public long getMessagesPerMinutePeak() {
        return this._msgsPerMinutePeak;
    }

    public long getBytesPerMinuteAverage() {
        return this._bytesPerMinuteAvg;
    }

    public long getBytesPerMinutePeak() {
        return this._bytesPerMinutePeak;
    }

    public void setMessagesPerMinuteAverage(long msgs) {
        this._msgsPerMinuteAvg = msgs;
    }

    public void setMessagesPerMinutePeak(long msgs) {
        this._msgsPerMinutePeak = msgs;
    }

    public void setBytesPerMinuteAverage(long bytes) {
        this._bytesPerMinuteAvg = bytes;
    }

    public void setBytesPerMinutePeak(long bytes) {
        this._bytesPerMinutePeak = bytes;
    }

    public boolean getIncludeDummy() {
        return this._includeDummy;
    }

    public void setIncludeDummy(boolean include) {
        this._includeDummy = include;
    }

    public boolean getReorder() {
        return this._reorder;
    }

    public void setReorder(boolean reorder) {
        this._reorder = reorder;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public long getCreated() {
        return this._created;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        Boolean b = DataHelper.readBoolean((InputStream)in);
        if (b == null) {
            throw new DataFormatException("Null includeDummy boolean value");
        }
        this._includeDummy = b;
        b = DataHelper.readBoolean((InputStream)in);
        if (b == null) {
            throw new DataFormatException("Null reorder boolean value");
        }
        this._reorder = b;
        this._depth = (int)DataHelper.readLong((InputStream)in, (int)1);
        this._bytesPerMinuteAvg = DataHelper.readLong((InputStream)in, (int)4);
        this._bytesPerMinutePeak = DataHelper.readLong((InputStream)in, (int)4);
        Date exp = DataHelper.readDate((InputStream)in);
        this._expiration = exp == null ? 0L : exp.getTime();
        this._msgsPerMinuteAvg = DataHelper.readLong((InputStream)in, (int)4);
        this._msgsPerMinutePeak = DataHelper.readLong((InputStream)in, (int)4);
        Date created = DataHelper.readDate((InputStream)in);
        this._created = created != null ? created.getTime() : this._context.clock().now();
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        DataHelper.writeBoolean((OutputStream)out, (Boolean)(this._includeDummy ? Boolean.TRUE : Boolean.FALSE));
        DataHelper.writeBoolean((OutputStream)out, (Boolean)(this._reorder ? Boolean.TRUE : Boolean.FALSE));
        DataHelper.writeLong((OutputStream)out, (int)1, (long)this._depth);
        DataHelper.writeLong((OutputStream)out, (int)4, (long)this._bytesPerMinuteAvg);
        DataHelper.writeLong((OutputStream)out, (int)4, (long)this._bytesPerMinutePeak);
        if (this._expiration <= 0L) {
            DataHelper.writeDate((OutputStream)out, (Date)new Date(0L));
        } else {
            DataHelper.writeDate((OutputStream)out, (Date)new Date(this._expiration));
        }
        DataHelper.writeLong((OutputStream)out, (int)4, (long)this._msgsPerMinuteAvg);
        DataHelper.writeLong((OutputStream)out, (int)4, (long)this._msgsPerMinutePeak);
        DataHelper.writeDate((OutputStream)out, (Date)new Date(this._created));
    }

    public int hashCode() {
        int rv = 0;
        rv += this._includeDummy ? 100 : 0;
        rv += this._reorder ? 50 : 0;
        rv += this._depth;
        rv = (int)((long)rv + this._bytesPerMinuteAvg);
        rv = (int)((long)rv + this._bytesPerMinutePeak);
        rv = (int)((long)rv + this._expiration);
        rv = (int)((long)rv + this._msgsPerMinuteAvg);
        rv = (int)((long)rv + this._msgsPerMinutePeak);
        return rv;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TunnelSettings) {
            TunnelSettings settings = (TunnelSettings)((Object)obj);
            return settings.getBytesPerMinuteAverage() == this.getBytesPerMinuteAverage() && settings.getBytesPerMinutePeak() == this.getBytesPerMinutePeak() && settings.getDepth() == this.getDepth() && settings.getExpiration() == this.getExpiration() && settings.getIncludeDummy() == this.getIncludeDummy() && settings.getMessagesPerMinuteAverage() == this.getMessagesPerMinuteAverage() && settings.getMessagesPerMinutePeak() == this.getMessagesPerMinutePeak() && settings.getReorder() == this.getReorder();
        }
        return false;
    }
}

