/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.Payload;
import net.i2p.data.i2cp.DisconnectMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientManager;
import net.i2p.router.client.ClientMessageEventListener;
import net.i2p.router.client.ClientWriterRunner;
import net.i2p.router.client.LeaseRequestState;
import net.i2p.router.client.MessageReceivedJob;
import net.i2p.router.client.ReportAbuseJob;
import net.i2p.router.client.RequestLeaseSetJob;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;
import net.i2p.util.SimpleTimer;

public class ClientConnectionRunner {
    private Log _log;
    private RouterContext _context;
    private ClientManager _manager;
    private Socket _socket;
    private OutputStream _out;
    private SessionId _sessionId;
    private SessionConfig _config;
    private Map _messages;
    private LeaseRequestState _leaseRequest;
    private LeaseSet _currentLeaseSet;
    private Set _acceptedPending;
    private I2CPMessageReader _reader;
    private List _alreadyProcessed;
    private ClientWriterRunner _writer;
    private Hash _destHashCache;
    private boolean _dead;
    private static volatile int __id = 0;
    private static final int MAX_MESSAGE_ID = Short.MAX_VALUE;
    private static volatile int _messageId = RandomSource.getInstance().nextInt(Short.MAX_VALUE);
    private static Object _messageIdLock = new Object();
    private static final long REQUEUE_DELAY = 500L;

    public ClientConnectionRunner(RouterContext context, ClientManager manager, Socket socket) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientConnectionRunner.class);
        this._manager = manager;
        this._socket = socket;
        this._config = null;
        this._messages = new HashMap();
        this._alreadyProcessed = new ArrayList();
        this._acceptedPending = new HashSet();
        this._dead = false;
    }

    public void startRunning() {
        try {
            this._reader = new I2CPMessageReader(this._socket.getInputStream(), (I2CPMessageReader.I2CPMessageEventListener)new ClientMessageEventListener(this._context, this));
            this._writer = new ClientWriterRunner(this._context, this);
            I2PThread t = new I2PThread((Runnable)this._writer);
            t.setName("Writer " + ++__id);
            t.setDaemon(true);
            t.setPriority(10);
            t.start();
            this._out = this._socket.getOutputStream();
            this._reader.startReading();
        }
        catch (IOException ioe) {
            this._log.error("Error starting up the runner", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRunning() {
        if (this._dead) {
            return;
        }
        if (this._context.router().isAlive() && this._log.shouldLog(30)) {
            this._log.warn("Stop the I2CP connection!  current leaseSet: " + this._currentLeaseSet, (Throwable)new Exception("Stop client connection"));
        }
        this._dead = true;
        if (this._reader != null) {
            this._reader.stopReading();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this._messages;
        synchronized (object) {
            this._messages.clear();
        }
        if (this._manager != null) {
            this._manager.unregisterConnection(this);
        }
        if (this._currentLeaseSet != null) {
            this._context.netDb().unpublish(this._currentLeaseSet);
        }
        this._leaseRequest = null;
        object = this._alreadyProcessed;
        synchronized (object) {
            this._alreadyProcessed.clear();
        }
        this._config = null;
    }

    public SessionConfig getConfig() {
        return this._config;
    }

    public LeaseSet getLeaseSet() {
        return this._currentLeaseSet;
    }

    void setLeaseSet(LeaseSet ls) {
        this._currentLeaseSet = ls;
    }

    public Hash getDestHash() {
        return this._destHashCache;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        if (id != null) {
            this._sessionId = id;
        }
    }

    LeaseRequestState getLeaseRequest() {
        return this._leaseRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLeaseRequest(LeaseRequestState req) {
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            if (this._leaseRequest != null && req != this._leaseRequest) {
                this._log.error("Changing leaseRequest from " + this._leaseRequest + " to " + req);
            }
            this._leaseRequest = req;
        }
    }

    boolean isDead() {
        return this._dead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Payload getPayload(MessageId id) {
        Payload rv = null;
        long beforeLock = this._context.clock().now();
        long inLock = 0L;
        Map map = this._messages;
        synchronized (map) {
            inLock = this._context.clock().now();
            rv = (Payload)this._messages.get(id);
        }
        long afterLock = this._context.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("alreadyAccepted.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPayload(MessageId id, Payload payload) {
        long beforeLock = this._context.clock().now();
        long inLock = 0L;
        Map map = this._messages;
        synchronized (map) {
            inLock = this._context.clock().now();
            this._messages.put(id, payload);
        }
        long afterLock = this._context.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("setPayload.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePayload(MessageId id) {
        long beforeLock = this._context.clock().now();
        long inLock = 0L;
        Map map = this._messages;
        synchronized (map) {
            inLock = this._context.clock().now();
            this._messages.remove(id);
        }
        long afterLock = this._context.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("removePayload.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
    }

    void sessionEstablished(SessionConfig config) {
        this._destHashCache = config.getDestination().calculateHash();
        if (this._log.shouldLog(10)) {
            this._log.debug("SessionEstablished called for destination " + this._destHashCache.toBase64());
        }
        this._config = config;
        this._manager.destinationEstablished(this);
    }

    void updateMessageDeliveryStatus(MessageId id, boolean delivered) {
        if (this._dead) {
            return;
        }
        this._context.jobQueue().addJob(new MessageDeliveryStatusUpdate(id, delivered));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaseSetCreated(LeaseSet ls) {
        LeaseRequestState state = null;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            state = this._leaseRequest;
            if (state == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("LeaseRequest is null and we've received a new lease?! perhaps this is odd... " + ls);
                }
                return;
            }
            state.setIsSuccessful(true);
            this._currentLeaseSet = ls;
            if (this._log.shouldLog(10)) {
                this._log.debug("LeaseSet created fully: " + state + " / " + ls);
            }
            this._leaseRequest = null;
        }
        if (state != null && state.getOnGranted() != null) {
            this._context.jobQueue().addJob(state.getOnGranted());
        }
    }

    void disconnectClient(String reason) {
        if (this._log.shouldLog(50)) {
            this._log.log(50, "Disconnecting the client (" + this._config + ": " + reason);
        }
        DisconnectMessage msg = new DisconnectMessage();
        msg.setReason(reason);
        try {
            this.doSend((I2CPMessage)msg);
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error writing out the disconnect message: " + (Object)((Object)ime));
        }
        this.stopRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageId distributeMessage(SendMessageMessage message) {
        Payload payload = message.getPayload();
        Destination dest = message.getDestination();
        MessageId id = new MessageId();
        id.setMessageId((long)ClientConnectionRunner.getNextMessageId());
        long beforeLock = this._context.clock().now();
        long inLock = 0L;
        Set set = this._acceptedPending;
        synchronized (set) {
            inLock = this._context.clock().now();
            this._acceptedPending.add(id);
        }
        long afterLock = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.warn("distributeMessage.locking took: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("** Receiving message [" + id.getMessageId() + "] with payload of size [" + payload.getSize() + "]" + " for session [" + this._sessionId.getSessionId() + "]");
        }
        long beforeDistribute = this._context.clock().now();
        SessionConfig cfg = this._config;
        if (cfg != null) {
            this._manager.distributeMessage(cfg.getDestination(), dest, payload, id);
        }
        long timeToDistribute = this._context.clock().now() - beforeDistribute;
        if (this._log.shouldLog(10)) {
            this._log.warn("Time to distribute in the manager to " + dest.calculateHash().toBase64() + ": " + timeToDistribute);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ackSendMessage(MessageId id, long nonce) {
        SessionId sid = this._sessionId;
        if (sid == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Acking message send [accepted]" + id + " / " + nonce + " for sessionId " + sid, (Throwable)new Exception("sendAccepted"));
        }
        MessageStatusMessage status = new MessageStatusMessage();
        status.setMessageId(id.getMessageId());
        status.setSessionId((long)sid.getSessionId());
        status.setSize(0L);
        status.setNonce(nonce);
        status.setStatus(1);
        try {
            this.doSend((I2CPMessage)status);
            long beforeLock = this._context.clock().now();
            long inLock = 0L;
            Set set = this._acceptedPending;
            synchronized (set) {
                inLock = this._context.clock().now();
                this._acceptedPending.remove(id);
            }
            long afterLock = this._context.clock().now();
            if (afterLock - beforeLock > 50L) {
                this._log.warn("ackSendMessage.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
            }
        }
        catch (I2CPMessageException ime) {
            this._log.error("Error writing out the message status message: " + (Object)((Object)ime));
        }
    }

    void receiveMessage(Destination toDest, Destination fromDest, Payload payload) {
        if (this._dead) {
            return;
        }
        MessageReceivedJob j = new MessageReceivedJob(this._context, this, toDest, fromDest, payload);
        this._context.jobQueue().addJob(j);
    }

    public void reportAbuse(String reason, int severity) {
        if (this._dead) {
            return;
        }
        this._context.jobQueue().addJob(new ReportAbuseJob(this._context, this, reason, severity));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestLeaseSet(LeaseSet set, long expirationTime, Job onCreateJob, Job onFailedJob) {
        if (this._dead) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Requesting leaseSet from a dead client: " + set);
            }
            if (onFailedJob != null) {
                this._context.jobQueue().addJob(onFailedJob);
            }
            return;
        }
        int leases = set.getLeaseCount();
        if (this._currentLeaseSet != null && this._currentLeaseSet.getLeaseCount() == leases) {
            for (int i = 0; i < leases && this._currentLeaseSet.getLease(i).getTunnelId().equals((Object)set.getLease(i).getTunnelId()) && this._currentLeaseSet.getLease(i).getGateway().equals((Object)set.getLease(i).getGateway()); ++i) {
                if (i != leases - 1) continue;
                if (this._log.shouldLog(20)) {
                    this._log.info("Requested leaseSet hasn't changed");
                }
                if (onCreateJob != null) {
                    this._context.jobQueue().addJob(onCreateJob);
                }
                return;
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Current leaseSet " + this._currentLeaseSet + "\nNew leaseSet " + set);
        }
        LeaseRequestState state = null;
        ClientConnectionRunner clientConnectionRunner = this;
        synchronized (clientConnectionRunner) {
            state = this._leaseRequest;
            if (state != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Already requesting " + state);
                }
                LeaseSet requested = state.getRequested();
                LeaseSet granted = state.getGranted();
                long ours = set.getEarliestLeaseDate();
                if (!(requested != null && requested.getEarliestLeaseDate() > ours || granted != null && granted.getEarliestLeaseDate() > ours)) {
                    SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new Rerequest(set, expirationTime, onCreateJob, onFailedJob), 3000L);
                }
                return;
            }
            this._leaseRequest = state = new LeaseRequestState(onCreateJob, onFailedJob, this._context.clock().now() + expirationTime, set);
            this._log.debug("Not already requesting, continue to request " + set);
        }
        this._context.jobQueue().addJob(new RequestLeaseSetJob(this._context, this, set, this._context.clock().now() + expirationTime, onCreateJob, onFailedJob, state));
    }

    void disconnected() {
        if (this._log.shouldLog(30)) {
            this._log.warn("Disconnected", (Throwable)new Exception("Disconnected?"));
        }
        this.stopRunning();
    }

    boolean getIsDead() {
        return this._dead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMessage(I2CPMessage msg) {
        long before = this._context.clock().now();
        try {
            OutputStream outputStream = this._out;
            synchronized (outputStream) {
                msg.writeMessage(this._out);
                this._out.flush();
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("after writeMessage(" + msg.getClass().getName() + "): " + (this._context.clock().now() - before) + "ms");
            }
        }
        catch (I2CPMessageException ime) {
            this._log.error("Message exception sending I2CP message: " + (Object)((Object)ime));
            this.stopRunning();
        }
        catch (IOException ioe) {
            this._log.error("IO exception sending I2CP message: " + ioe);
            this.stopRunning();
        }
        catch (Throwable t) {
            this._log.log(50, "Unhandled exception sending I2CP message", t);
            this.stopRunning();
        }
        finally {
            long after = this._context.clock().now();
            long lag = after - before;
            if (lag > 300L && this._log.shouldLog(30)) {
                this._log.warn("synchronization on the i2cp message send took too long (" + lag + "ms): " + msg);
            }
        }
    }

    void doSend(I2CPMessage msg) throws I2CPMessageException {
        if (this._out == null) {
            throw new I2CPMessageException("Output stream is not initialized");
        }
        if (msg == null) {
            throw new I2CPMessageException("Null message?!");
        }
        if (this._log.shouldLog(10)) {
            if (this._config == null || this._config.getDestination() == null) {
                this._log.debug("before doSend of a " + msg.getClass().getName() + " message on for establishing i2cp con");
            } else {
                this._log.debug("before doSend of a " + msg.getClass().getName() + " message on for " + this._config.getDestination().calculateHash().toBase64());
            }
        }
        this._writer.addMessage(msg);
        if (this._log.shouldLog(10)) {
            if (this._config == null || this._config.getDestination() == null) {
                this._log.debug("after doSend of a " + msg.getClass().getName() + " message on for establishing i2cp con");
            } else {
                this._log.debug("after doSend of a " + msg.getClass().getName() + " message on for " + this._config.getDestination().calculateHash().toBase64());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getNextMessageId() {
        Object object = _messageIdLock;
        synchronized (object) {
            int messageId = ++_messageId % Short.MAX_VALUE;
            if (_messageId >= Short.MAX_VALUE) {
                _messageId = 0;
            }
            return messageId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyAccepted(MessageId id) {
        if (this._dead) {
            return false;
        }
        boolean isPending = false;
        int pending = 0;
        String buf = null;
        long beforeLock = this._context.clock().now();
        long inLock = 0L;
        Set set = this._acceptedPending;
        synchronized (set) {
            inLock = this._context.clock().now();
            if (this._acceptedPending.contains(id)) {
                isPending = true;
            }
            pending = this._acceptedPending.size();
            buf = this._acceptedPending.toString();
        }
        long afterLock = this._context.clock().now();
        if (afterLock - beforeLock > 50L) {
            this._log.warn("alreadyAccepted.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
        }
        if (pending >= 1) {
            this._log.warn("Pending acks: " + pending + ": " + buf);
        }
        return !isPending;
    }

    private class MessageDeliveryStatusUpdate
    extends JobImpl {
        private MessageId _messageId;
        private boolean _success;
        private long _lastTried;

        public MessageDeliveryStatusUpdate(MessageId id, boolean success) {
            super(ClientConnectionRunner.this._context);
            this._messageId = id;
            this._success = success;
            this._lastTried = 0L;
        }

        public String getName() {
            return "Update Delivery Status";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runJob() {
            if (ClientConnectionRunner.this._dead) {
                return;
            }
            MessageStatusMessage msg = new MessageStatusMessage();
            msg.setMessageId(this._messageId.getMessageId());
            msg.setSessionId((long)ClientConnectionRunner.this._sessionId.getSessionId());
            msg.setNonce(2L);
            msg.setSize(0L);
            if (this._success) {
                msg.setStatus(4);
            } else {
                msg.setStatus(5);
            }
            if (!ClientConnectionRunner.this.alreadyAccepted(this._messageId)) {
                ClientConnectionRunner.this._log.warn("Almost send an update for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session [" + ClientConnectionRunner.this._sessionId.getSessionId() + "] before they knew the messageId!  delaying .5s");
                this._lastTried = ClientConnectionRunner.this._context.clock().now();
                this.requeue(500L);
                return;
            }
            boolean alreadyProcessed = false;
            long beforeLock = ClientConnectionRunner.this._context.clock().now();
            long inLock = 0L;
            List list = ClientConnectionRunner.this._alreadyProcessed;
            synchronized (list) {
                inLock = ClientConnectionRunner.this._context.clock().now();
                if (ClientConnectionRunner.this._alreadyProcessed.contains(this._messageId)) {
                    ClientConnectionRunner.this._log.warn("Status already updated");
                    alreadyProcessed = true;
                } else {
                    ClientConnectionRunner.this._alreadyProcessed.add(this._messageId);
                    while (ClientConnectionRunner.this._alreadyProcessed.size() > 10) {
                        ClientConnectionRunner.this._alreadyProcessed.remove(0);
                    }
                }
            }
            long afterLock = ClientConnectionRunner.this._context.clock().now();
            if (afterLock - beforeLock > 50L) {
                ClientConnectionRunner.this._log.warn("MessageDeliveryStatusUpdate.locking took too long: " + (afterLock - beforeLock) + " overall, synchronized took " + (inLock - beforeLock));
            }
            if (alreadyProcessed) {
                return;
            }
            if (this._lastTried > 0L) {
                if (ClientConnectionRunner.this._log.shouldLog(10)) {
                    ClientConnectionRunner.this._log.info("Updating message status for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session [" + ClientConnectionRunner.this._sessionId.getSessionId() + "] (with nonce=2), retrying after [" + (ClientConnectionRunner.this._context.clock().now() - this._lastTried) + "]", (Throwable)this.getAddedBy());
                }
            } else if (ClientConnectionRunner.this._log.shouldLog(10)) {
                ClientConnectionRunner.this._log.debug("Updating message status for message " + this._messageId + " to " + MessageStatusMessage.getStatusString((int)msg.getStatus()) + " for session [" + ClientConnectionRunner.this._sessionId.getSessionId() + "] (with nonce=2)");
            }
            try {
                ClientConnectionRunner.this.doSend((I2CPMessage)msg);
            }
            catch (I2CPMessageException ime) {
                ClientConnectionRunner.this._log.warn("Error updating the status for message ID " + this._messageId, (Throwable)ime);
            }
        }
    }

    private class Rerequest
    implements SimpleTimer.TimedEvent {
        private LeaseSet _ls;
        private long _expirationTime;
        private Job _onCreate;
        private Job _onFailed;

        public Rerequest(LeaseSet ls, long expirationTime, Job onCreate, Job onFailed) {
            this._ls = ls;
            this._expirationTime = expirationTime;
            this._onCreate = onCreate;
            this._onFailed = onFailed;
        }

        public void timeReached() {
            ClientConnectionRunner.this.requestLeaseSet(this._ls, this._expirationTime, this._onCreate, this._onFailed);
        }
    }
}

