/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Certificate;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.DeliveryInstructions;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.router.message.SendGarlicJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.Log;

public class BuildTestMessageJob
extends JobImpl {
    private Log _log;
    private RouterInfo _target;
    private Hash _replyTo;
    private Job _onSend;
    private Job _onSendFailed;
    private long _timeoutMs;
    private int _priority;
    private long _testMessageKey;

    public BuildTestMessageJob(RouterContext ctx, RouterInfo target, Hash replyTo, Job onSendJob, Job onSendFailedJob, long timeoutMs, int priority) {
        super(ctx);
        this._log = ctx.logManager().getLog(BuildTestMessageJob.class);
        this._target = target;
        this._replyTo = replyTo;
        this._onSend = onSendJob;
        this._onSendFailed = onSendFailedJob;
        this._timeoutMs = timeoutMs;
        this._priority = priority;
        this._testMessageKey = -1L;
    }

    public String getName() {
        return "Build Test Message";
    }

    public void runJob() {
        if (this.alreadyKnownReachable()) {
            this.getContext().jobQueue().addJob(this._onSend);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Building garlic message to test " + this._target.getIdentity().getHash().toBase64());
        }
        GarlicConfig config = this.buildGarlicCloveConfig();
        JobReplyJob replyJob = new JobReplyJob(this.getContext(), this._onSend, config.getRecipient().getIdentity().getPublicKey(), config.getId(), null, new HashSet());
        MessageSelector sel = this.buildMessageSelector();
        SendGarlicJob job = new SendGarlicJob(this.getContext(), config, null, this._onSendFailed, replyJob, this._onSendFailed, this._timeoutMs, this._priority, sel);
        this.getContext().jobQueue().addJob(job);
    }

    private boolean alreadyKnownReachable() {
        PeerProfile profile = this.getContext().profileOrganizer().getProfile(this._target.getIdentity().getHash());
        return profile != null && profile.getIsActive();
    }

    private MessageSelector buildMessageSelector() {
        return new TestMessageSelector(this._testMessageKey, this._timeoutMs + this.getContext().clock().now());
    }

    private GarlicConfig buildGarlicCloveConfig() {
        this._testMessageKey = this.getContext().random().nextLong(0xFFFFFFFFL);
        if (this._log.shouldLog(20)) {
            this._log.info("Test message key: " + this._testMessageKey);
        }
        GarlicConfig config = new GarlicConfig();
        PayloadGarlicConfig ackClove = this.buildAckClove();
        config.addClove(ackClove);
        DeliveryInstructions instructions = new DeliveryInstructions();
        instructions.setDeliveryMode(2);
        instructions.setDelayRequested(false);
        instructions.setDelaySeconds(0L);
        instructions.setEncrypted(false);
        instructions.setEncryptionKey(null);
        instructions.setRouter(this._target.getIdentity().getHash());
        instructions.setTunnelId(null);
        config.setCertificate(new Certificate(0, null));
        config.setDeliveryInstructions(instructions);
        config.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        config.setExpiration(this._timeoutMs + this.getContext().clock().now() + 120000L);
        config.setRecipient(this._target);
        config.setRequestAck(false);
        return config;
    }

    private PayloadGarlicConfig buildAckClove() {
        PayloadGarlicConfig ackClove = new PayloadGarlicConfig();
        DeliveryInstructions ackInstructions = new DeliveryInstructions();
        ackInstructions.setDeliveryMode(2);
        ackInstructions.setRouter(this._replyTo);
        ackInstructions.setDelayRequested(false);
        ackInstructions.setDelaySeconds(0L);
        ackInstructions.setEncrypted(false);
        DeliveryStatusMessage msg = new DeliveryStatusMessage(this.getContext());
        msg.setArrival(this.getContext().clock().now());
        msg.setMessageId(this._testMessageKey);
        if (this._log.shouldLog(10)) {
            this._log.debug("Delivery status message key: " + this._testMessageKey + " arrival: " + msg.getArrival());
        }
        ackClove.setCertificate(new Certificate(0, null));
        ackClove.setDeliveryInstructions(ackInstructions);
        ackClove.setExpiration(this._timeoutMs + this.getContext().clock().now());
        ackClove.setId(this.getContext().random().nextLong(0xFFFFFFFFL));
        ackClove.setPayload(msg);
        ackClove.setRecipient(this._target);
        ackClove.setRequestAck(false);
        return ackClove;
    }

    private static final class JobReplyJob
    extends JobImpl
    implements ReplyJob {
        private Job _job;
        private PublicKey _target;
        private long _msgId;
        private Set _sessionTagsDelivered;
        private SessionKey _keyDelivered;

        public JobReplyJob(RouterContext ctx, Job job, PublicKey target, long msgId, SessionKey keyUsed, Set tagsDelivered) {
            super(ctx);
            this._job = job;
            this._target = target;
            this._msgId = msgId;
            this._keyDelivered = keyUsed;
            this._sessionTagsDelivered = tagsDelivered;
        }

        public String getName() {
            return "Reply To Test Message Received";
        }

        public void runJob() {
            if (this._keyDelivered != null && this._sessionTagsDelivered != null && this._sessionTagsDelivered.size() > 0) {
                this.getContext().sessionKeyManager().tagsDelivered(this._target, this._keyDelivered, this._sessionTagsDelivered);
            }
            this.getContext().jobQueue().addJob(this._job);
        }

        public void setMessage(I2NPMessage message) {
        }
    }

    private static final class TestMessageSelector
    implements MessageSelector {
        private long _testMessageKey;
        private long _timeout;

        public TestMessageSelector(long key, long timeout) {
            this._testMessageKey = key;
            this._timeout = timeout;
        }

        public boolean continueMatching() {
            return false;
        }

        public long getExpiration() {
            return this._timeout;
        }

        public boolean isMatch(I2NPMessage inMsg) {
            if (inMsg.getType() == 10) {
                return ((DeliveryStatusMessage)inMsg).getMessageId() == this._testMessageKey;
            }
            return false;
        }
    }
}

