/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.i2p.data.Certificate;
import net.i2p.data.PublicKey;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DeliveryInstructions;

public class GarlicConfig {
    private RouterInfo _recipient = null;
    private PublicKey _recipientPublicKey = null;
    private Certificate _cert = null;
    private long _id = -1L;
    private long _expiration = -1L;
    private List _cloveConfigs = new ArrayList();
    private DeliveryInstructions _instructions = null;
    private boolean _requestAck = false;
    private RouterInfo _replyThroughRouter = null;
    private DeliveryInstructions _replyInstructions = null;
    private Certificate _replyBlockCertificate = null;
    private long _replyBlockMessageId = -1L;
    private long _replyBlockExpiration = -1L;
    private static final String NL = System.getProperty("line.separator");

    public void setRecipient(RouterInfo info) {
        this._recipient = info;
    }

    public RouterInfo getRecipient() {
        return this._recipient;
    }

    public void setRecipientPublicKey(PublicKey recipientPublicKey) {
        this._recipientPublicKey = recipientPublicKey;
    }

    public PublicKey getRecipientPublicKey() {
        return this._recipientPublicKey;
    }

    public void setCertificate(Certificate cert) {
        this._cert = cert;
    }

    public Certificate getCertificate() {
        return this._cert;
    }

    public void setId(long id) {
        this._id = id;
    }

    public long getId() {
        return this._id;
    }

    public void setExpiration(long expiration) {
        this._expiration = expiration;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setDeliveryInstructions(DeliveryInstructions instructions) {
        this._instructions = instructions;
    }

    public DeliveryInstructions getDeliveryInstructions() {
        return this._instructions;
    }

    public void setRequestAck(boolean request) {
        this._requestAck = request;
    }

    public boolean getRequestAck() {
        return this._requestAck;
    }

    public void setReplyThroughRouter(RouterInfo replyThroughRouter) {
        this._replyThroughRouter = replyThroughRouter;
    }

    public RouterInfo getReplyThroughRouter() {
        return this._replyThroughRouter;
    }

    public void setReplyInstructions(DeliveryInstructions instructions) {
        this._replyInstructions = instructions;
    }

    public DeliveryInstructions getReplyInstructions() {
        return this._replyInstructions;
    }

    public long getReplyBlockMessageId() {
        return this._replyBlockMessageId;
    }

    public void setReplyBlockMessageId(long id) {
        this._replyBlockMessageId = id;
    }

    public Certificate getReplyBlockCertificate() {
        return this._replyBlockCertificate;
    }

    public void setReplyBlockCertificate(Certificate cert) {
        this._replyBlockCertificate = cert;
    }

    public long getReplyBlockExpiration() {
        return this._replyBlockExpiration;
    }

    public void setReplyBlockExpiration(long expiration) {
        this._replyBlockExpiration = expiration;
    }

    public void addClove(GarlicConfig config) {
        if (config != null) {
            this._cloveConfigs.add(config);
        }
    }

    public int getCloveCount() {
        return this._cloveConfigs.size();
    }

    public GarlicConfig getClove(int index) {
        return (GarlicConfig)this._cloveConfigs.get(index);
    }

    public void clearCloves() {
        this._cloveConfigs.clear();
    }

    protected String getSubData() {
        return "";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<garlicConfig>").append(NL);
        buf.append("<certificate>").append(this.getCertificate()).append("</certificate>").append(NL);
        buf.append("<instructions>").append((Object)this.getDeliveryInstructions()).append("</instructions>").append(NL);
        buf.append("<expiration>").append(new Date(this.getExpiration())).append("</expiration>").append(NL);
        buf.append("<garlicId>").append(this.getId()).append("</garlicId>").append(NL);
        buf.append("<recipient>").append(this.getRecipient()).append("</recipient>").append(NL);
        buf.append("<recipientPublicKey>").append(this.getRecipientPublicKey()).append("</recipientPublicKey>").append(NL);
        buf.append("<replyBlockCertificate>").append(this.getReplyBlockCertificate()).append("</replyBlockCertificate>").append(NL);
        buf.append("<replyBlockExpiration>").append(new Date(this.getReplyBlockExpiration())).append("</replyBlockExpiration>").append(NL);
        buf.append("<replyBlockMessageId>").append(this.getReplyBlockMessageId()).append("</replyBlockMessageId>").append(NL);
        buf.append("<replyInstructions>").append((Object)this.getReplyInstructions()).append("</replyInstructions>").append(NL);
        buf.append("<replyThroughRouter>").append(this.getReplyThroughRouter()).append("</replyThroughRouter>").append(NL);
        buf.append("<requestAck>").append(this.getRequestAck()).append("</requestAck>").append(NL);
        buf.append(this.getSubData());
        buf.append("<subcloves>").append(NL);
        for (int i = 0; i < this.getCloveCount(); ++i) {
            buf.append("<clove>").append(this.getClove(i)).append("</clove>").append(NL);
        }
        buf.append("</subcloves>").append(NL);
        buf.append("</garlicConfig>").append(NL);
        return buf.toString();
    }
}

