/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.SessionKey;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.GarlicMessageBuilder;
import net.i2p.util.Log;

public class SendGarlicJob
extends JobImpl {
    private Log _log;
    private GarlicConfig _config;
    private Job _onSend;
    private Job _onSendFailed;
    private ReplyJob _onReply;
    private Job _onReplyFailed;
    private long _timeoutMs;
    private int _priority;
    private MessageSelector _replySelector;
    private GarlicMessage _message;
    private SessionKey _wrappedKey;
    private Set _wrappedTags;

    public SendGarlicJob(RouterContext ctx, GarlicConfig config, Job onSend, Job onSendFailed, ReplyJob onReply, Job onReplyFailed, long timeoutMs, int priority, MessageSelector replySelector) {
        this(ctx, config, onSend, onSendFailed, onReply, onReplyFailed, timeoutMs, priority, replySelector, new SessionKey(), new HashSet());
    }

    public SendGarlicJob(RouterContext ctx, GarlicConfig config, Job onSend, Job onSendFailed, ReplyJob onReply, Job onReplyFailed, long timeoutMs, int priority, MessageSelector replySelector, SessionKey wrappedKey, Set wrappedTags) {
        super(ctx);
        this._log = ctx.logManager().getLog(SendGarlicJob.class);
        if (config == null) {
            throw new IllegalArgumentException("No config specified");
        }
        if (config.getRecipient() == null) {
            throw new IllegalArgumentException("No recipient in the config");
        }
        this._config = config;
        this._onSend = onSend;
        this._onSendFailed = onSendFailed;
        this._onReply = onReply;
        this._onReplyFailed = onReplyFailed;
        this._timeoutMs = timeoutMs;
        this._priority = priority;
        this._replySelector = replySelector;
        this._message = null;
        this._wrappedKey = wrappedKey;
        this._wrappedTags = wrappedTags;
    }

    public String getName() {
        return "Build Garlic Message";
    }

    public void runJob() {
        long before = this.getContext().clock().now();
        this._message = GarlicMessageBuilder.buildMessage(this.getContext(), this._config, this._wrappedKey, this._wrappedTags);
        long after = this.getContext().clock().now();
        if (after - before > 1000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Building the garlic took too long [" + (after - before) + " ms]", (Throwable)this.getAddedBy());
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Building the garlic was fast! " + (after - before) + " ms");
        }
        this.getContext().jobQueue().addJob(new SendJob(this.getContext()));
    }

    private void sendGarlic() {
        OutNetMessage msg = new OutNetMessage(this.getContext());
        long when = this._message.getMessageExpiration();
        msg.setExpiration(when);
        msg.setMessage(this._message);
        msg.setOnFailedReplyJob(this._onReplyFailed);
        msg.setOnFailedSendJob(this._onSendFailed);
        msg.setOnReplyJob(this._onReply);
        msg.setOnSendJob(this._onSend);
        msg.setPriority(this._priority);
        msg.setReplySelector(this._replySelector);
        msg.setTarget(this._config.getRecipient());
        this.getContext().outNetMessagePool().add(msg);
        this._log.debug("Garlic message added to outbound network message pool");
    }

    private class SendJob
    extends JobImpl {
        public SendJob(RouterContext enclosingContext) {
            super(enclosingContext);
        }

        public String getName() {
            return "Send Built Garlic Message";
        }

        public void runJob() {
            if (SendGarlicJob.this._config.getRecipient() != null) {
                SendGarlicJob.this._log.info("sending garlic to recipient " + SendGarlicJob.this._config.getRecipient().getIdentity().getHash().toBase64());
            } else {
                SendGarlicJob.this._log.info("sending garlic to public key " + SendGarlicJob.this._config.getRecipientPublicKey());
            }
            SendGarlicJob.this.sendGarlic();
        }
    }
}

