/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterIdentity;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.message.SendMessageDirectJob;
import net.i2p.util.Log;

public class HandleDatabaseLookupMessageJob
extends JobImpl {
    private Log _log = this.getContext().logManager().getLog(HandleDatabaseLookupMessageJob.class);
    private DatabaseLookupMessage _message;
    private RouterIdentity _from;
    private Hash _fromHash;
    private static final int MAX_ROUTERS_RETURNED = 3;
    private static final int CLOSENESS_THRESHOLD = 10;
    private static final int REPLY_TIMEOUT = 60000;
    private static final int MESSAGE_PRIORITY = 300;
    public static final long EXPIRE_DELAY = 3600000L;
    public static final String PROP_PUBLISH_UNREACHABLE = "router.publishUnreachableRouters";
    public static final boolean DEFAULT_PUBLISH_UNREACHABLE = true;

    public HandleDatabaseLookupMessageJob(RouterContext ctx, DatabaseLookupMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        super(ctx);
        this.getContext().statManager().createRateStat("netDb.lookupsHandled", "How many netDb lookups have we handled?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatched", "How many netDb lookups did we have the data for?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatchedLeaseSet", "How many netDb leaseSet lookups did we have the data for?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatchedReceivedPublished", "How many netDb lookups did we have the data for that were published to us?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatchedLocalClosest", "How many netDb lookups for local data were received where we are the closest peers?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatchedLocalNotClosest", "How many netDb lookups for local data were received where we are NOT the closest peers?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this.getContext().statManager().createRateStat("netDb.lookupsMatchedRemoteNotClosest", "How many netDb lookups for remote data were received where we are NOT the closest peers?", "NetworkDatabase", new long[]{300000L, 3600000L, 86400000L});
        this._message = receivedMessage;
        this._from = from;
        this._fromHash = fromHash;
    }

    protected boolean answerAllQueries() {
        return false;
    }

    public void runJob() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling database lookup message for " + this._message.getSearchKey());
        }
        Hash fromKey = this._message.getFrom();
        if (this._log.shouldLog(10) && this._message.getReplyTunnel() != null) {
            this._log.debug("dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
        }
        if (this.getContext().router().isHidden()) {
            if (this._log.shouldLog(40)) {
                this._log.error("Uninvited dbLookup received with replies going to " + fromKey + " (tunnel " + this._message.getReplyTunnel() + ")");
            }
            return;
        }
        LeaseSet ls = this.getContext().netDb().lookupLeaseSetLocally(this._message.getSearchKey());
        if (ls != null) {
            boolean publish = this.getContext().clientManager().shouldPublishLeaseSet(this._message.getSearchKey());
            if (publish && (this.answerAllQueries() || ls.getReceivedAsPublished())) {
                this.getContext().statManager().addRateData("netDb.lookupsMatchedReceivedPublished", 1L, 0L);
                this.sendData(this._message.getSearchKey(), (DataStructure)ls, fromKey, this._message.getReplyTunnel());
            } else {
                Set routerInfoSet = this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 10, this._message.getDontIncludePeers());
                if (this.getContext().clientManager().isLocal(ls.getDestination())) {
                    if (publish && this.weAreClosest(routerInfoSet)) {
                        this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalClosest", 1L, 0L);
                        this.sendData(this._message.getSearchKey(), (DataStructure)ls, fromKey, this._message.getReplyTunnel());
                    } else {
                        this.getContext().statManager().addRateData("netDb.lookupsMatchedLocalNotClosest", 1L, 0L);
                        this.sendClosest(this._message.getSearchKey(), routerInfoSet, fromKey, this._message.getReplyTunnel());
                    }
                } else {
                    this.getContext().statManager().addRateData("netDb.lookupsMatchedRemoteNotClosest", 1L, 0L);
                    this.sendClosest(this._message.getSearchKey(), routerInfoSet, fromKey, this._message.getReplyTunnel());
                }
            }
        } else {
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._message.getSearchKey());
            if (info != null && info.isCurrent(3600000L)) {
                if (info.getIdentity().isHidden() || this.isUnreachable(info) && !this.publishUnreachable()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Not answering a query for a netDb peer who isn't reachable");
                    }
                    HashSet<RouterInfo> us = new HashSet<RouterInfo>(1);
                    us.add(this.getContext().router().getRouterInfo());
                    this.sendClosest(this._message.getSearchKey(), us, fromKey, this._message.getReplyTunnel());
                } else {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("We do have key " + this._message.getSearchKey().toBase64() + " locally as a router info.  sending to " + fromKey.toBase64());
                    }
                    this.sendData(this._message.getSearchKey(), (DataStructure)info, fromKey, this._message.getReplyTunnel());
                }
            } else {
                Set routerInfoSet = this.getContext().netDb().findNearestRouters(this._message.getSearchKey(), 3, this._message.getDontIncludePeers());
                if (this._log.shouldLog(10)) {
                    this._log.debug("We do not have key " + this._message.getSearchKey().toBase64() + " locally.  sending back " + routerInfoSet.size() + " peers to " + fromKey.toBase64());
                }
                this.sendClosest(this._message.getSearchKey(), routerInfoSet, fromKey, this._message.getReplyTunnel());
            }
        }
    }

    private boolean isUnreachable(RouterInfo info) {
        if (info == null) {
            return true;
        }
        String cap = info.getCapabilities();
        if (cap == null) {
            return false;
        }
        return cap.indexOf(82) >= 0;
    }

    private boolean publishUnreachable() {
        String publish = this.getContext().getProperty(PROP_PUBLISH_UNREACHABLE);
        if (publish != null) {
            return Boolean.valueOf(publish);
        }
        return true;
    }

    private boolean weAreClosest(Set routerInfoSet) {
        boolean weAreClosest = false;
        for (RouterInfo cur : routerInfoSet) {
            if (!cur.getIdentity().calculateHash().equals((Object)this.getContext().routerHash())) continue;
            return true;
        }
        return false;
    }

    private void sendData(Hash key, DataStructure data, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending data matching key key " + key.toBase64() + " to peer " + toPeer.toBase64() + " tunnel " + replyTunnel);
        }
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setKey(key);
        if (data instanceof LeaseSet) {
            msg.setLeaseSet((LeaseSet)data);
            msg.setValueType(1);
            this.getContext().statManager().addRateData("netDb.lookupsMatchedLeaseSet", 1L, 0L);
        } else if (data instanceof RouterInfo) {
            msg.setRouterInfo((RouterInfo)data);
            msg.setValueType(0);
        }
        this.getContext().statManager().addRateData("netDb.lookupsMatched", 1L, 0L);
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L, 0L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendClosest(Hash key, Set routerInfoSet, Hash toPeer, TunnelId replyTunnel) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending closest routers to key " + key.toBase64() + ": # peers = " + routerInfoSet.size() + " tunnel " + replyTunnel);
        }
        DatabaseSearchReplyMessage msg = new DatabaseSearchReplyMessage(this.getContext());
        msg.setFromHash(this.getContext().routerHash());
        msg.setSearchKey(key);
        for (RouterInfo peer : routerInfoSet) {
            msg.addReply(peer.getIdentity().getHash());
            if (msg.getNumReplies() < 3) continue;
            break;
        }
        this.getContext().statManager().addRateData("netDb.lookupsHandled", 1L, 0L);
        this.sendMessage(msg, toPeer, replyTunnel);
    }

    protected void sendMessage(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (replyTunnel != null) {
            this.sendThroughTunnel(message, toPeer, replyTunnel);
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug("Sending reply directly to " + toPeer);
            }
            SendMessageDirectJob send = new SendMessageDirectJob(this.getContext(), message, toPeer, 60000, 300);
            send.runJob();
        }
    }

    private void sendThroughTunnel(I2NPMessage message, Hash toPeer, TunnelId replyTunnel) {
        if (this.getContext().routerHash().equals((Object)toPeer)) {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setTunnelId(replyTunnel);
            m.setMessageExpiration(message.getMessageExpiration());
            this.getContext().tunnelDispatcher().dispatch(m);
        } else {
            TunnelGatewayMessage m = new TunnelGatewayMessage(this.getContext());
            m.setMessage(message);
            m.setMessageExpiration(message.getMessageExpiration());
            m.setTunnelId(replyTunnel);
            SendMessageDirectJob j = new SendMessageDirectJob(this.getContext(), m, toPeer, 10000, 100);
            j.runJob();
        }
    }

    public String getName() {
        return "Handle Database Lookup Message";
    }

    public void dropped() {
        this.getContext().messageHistory().messageProcessingError(this._message.getUniqueId(), this._message.getClass().getName(), "Dropped due to overload");
    }
}

