/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class DataRepublishingSelectorJob
extends JobImpl {
    private Log _log;
    private KademliaNetworkDatabaseFacade _facade;
    private static final long RERUN_DELAY_MS = 60000L;
    public static final int MAX_PASSIVE_POOL_SIZE = 10;
    public static final long RESEND_BUCKET_FACTOR = 300000L;
    private static final int LEASE_REBROADCAST_PROBABILITY = 5;
    private static final int LEASE_REBROADCAST_PROBABILITY_SCALE = 1000;

    public DataRepublishingSelectorJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade) {
        super(ctx);
        this._log = ctx.logManager().getLog(DataRepublishingSelectorJob.class);
        this._facade = facade;
        this.getTiming().setStartAfter(ctx.clock().now() + 60000L);
    }

    public String getName() {
        return "Data Publisher Job";
    }

    public void runJob() {
        Set toSend = this.selectKeysToSend();
        if (this._log.shouldLog(20)) {
            this._log.info("Keys being queued up for publishing: " + toSend);
        }
        this._facade.queueForPublishing(toSend);
        this.requeue(60000L);
    }

    private Set selectKeysToSend() {
        HashSet alreadyQueued = new HashSet(128);
        alreadyQueued.addAll(this._facade.getPassivelySendKeys());
        int toAdd = 10 - alreadyQueued.size();
        if (this._log.shouldLog(10)) {
            this._log.debug("Keys we need to queue up to fill the passive send pool: " + toAdd);
        }
        if (toAdd <= 0) {
            return new HashSet();
        }
        alreadyQueued.addAll(this._facade.getExplicitSendKeys());
        Set keys = this._facade.getDataStore().getKeys();
        keys.removeAll(alreadyQueued);
        if (this._log.shouldLog(10)) {
            this._log.debug("Total number of keys in the datastore: " + keys.size());
        }
        TreeMap<Long, Hash> toSend = new TreeMap<Long, Hash>();
        for (Hash key : keys) {
            Long lastPublished = this._facade.getLastSent(key);
            long publishRank = this.rankPublishNeed(key, lastPublished);
            if (this._log.shouldLog(10)) {
                this._log.debug("Publish rank for " + key + ": " + publishRank);
            }
            if (publishRank <= 0L) continue;
            while (toSend.containsKey(new Long(publishRank))) {
                ++publishRank;
            }
            toSend.put(new Long(publishRank), key);
        }
        HashSet<Hash> rv = new HashSet<Hash>(toAdd);
        Iterator iter = toSend.values().iterator();
        while (iter.hasNext() && rv.size() <= toAdd) {
            Hash key = (Hash)iter.next();
            rv.add(key);
        }
        return rv;
    }

    private long rankPublishNeed(Hash key, Long lastPublished) {
        int val;
        int bucket = this._facade.getKBuckets().pickBucket(key);
        long sendPeriod = (long)(bucket + 1) * 300000L;
        long now = this.getContext().clock().now();
        if (lastPublished < now - sendPeriod) {
            RouterInfo ri = this._facade.lookupRouterInfoLocally(key);
            if (ri != null) {
                if (ri.isCurrent(0x6DDD00L)) {
                    return 32 - bucket;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Not republishing router " + key + " since it is really old [" + (now - ri.getPublished()) + "ms]");
                }
                return -2L;
            }
            LeaseSet ls = this._facade.lookupLeaseSetLocally(key);
            if (ls != null) {
                if (!this.getContext().clientManager().shouldPublishLeaseSet(ls.getDestination().calculateHash())) {
                    return -3L;
                }
                if (ls.isCurrent(60000L)) {
                    return 32 - bucket;
                }
                if (this._log.shouldLog(20)) {
                    this._log.info("Not republishing leaseSet " + key + " since it is really old [" + (now - ls.getEarliestLeaseDate()) + "ms]");
                }
                return -3L;
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("Key " + key + " is not a leaseSet or routerInfo, definitely not publishing it");
            }
            return -5L;
        }
        if (now - 300000L > lastPublished && this._facade.lookupRouterInfoLocally(key) != null && (val = this.getContext().random().nextInt(1000)) <= 5) {
            if (this._log.shouldLog(20)) {
                this._log.info("Randomized rebroadcast of leases tells us to send " + key + ": " + val);
            }
            return 1L;
        }
        return -1L;
    }
}

