/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.networkdb.kademlia.KBucket;
import net.i2p.router.networkdb.kademlia.SelectionCollector;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

class KBucketImpl
implements KBucket {
    private Log _log;
    private List _entries;
    private Hash _local;
    private int _begin;
    private int _end;
    private I2PAppContext _context;

    public KBucketImpl(I2PAppContext context, Hash local) {
        this._context = context;
        this._log = context.logManager().getLog(KBucketImpl.class);
        this._entries = new ArrayList(64);
        this.setLocal(local);
    }

    public int getRangeBegin() {
        return this._begin;
    }

    public int getRangeEnd() {
        return this._end;
    }

    public void setRange(int lowOrderBitLimit, int highOrderBitLimit) {
        this._begin = lowOrderBitLimit;
        this._end = highOrderBitLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeyCount() {
        List list = this._entries;
        synchronized (list) {
            return this._entries.size();
        }
    }

    public Hash getLocal() {
        return this._local;
    }

    private void setLocal(Hash local) {
        this._local = local;
        this._local.prepareCache();
        if (this._log.shouldLog(10)) {
            this._log.debug("Local hash reset to " + DataHelper.toHexString((byte[])local.getData()));
        }
    }

    private byte[] distanceFromLocal(Hash key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key for distanceFromLocal?");
        }
        return this._local.cachedXor(key);
    }

    public boolean shouldContain(Hash key) {
        byte[] distance = this.distanceFromLocal(key);
        boolean tooLarge = this.distanceIsTooLarge(distance);
        if (tooLarge) {
            return false;
        }
        boolean tooSmall = this.distanceIsTooSmall(distance);
        if (tooSmall) {
            if (this._log.shouldLog(10)) {
                this._log.debug("too small [" + this._begin + "-->" + this._end + "] distance: " + DataHelper.toHexString((byte[])distance));
            }
            return false;
        }
        return true;
    }

    private final boolean distanceIsTooLarge(byte[] distance) {
        int upperLimitByte;
        int upperLimitBit = 256 - this._end;
        int n = upperLimitByte = upperLimitBit > 0 ? upperLimitBit / 8 : 0;
        if (upperLimitBit <= 0) {
            return false;
        }
        for (int i = 0; i < distance.length; ++i) {
            if (i < upperLimitByte) {
                if (distance[i] == 0) continue;
                return true;
            }
            if (i == upperLimitByte) {
                if (distance[i] == 0) {
                    return false;
                }
                int upperVal = 1 << upperLimitBit % 8;
                if (distance[i] > upperVal) {
                    return true;
                }
                if (distance[i] != upperVal) continue;
                for (int j = i + 1; j < distance.length; ++j) {
                    if (distance[j] == 0) continue;
                    return true;
                }
                return false;
            }
            if (i <= upperLimitByte) continue;
            return false;
        }
        this._log.log(50, "wtf, gravity broke: distance=" + DataHelper.toHexString((byte[])distance) + ", end=" + this._end, (Throwable)new Exception("moo"));
        return true;
    }

    private final boolean distanceIsTooSmall(byte[] distance) {
        int beginByte;
        int beginBit = 256 - this._begin;
        int n = beginByte = beginBit > 0 ? beginBit / 8 : 0;
        if (beginByte >= distance.length) {
            return this._begin != 0;
        }
        for (int i = 0; i < distance.length; ++i) {
            if (i < beginByte && distance[i] != 0) {
                return false;
            }
            if (i != beginByte) continue;
            int beginVal = 1 << this._begin % 8;
            return distance[i] < beginVal;
        }
        this._log.log(50, "wtf, gravity broke!  distance=" + DataHelper.toHexString((byte[])distance) + " begin=" + this._begin + " beginBit=" + beginBit + " beginByte=" + beginByte, (Throwable)new Exception("moo"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getEntries() {
        HashSet<Hash> entries = new HashSet<Hash>(64);
        List list = this._entries;
        synchronized (list) {
            for (int i = 0; i < this._entries.size(); ++i) {
                entries.add((Hash)this._entries.get(i));
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getEntries(Set toIgnoreHashes) {
        HashSet<Hash> entries = new HashSet<Hash>(64);
        List list = this._entries;
        synchronized (list) {
            for (int i = 0; i < this._entries.size(); ++i) {
                entries.add((Hash)this._entries.get(i));
            }
            entries.removeAll(toIgnoreHashes);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntries(SelectionCollector collector) {
        List list = this._entries;
        synchronized (list) {
            for (int i = 0; i < this._entries.size(); ++i) {
                collector.add((Hash)this._entries.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntries(Set entries) {
        List list = this._entries;
        synchronized (list) {
            this._entries.clear();
            for (Hash entry : entries) {
                if (this._entries.contains(entry)) continue;
                this._entries.add(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(Hash peer) {
        List list = this._entries;
        synchronized (list) {
            if (!this._entries.contains(peer)) {
                this._entries.add(peer);
            }
            return this._entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Hash peer) {
        List list = this._entries;
        synchronized (list) {
            return this._entries.remove(peer);
        }
    }

    public Hash generateRandomKey() {
        BigInteger variance = new BigInteger(this._end - this._begin - 1, (Random)this._context.random());
        variance = variance.setBit(this._begin);
        byte[] data = variance.toByteArray();
        byte[] hash = new byte[32];
        if (data.length <= 32) {
            System.arraycopy(data, 0, hash, hash.length - data.length, data.length);
        } else {
            System.arraycopy(data, data.length - hash.length, hash, 0, hash.length);
        }
        Hash key = new Hash(hash);
        data = this.distanceFromLocal(key);
        hash = new byte[32];
        if (data.length <= 32) {
            System.arraycopy(data, 0, hash, hash.length - data.length, data.length);
        } else {
            System.arraycopy(data, data.length - hash.length, hash, 0, hash.length);
        }
        key = new Hash(hash);
        return key;
    }

    public Hash getRangeBeginKey() {
        BigInteger lowerBounds = this.getLowerBounds();
        if (this._local != null && this._local.getData() != null) {
            lowerBounds = lowerBounds.xor(new BigInteger(1, this._local.getData()));
        }
        byte[] data = lowerBounds.toByteArray();
        byte[] hash = new byte[32];
        if (data.length <= 32) {
            System.arraycopy(data, 0, hash, hash.length - data.length, data.length);
        } else {
            System.arraycopy(data, data.length - hash.length, hash, 0, hash.length);
        }
        Hash key = new Hash(hash);
        return key;
    }

    public Hash getRangeEndKey() {
        BigInteger upperBounds = this.getUpperBounds();
        if (this._local != null && this._local.getData() != null) {
            upperBounds = upperBounds.xor(new BigInteger(1, this._local.getData()));
        }
        byte[] data = upperBounds.toByteArray();
        byte[] hash = new byte[32];
        if (data.length <= 32) {
            System.arraycopy(data, 0, hash, hash.length - data.length, data.length);
        } else {
            System.arraycopy(data, data.length - hash.length, hash, 0, hash.length);
        }
        Hash key = new Hash(hash);
        return key;
    }

    private BigInteger getUpperBounds() {
        return BigInteger.ZERO.setBit(this._end);
    }

    private BigInteger getLowerBounds() {
        if (this._begin == 0) {
            return BigInteger.ZERO;
        }
        return BigInteger.ZERO.setBit(this._begin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("KBucketImpl: ");
        List list = this._entries;
        synchronized (list) {
            buf.append(this._entries.toString()).append("\n");
        }
        buf.append("Low bit: ").append(this._begin).append(" high bit: ").append(this._end).append('\n');
        buf.append("Local key: \n");
        if (this._local != null && this._local.getData() != null) {
            buf.append(KBucketImpl.toString(this._local.getData())).append('\n');
        } else {
            buf.append("[undefined]\n");
        }
        buf.append("Low and high keys:\n");
        buf.append(KBucketImpl.toString(this.getRangeBeginKey().getData())).append('\n');
        buf.append(KBucketImpl.toString(this.getRangeEndKey().getData())).append('\n');
        buf.append("Low and high deltas:\n");
        buf.append(this.getLowerBounds().toString(2)).append('\n');
        buf.append(this.getUpperBounds().toString(2)).append('\n');
        return buf.toString();
    }

    public static void main(String[] args) {
        KBucketImpl.testRand2();
        KBucketImpl.testRand();
        KBucketImpl.testLimits();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void testLimits() {
        int low = 1;
        int high = 3;
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(KBucketImpl.class);
        KBucketImpl bucket = new KBucketImpl(I2PAppContext.getGlobalContext(), Hash.FAKE_HASH);
        bucket.setRange(low, high);
        Hash lowerBoundKey = bucket.getRangeBeginKey();
        Hash upperBoundKey = bucket.getRangeEndKey();
        boolean okLow = bucket.shouldContain(lowerBoundKey);
        boolean okHigh = bucket.shouldContain(upperBoundKey);
        if (okLow && okHigh) {
            log.debug("Limit test ok");
        } else {
            log.error("Limit test failed!  ok low? " + okLow + " ok high? " + okHigh);
        }
    }

    private static void testRand() {
        StringBuffer buf = new StringBuffer(2048);
        int low = 1;
        int high = 3;
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(KBucketImpl.class);
        Hash local = Hash.FAKE_HASH;
        local.prepareCache();
        KBucketImpl bucket = new KBucketImpl(I2PAppContext.getGlobalContext(), local);
        bucket.setRange(low, high);
        Hash lowerBoundKey = bucket.getRangeBeginKey();
        Hash upperBoundKey = bucket.getRangeEndKey();
        for (int i = 0; i < 100000; ++i) {
            Hash rnd = bucket.generateRandomKey();
            boolean ok = bucket.shouldContain(rnd);
            if (ok) continue;
            byte[] diff = bucket.getLocal().cachedXor(rnd);
            BigInteger dv = new BigInteger(1, diff);
            log.error("wtf, bucket doesnt want a key that it generated.  i == " + i);
            log.error("\nLow: " + DataHelper.toHexString((byte[])bucket.getRangeBeginKey().getData()) + "\nVal: " + DataHelper.toHexString((byte[])rnd.getData()) + "\nHigh:" + DataHelper.toHexString((byte[])bucket.getRangeEndKey().getData()));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.exit(0);
        }
        log.info("Passed 100,000 random key generations against the null hash");
    }

    private static void testRand2() {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(KBucketImpl.class);
        StringBuffer buf = new StringBuffer(0x1000000);
        int low = 1;
        int high = 200;
        byte[] hash = new byte[32];
        RandomSource.getInstance().nextBytes(hash);
        Hash local = new Hash(hash);
        local.prepareCache();
        KBucketImpl bucket = new KBucketImpl(I2PAppContext.getGlobalContext(), local);
        bucket.setRange(low, high);
        Hash lowerBoundKey = bucket.getRangeBeginKey();
        Hash upperBoundKey = bucket.getRangeEndKey();
        for (int i = 0; i < 100000; ++i) {
            Hash rnd = bucket.generateRandomKey();
            boolean ok = bucket.shouldContain(rnd);
            if (ok) continue;
            byte[] diff = bucket.getLocal().cachedXor(rnd);
            BigInteger dv = new BigInteger(1, diff);
            log.error("wtf, bucket doesnt want a key that it generated.  i == " + i);
            log.error("\nLow: " + DataHelper.toHexString((byte[])bucket.getRangeBeginKey().getData()) + "\nVal: " + DataHelper.toHexString((byte[])rnd.getData()) + "\nHigh:" + DataHelper.toHexString((byte[])bucket.getRangeEndKey().getData()));
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.exit(0);
        }
        log.info("Passed 100,000 random key generations against a random hash\n" + buf.toString());
    }

    private static final String toString(byte[] b) {
        return DataHelper.toHexString((byte[])b);
    }

    private static final String toString(byte b) {
        StringBuffer buf = new StringBuffer(8);
        for (int i = 7; i >= 0; --i) {
            boolean bb;
            boolean bl = bb = 0 != (b & 1 << i);
            if (bb) {
                buf.append("1");
                continue;
            }
            buf.append("0");
        }
        return buf.toString();
    }
}

