/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructure;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.util.Log;

class TransientDataStore
implements DataStore {
    private Log _log;
    private Map _data;
    protected RouterContext _context;
    private static final long MAX_FUTURE_PUBLISH_DATE = 300000L;
    private static final long MAX_FUTURE_EXPIRATION_DATE = 1200000L;

    public TransientDataStore(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TransientDataStore.class);
        this._data = new HashMap(1024);
        if (this._log.shouldLog(20)) {
            this._log.info("Data Store initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Map map = this._data;
        synchronized (map) {
            this._data.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getKeys() {
        Map map = this._data;
        synchronized (map) {
            return new HashSet(this._data.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStructure get(Hash key) {
        Map map = this._data;
        synchronized (map) {
            return (DataStructure)this._data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isKnown(Hash key) {
        Map map = this._data;
        synchronized (map) {
            return this._data.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countLeaseSets() {
        int count = 0;
        Map map = this._data;
        synchronized (map) {
            for (DataStructure data : this._data.values()) {
                if (!(data instanceof LeaseSet)) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Hash key, DataStructure data) {
        if (data == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Storing key " + key);
        }
        DataStructure old = null;
        Map map = this._data;
        synchronized (map) {
            old = this._data.put(key, data);
        }
        if (data instanceof RouterInfo) {
            this._context.profileManager().heardAbout(key);
            RouterInfo ri = (RouterInfo)data;
            if (old != null) {
                RouterInfo ori = (RouterInfo)old;
                if (ri.getPublished() < ori.getPublished()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old router! " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                    Map map2 = this._data;
                    synchronized (map2) {
                        this._data.put(key, old);
                    }
                } else if (ri.getPublished() > this._context.clock().now() + 300000L) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Hmm, someone tried to give us something with the publication date really far in the future (" + new Date(ri.getPublished()) + "), dropping it");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                    Map map3 = this._data;
                    synchronized (map3) {
                        this._data.put(key, old);
                    }
                } else {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Updated the old router for " + key + ": [old published on " + new Date(ori.getPublished()) + " new on " + new Date(ri.getPublished()) + "]");
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size() + " (old one had: " + ori.getOptions().size() + ")", (Throwable)new Exception("Updated routerInfo"));
                    }
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Brand new router for " + key + ": published on " + new Date(ri.getPublished()));
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("Number of router options for " + key + ": " + ri.getOptions().size(), (Throwable)new Exception("Updated routerInfo"));
                }
            }
        } else if (data instanceof LeaseSet) {
            LeaseSet ls = (LeaseSet)data;
            if (old != null) {
                LeaseSet ols = (LeaseSet)old;
                if (ls.getEarliestLeaseDate() < ols.getEarliestLeaseDate()) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Almost clobbered an old leaseSet! " + key + ": [old published on " + new Date(ols.getEarliestLeaseDate()) + " new on " + new Date(ls.getEarliestLeaseDate()) + "]");
                    }
                    Map map4 = this._data;
                    synchronized (map4) {
                        this._data.put(key, old);
                    }
                }
                if (ls.getEarliestLeaseDate() > this._context.clock().now() + 1200000L) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Hmm, someone tried to give us something with the expiration date really far in the future (" + new Date(ls.getEarliestLeaseDate()) + "), dropping it");
                    }
                    Map map5 = this._data;
                    synchronized (map5) {
                        this._data.put(key, old);
                    }
                }
            }
        }
    }

    public int hashCode() {
        return DataHelper.hashCode((Object)this._data);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TransientDataStore ds = (TransientDataStore)obj;
        return DataHelper.eq((Object)ds._data, (Object)this._data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Transient DataStore: ").append(this._data.size()).append("\nKeys: ");
        HashMap data = new HashMap();
        Map map = this._data;
        synchronized (map) {
            data.putAll(this._data);
        }
        for (Hash key : data.keySet()) {
            DataStructure dp = (DataStructure)data.get(key);
            buf.append("\n\t*Key:   ").append(key.toString()).append("\n\tContent: ").append(dp.toString());
        }
        buf.append("\n");
        return buf.toString();
    }

    public DataStructure removeLease(Hash key) {
        return this.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStructure remove(Hash key) {
        Map map = this._data;
        synchronized (map) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Removing key " + key.toBase64());
            }
            return (DataStructure)this._data.remove(key);
        }
    }
}

