/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

class PeerManager {
    private Log _log;
    private RouterContext _context;
    private ProfileOrganizer _organizer;
    private ProfilePersistenceHelper _persistenceHelper;
    private List[] _peersByCapability;
    private Map _capabilitiesByPeer;

    public PeerManager(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(PeerManager.class);
        this._persistenceHelper = new ProfilePersistenceHelper(context);
        this._organizer = context.profileOrganizer();
        this._organizer.setUs(context.routerHash());
        this._capabilitiesByPeer = new HashMap(128);
        this._peersByCapability = new List[26];
        for (int i = 0; i < this._peersByCapability.length; ++i) {
            this._peersByCapability[i] = new ArrayList(64);
        }
        this.loadProfiles();
        SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)new Reorg(), 0L);
    }

    void storeProfiles() {
        Set peers = this.selectPeers();
        for (Hash peer : peers) {
            this.storeProfile(peer);
        }
    }

    Set selectPeers() {
        return this._organizer.selectAllPeers();
    }

    void storeProfile(Hash peer) {
        if (peer == null) {
            return;
        }
        PeerProfile prof = this._organizer.getProfile(peer);
        if (prof == null) {
            return;
        }
        this._persistenceHelper.writeProfile(prof);
    }

    void loadProfiles() {
        Set profiles = this._persistenceHelper.readProfiles();
        for (PeerProfile prof : profiles) {
            if (prof == null) continue;
            this._organizer.addProfile(prof);
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Profile for " + prof.getPeer().toBase64() + " loaded");
        }
    }

    List selectPeers(PeerSelectionCriteria criteria) {
        HashSet peers = new HashSet(criteria.getMinimumRequired());
        HashSet<Hash> exclude = new HashSet<Hash>(1);
        exclude.add(this._context.routerHash());
        switch (criteria.getPurpose()) {
            case 4: {
                this._organizer.selectNotFailingPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 1: {
                this._organizer.selectFastPeers(criteria.getMaximumRequired(), exclude, peers);
                break;
            }
            case 3: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
            case 2: {
                this._organizer.selectHighCapacityPeers(criteria.getMinimumRequired(), exclude, peers);
                break;
            }
        }
        if (peers.size() <= 0 && this._log.shouldLog(30)) {
            this._log.warn("We ran out of peers when looking for reachable ones after finding " + peers.size() + " with " + this._organizer.countWellIntegratedPeers() + "/" + this._organizer.countHighCapacityPeers() + "/" + this._organizer.countFastPeers() + " integrated/high capacity/fast peers");
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Peers selected: " + peers);
        }
        return new ArrayList(peers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapabilities(Hash peer, String caps) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Setting capabilities for " + peer.toBase64() + " to " + caps);
        }
        if (caps != null) {
            caps = caps.toLowerCase();
        }
        Map map = this._capabilitiesByPeer;
        synchronized (map) {
            List peers;
            char c;
            int i;
            String oldCaps = null;
            oldCaps = caps != null ? this._capabilitiesByPeer.put(peer, caps) : (String)this._capabilitiesByPeer.remove(peer);
            if (oldCaps != null) {
                for (i = 0; i < oldCaps.length(); ++i) {
                    c = oldCaps.charAt(i);
                    if (caps != null && caps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null) continue;
                    peers.remove(peer);
                }
            }
            if (caps != null) {
                for (i = 0; i < caps.length(); ++i) {
                    c = caps.charAt(i);
                    if (oldCaps != null && oldCaps.indexOf(c) >= 0 || (peers = this.locked_getPeers(c)) == null || peers.contains(peer)) continue;
                    peers.add(peer);
                }
            }
        }
    }

    private List locked_getPeers(char c) {
        int i = (c = Character.toLowerCase(c)) - 97;
        if (i < 0 || i >= this._peersByCapability.length) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Invalid capability " + c + " (" + i + ")");
            }
            return null;
        }
        return this._peersByCapability[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCapabilities(Hash peer) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing capabilities from " + peer.toBase64());
        }
        Map map = this._capabilitiesByPeer;
        synchronized (map) {
            String oldCaps = (String)this._capabilitiesByPeer.remove(peer);
            if (oldCaps != null) {
                for (int i = 0; i < oldCaps.length(); ++i) {
                    char c = oldCaps.charAt(i);
                    List peers = this.locked_getPeers(c);
                    if (peers == null) continue;
                    peers.remove(peer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hash selectRandomByCapability(char capability) {
        int index = this._context.random().nextInt(Integer.MAX_VALUE);
        Map map = this._capabilitiesByPeer;
        synchronized (map) {
            List peers = this.locked_getPeers(capability);
            if (peers != null && peers.size() > 0) {
                return (Hash)peers.get(index %= peers.size());
            }
        }
        return null;
    }

    public List getPeersByCapability(char capability) {
        FloodfillNetworkDatabaseFacade f = (FloodfillNetworkDatabaseFacade)this._context.netDb();
        List routerInfos = f.getKnownRouterData();
        ArrayList<Hash> rv = new ArrayList<Hash>();
        for (RouterInfo ri : routerInfos) {
            String caps = ri.getCapabilities();
            if (caps.indexOf(capability) < 0) continue;
            rv.add(ri.getIdentity().calculateHash());
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Peers with capacity " + capability + ": " + rv.size());
        }
        return rv;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        this._organizer.renderStatusHTML(out);
    }

    private class Reorg
    implements SimpleTimer.TimedEvent {
        private Reorg() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            try {
                PeerManager.this._organizer.reorganize(true);
            }
            catch (Throwable t) {
                PeerManager.this._log.log(50, "Error evaluating profiles", t);
            }
            finally {
                SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)this, 30000L);
            }
        }
    }
}

