/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.router.PeerManagerFacade;
import net.i2p.router.PeerSelectionCriteria;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.PeerManager;
import net.i2p.router.peermanager.PeerTestJob;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.util.Log;

public class PeerManagerFacadeImpl
implements PeerManagerFacade {
    private Log _log;
    private PeerManager _manager;
    private RouterContext _context;
    private ProfilePersistenceHelper _persistenceHelper;
    private PeerTestJob _testJob;

    public PeerManagerFacadeImpl(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PeerManagerFacadeImpl.class);
        this._persistenceHelper = new ProfilePersistenceHelper(ctx);
        this._testJob = new PeerTestJob(this._context);
    }

    public void startup() {
        this._log.info("Starting up the peer manager");
        this._manager = new PeerManager(this._context);
        this._persistenceHelper.setUs(this._context.routerHash());
        this._testJob.startTesting(this._manager);
    }

    public void shutdown() {
        this._log.info("Shutting down the peer manager");
        this._testJob.stopTesting();
        this._manager.storeProfiles();
    }

    public void restart() {
        this._manager.storeProfiles();
        this._persistenceHelper.setUs(this._context.routerHash());
        this._manager.loadProfiles();
    }

    public List selectPeers(PeerSelectionCriteria criteria) {
        return this._manager.selectPeers(criteria);
    }

    public void setCapabilities(Hash peer, String caps) {
        if (this._manager == null) {
            return;
        }
        this._manager.setCapabilities(peer, caps);
    }

    public void removeCapabilities(Hash peer) {
        if (this._manager == null) {
            return;
        }
        this._manager.removeCapabilities(peer);
    }

    public Hash selectRandomByCapability(char capability) {
        if (this._manager == null) {
            return null;
        }
        return this._manager.selectRandomByCapability(capability);
    }

    public List getPeersByCapability(char capability) {
        if (this._manager == null) {
            return new ArrayList(0);
        }
        return this._manager.getPeersByCapability(capability);
    }

    public void renderStatusHTML(Writer out) throws IOException {
        this._manager.renderStatusHTML(out);
    }
}

