/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.CapacityCalculator;
import net.i2p.router.peermanager.InverseCapacityComparator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.ProfileOrganizerRenderer;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class ProfileOrganizer {
    private Log _log;
    private RouterContext _context;
    private Map _fastPeers;
    private Map _highCapacityPeers;
    private Map _wellIntegratedPeers;
    private Map _notFailingPeers;
    private List _notFailingPeersList;
    private Map _failingPeers;
    private Hash _us;
    private ProfilePersistenceHelper _persistenceHelper;
    private Set _strictCapacityOrder;
    private double _thresholdSpeedValue;
    private double _thresholdCapacityValue;
    private double _thresholdIntegrationValue;
    private InverseCapacityComparator _comp;
    public static final String PROP_MINIMUM_FAST_PEERS = "profileOrganizer.minFastPeers";
    public static final int DEFAULT_MINIMUM_FAST_PEERS = 8;
    public static final String PROP_MINIMUM_HIGH_CAPACITY_PEERS = "profileOrganizer.minHighCapacityPeers";
    public static final int DEFAULT_MINIMUM_HIGH_CAPACITY_PEERS = 10;
    private Object _reorganizeLock = new Object();
    private Random _random = new Random();
    private static final int MAX_BAD_REPLIES_PER_HOUR = 5;
    private static final int MIN_NOT_FAILING_ACTIVE = 3;
    private static final DecimalFormat _fmt = new DecimalFormat("###,##0.00", new DecimalFormatSymbols(Locale.UK));

    public ProfileOrganizer(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(ProfileOrganizer.class);
        this._comp = new InverseCapacityComparator();
        this._fastPeers = new HashMap(16);
        this._highCapacityPeers = new HashMap(16);
        this._wellIntegratedPeers = new HashMap(16);
        this._notFailingPeers = new HashMap(64);
        this._notFailingPeersList = new ArrayList(64);
        this._failingPeers = new HashMap(16);
        this._strictCapacityOrder = new TreeSet(this._comp);
        this._thresholdSpeedValue = 0.0;
        this._thresholdCapacityValue = 0.0;
        this._thresholdIntegrationValue = 0.0;
        this._persistenceHelper = new ProfilePersistenceHelper(this._context);
        this._context.statManager().createRateStat("peer.profileSortTime", "How long the reorg takes sorting peers", "Peers", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("peer.profileCoalesceTime", "How long the reorg takes coalescing peer stats", "Peers", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("peer.profileThresholdTime", "How long the reorg takes determining the tier thresholds", "Peers", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("peer.profilePlaceTime", "How long the reorg takes placing peers in the tiers", "Peers", new long[]{60000L, 600000L, 3600000L});
        this._context.statManager().createRateStat("peer.profileReorgTime", "How long the reorg takes overall", "Peers", new long[]{60000L, 600000L, 3600000L});
    }

    public void setUs(Hash us) {
        this._us = us;
    }

    Hash getUs() {
        return this._us;
    }

    public double getSpeedThreshold() {
        return this._thresholdSpeedValue;
    }

    public double getCapacityThreshold() {
        return this._thresholdCapacityValue;
    }

    public double getIntegrationThreshold() {
        return this._thresholdIntegrationValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerProfile getProfile(Hash peer) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this.locked_getProfile(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerProfile addProfile(PeerProfile profile) throws IllegalStateException {
        if (profile == null || profile.getPeer() == null) {
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("New profile created for " + profile.getPeer().toBase64());
        }
        Object object = this._reorganizeLock;
        synchronized (object) {
            PeerProfile old = this.locked_getProfile(profile.getPeer());
            profile.coalesceStats();
            this.locked_placeProfile(profile);
            this._strictCapacityOrder.add(profile);
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countFastPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._fastPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countHighCapacityPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._highCapacityPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countWellIntegratedPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._wellIntegratedPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countNotFailingPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._notFailingPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countFailingPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._failingPeers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countActivePeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            int activePeers = 0;
            long hideBefore = this._context.clock().now() - 21600000L;
            for (PeerProfile profile : this._failingPeers.values()) {
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
            for (PeerProfile profile : this._notFailingPeers.values()) {
                if (profile.getLastSendSuccessful() >= hideBefore) {
                    ++activePeers;
                    continue;
                }
                if (profile.getLastHeardFrom() < hideBefore) continue;
                ++activePeers;
            }
            return activePeers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFast(Hash peer) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._fastPeers.containsKey(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHighCapacity(Hash peer) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._highCapacityPeers.containsKey(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWellIntegrated(Hash peer) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._wellIntegratedPeers.containsKey(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailing(Hash peer) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            return this._failingPeers.containsKey(peer);
        }
    }

    public boolean peerSendsBadReplies(Hash peer) {
        RateStat invalidReplyRateStat;
        Rate invalidReplyRate;
        PeerProfile profile = this.getProfile(peer);
        return profile != null && ((invalidReplyRate = (invalidReplyRateStat = profile.getDBHistory().getInvalidReplyRate()).getRate(1800000L)).getCurrentTotalValue() > 5.0 || invalidReplyRate.getLastTotalValue() > 5.0);
    }

    public void exportProfile(Hash profile, OutputStream out) throws IOException {
        PeerProfile prof = this.getProfile(profile);
        if (prof != null) {
            this._persistenceHelper.writeProfile(prof, out);
        }
    }

    public void renderStatusHTML(Writer out) throws IOException {
        ProfileOrganizerRenderer rend = new ProfileOrganizerRenderer(this, this._context);
        rend.renderStatusHTML(out);
    }

    public void selectFastPeers(int howMany, Set exclude, Set matches) {
        this.selectFastPeers(howMany, exclude, matches, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFastPeers(int howMany, Set exclude, Set matches, int mask) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            this.locked_selectPeers(this._fastPeers, howMany, exclude, matches, mask);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectFastPeers(" + howMany + "), not enough fast (" + matches.size() + ") going on to highCap");
            }
            this.selectHighCapacityPeers(howMany, exclude, matches, mask);
        } else if (this._log.shouldLog(20)) {
            this._log.info("selectFastPeers(" + howMany + "), found enough fast (" + matches.size() + ")");
        }
    }

    public void selectHighCapacityPeers(int howMany, Set exclude, Set matches) {
        this.selectHighCapacityPeers(howMany, exclude, matches, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectHighCapacityPeers(int howMany, Set exclude, Set matches, int mask) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            this.locked_selectPeers(this._highCapacityPeers, howMany, exclude, matches, mask);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectHighCap(" + howMany + "), not enough fast (" + matches.size() + ") going on to notFailing");
            }
            this.selectNotFailingPeers(howMany, exclude, matches, mask);
        } else if (this._log.shouldLog(20)) {
            this._log.info("selectHighCap(" + howMany + "), found enough highCap (" + matches.size() + ")");
        }
    }

    public void selectWellIntegratedPeers(int howMany, Set exclude, Set matches) {
        this.selectWellIntegratedPeers(howMany, exclude, matches, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectWellIntegratedPeers(int howMany, Set exclude, Set matches, int mask) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            this.locked_selectPeers(this._wellIntegratedPeers, howMany, exclude, matches, mask);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectWellIntegrated(" + howMany + "), not enough integrated (" + matches.size() + ") going on to notFailing");
            }
            this.selectNotFailingPeers(howMany, exclude, matches, mask);
        } else if (this._log.shouldLog(20)) {
            this._log.info("selectWellIntegrated(" + howMany + "), found enough well integrated (" + matches.size() + ")");
        }
    }

    public void selectNotFailingPeers(int howMany, Set exclude, Set matches) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, 0);
    }

    public void selectNotFailingPeers(int howMany, Set exclude, Set matches, int mask) {
        this.selectNotFailingPeers(howMany, exclude, matches, false, mask);
    }

    public void selectNotFailingPeers(int howMany, Set exclude, Set matches, boolean onlyNotFailing) {
        this.selectNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0);
    }

    public void selectNotFailingPeers(int howMany, Set exclude, Set matches, boolean onlyNotFailing, int mask) {
        if (matches.size() < howMany) {
            this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, mask);
        }
    }

    public void selectAllNotFailingPeers(int howMany, Set exclude, Set matches, boolean onlyNotFailing) {
        this.selectAllNotFailingPeers(howMany, exclude, matches, onlyNotFailing, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAllNotFailingPeers(int howMany, Set exclude, Set matches, boolean onlyNotFailing, int mask) {
        if (matches.size() < howMany) {
            int orig = matches.size();
            int needed = howMany - orig;
            int start = 0;
            ArrayList<Hash> selected = new ArrayList<Hash>(needed);
            Object object = this._reorganizeLock;
            synchronized (object) {
                start = this._context.random().nextInt(this._notFailingPeersList.size());
                for (int i = 0; i < this._notFailingPeersList.size() && selected.size() < needed; ++i) {
                    int curIndex = (i + start) % this._notFailingPeersList.size();
                    Hash cur = (Hash)this._notFailingPeersList.get(curIndex);
                    if (matches.contains(cur) || exclude != null && exclude.contains(cur)) {
                        if (!this._log.shouldLog(10)) continue;
                        this._log.debug("matched? " + matches.contains(cur) + " exclude: " + exclude + " cur=" + cur.toBase64());
                        continue;
                    }
                    if (onlyNotFailing && this._highCapacityPeers.containsKey(cur)) continue;
                    if (this.isSelectable(cur)) {
                        selected.add(cur);
                        continue;
                    }
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Not selectable: " + cur.toBase64());
                }
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Selecting all not failing (strict? " + onlyNotFailing + " start=" + start + ") found " + selected.size() + " new peers: " + selected + " all=" + this._notFailingPeersList.size() + " strict=" + this._strictCapacityOrder.size());
            }
            matches.addAll(selected);
        }
        if (matches.size() < howMany) {
            if (this._log.shouldLog(20)) {
                this._log.info("selectAllNotFailing(" + howMany + "), not enough (" + matches.size() + ") going on to failing");
            }
            this.selectFailingPeers(howMany, exclude, matches);
        } else if (this._log.shouldLog(20)) {
            this._log.info("selectAllNotFailing(" + howMany + "), enough (" + matches.size() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectFailingPeers(int howMany, Set exclude, Set matches) {
        Object object = this._reorganizeLock;
        synchronized (object) {
            this.locked_selectPeers(this._failingPeers, howMany, exclude, matches);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectPeersLocallyUnreachable() {
        ArrayList n;
        int count;
        Object object = this._reorganizeLock;
        synchronized (object) {
            count = this._notFailingPeers.size();
            n = new ArrayList(this._notFailingPeers.keySet());
        }
        ArrayList<Hash> l = new ArrayList<Hash>(count / 4);
        for (Hash peer : n) {
            if (this._context.commSystem().wasUnreachable(peer)) {
                l.add(peer);
                continue;
            }
            RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
            if (info == null) continue;
            String v = info.getOption("router.version");
            if (v != null && !v.equals("0.6.1.33") && v.startsWith("0.6.1.") && info.getTargetAddress("NTCP") == null) {
                l.add(peer);
                continue;
            }
            RouterAddress ra = info.getTargetAddress("SSU");
            if (ra == null) {
                l.add(peer);
                continue;
            }
            Properties props = ra.getOptions();
            if (props == null || props.getProperty("ihost0") == null) continue;
            l.add(peer);
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Unreachable: " + l);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectPeersRecentlyRejecting() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            long cutoff = this._context.clock().now() - 20000L;
            int count = this._notFailingPeers.size();
            ArrayList<Hash> l = new ArrayList<Hash>(count / 128);
            for (PeerProfile prof : this._notFailingPeers.values()) {
                if (prof.getTunnelHistory().getLastRejectedBandwidth() <= cutoff) continue;
                l.add(prof.getPeer());
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set selectAllPeers() {
        Object object = this._reorganizeLock;
        synchronized (object) {
            HashSet allPeers = new HashSet(this._failingPeers.size() + this._notFailingPeers.size() + this._highCapacityPeers.size() + this._fastPeers.size());
            allPeers.addAll(this._failingPeers.keySet());
            allPeers.addAll(this._notFailingPeers.keySet());
            allPeers.addAll(this._highCapacityPeers.keySet());
            allPeers.addAll(this._fastPeers.keySet());
            return allPeers;
        }
    }

    public void reorganize() {
        this.reorganize(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorganize(boolean shouldCoalesce) {
        long sortTime = 0L;
        int coalesceTime = 0;
        long thresholdTime = 0L;
        long placeTime = 0L;
        int profileCount = 0;
        long uptime = this._context.router().getUptime();
        long expireOlderThan = -1L;
        if (uptime > 3600000L) {
            expireOlderThan = this._context.clock().now() - 21600000L;
        }
        long start = System.currentTimeMillis();
        Object object = this._reorganizeLock;
        synchronized (object) {
            Set allPeers = this._strictCapacityOrder;
            TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
            long sortStart = System.currentTimeMillis();
            for (PeerProfile prof : this._strictCapacityOrder) {
                if (expireOlderThan > 0L && prof.getLastSendSuccessful() <= expireOlderThan) continue;
                if (shouldCoalesce) {
                    long coalesceStart = System.currentTimeMillis();
                    prof.coalesceStats();
                    coalesceTime += (int)(System.currentTimeMillis() - coalesceStart);
                }
                reordered.add(prof);
                ++profileCount;
            }
            sortTime = System.currentTimeMillis() - sortStart;
            this._strictCapacityOrder = reordered;
            long thresholdStart = System.currentTimeMillis();
            this.locked_calculateThresholds(allPeers);
            thresholdTime = System.currentTimeMillis() - thresholdStart;
            this._failingPeers.clear();
            this._fastPeers.clear();
            this._highCapacityPeers.clear();
            this._notFailingPeers.clear();
            this._notFailingPeersList.clear();
            this._wellIntegratedPeers.clear();
            long placeStart = System.currentTimeMillis();
            for (PeerProfile profile : allPeers) {
                this.locked_placeProfile(profile);
            }
            this.locked_unfailAsNecessary();
            this.locked_promoteFastAsNecessary();
            Collections.shuffle(this._notFailingPeersList, (Random)this._context.random());
            placeTime = System.currentTimeMillis() - placeStart;
            if (this._log.shouldLog(20)) {
                this._log.info("Profiles reorganized.  averages: [integration: " + this._thresholdIntegrationValue + ", capacity: " + this._thresholdCapacityValue + ", speed: " + this._thresholdSpeedValue + "]");
            }
        }
        long total = System.currentTimeMillis() - start;
        this._context.statManager().addRateData("peer.profileSortTime", sortTime, (long)profileCount);
        this._context.statManager().addRateData("peer.profileCoalesceTime", (long)coalesceTime, (long)profileCount);
        this._context.statManager().addRateData("peer.profileThresholdTime", thresholdTime, (long)profileCount);
        this._context.statManager().addRateData("peer.profilePlaceTime", placeTime, (long)profileCount);
        this._context.statManager().addRateData("peer.profileReorgTime", total, (long)profileCount);
    }

    private void locked_promoteFastAsNecessary() {
        int minFastPeers = this.getMinimumFastPeers();
        int numToPromote = minFastPeers - this._fastPeers.size();
        if (numToPromote > 0) {
            if (this._log.shouldLog(20)) {
                this._log.info("Need to explicitly promote " + numToPromote + " peers to the fast group");
            }
            for (PeerProfile cur : this._strictCapacityOrder) {
                if (this._fastPeers.containsKey(cur.getPeer()) || cur.getIsFailing() || !this.isSelectable(cur.getPeer()) || !cur.getIsActive()) continue;
                if (this._log.shouldLog(20)) {
                    this._log.info("Fast promoting: " + cur.getPeer().toBase64());
                }
                this._fastPeers.put(cur.getPeer(), cur);
                if (--numToPromote > 0) continue;
                break;
            }
        }
    }

    private void locked_unfailAsNecessary() {
        int notFailingActive = 0;
        for (Hash key : this._notFailingPeers.keySet()) {
            PeerProfile peer = (PeerProfile)this._notFailingPeers.get(key);
            if (peer.getIsActive()) {
                ++notFailingActive;
            }
            if (notFailingActive < 3) continue;
            return;
        }
        int needToUnfail = 3 - notFailingActive;
        if (needToUnfail > 0) {
            int unfailed = 0;
            for (PeerProfile best : this._strictCapacityOrder) {
                if (best.getIsActive() && best.getIsFailing()) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("All peers were failing, so we have overridden the failing flag for one of the most reliable active peers (" + best.getPeer().toBase64() + ")");
                    }
                    best.setIsFailing(false);
                    this.locked_placeProfile(best);
                    ++unfailed;
                }
                if (unfailed < needToUnfail) continue;
                break;
            }
        }
    }

    private void locked_calculateThresholds(Set allPeers) {
        double totalCapacity = 0.0;
        double totalIntegration = 0.0;
        TreeSet<PeerProfile> reordered = new TreeSet<PeerProfile>(this._comp);
        for (PeerProfile profile : allPeers) {
            if (this._us.equals((Object)profile.getPeer()) || profile.getIsFailing() || !profile.getIsActive()) continue;
            totalCapacity += profile.getCapacityValue();
            totalIntegration += profile.getIntegrationValue();
            reordered.add(profile);
        }
        this.locked_calculateCapacityThreshold(totalCapacity, reordered);
        this.locked_calculateSpeedThreshold(reordered);
        this._thresholdIntegrationValue = totalIntegration > 0.0 ? 1.0 * ProfileOrganizer.avg(totalIntegration, reordered.size()) : 1.0;
    }

    private void locked_calculateCapacityThreshold(double totalCapacity, Set reordered) {
        int numNotFailing = reordered.size();
        double meanCapacity = ProfileOrganizer.avg(totalCapacity, numNotFailing);
        int minHighCapacityPeers = this.getMinimumHighCapacityPeers();
        int numExceedingMean = 0;
        double thresholdAtMedian = 0.0;
        double thresholdAtMinHighCap = 0.0;
        double thresholdAtLowest = CapacityCalculator.GROWTH_FACTOR;
        int cur = 0;
        for (PeerProfile profile : reordered) {
            double val = profile.getCapacityValue();
            if (val > meanCapacity) {
                ++numExceedingMean;
            }
            if (cur == reordered.size() / 2) {
                thresholdAtMedian = val;
            }
            if (cur == minHighCapacityPeers - 1) {
                thresholdAtMinHighCap = val;
            }
            if (cur == reordered.size() - 1) {
                thresholdAtLowest = val;
            }
            ++cur;
        }
        if (numExceedingMean >= minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity is doing well [" + meanCapacity + "], and includes " + numExceedingMean);
            }
            this._thresholdCapacityValue = meanCapacity;
        } else if (meanCapacity > thresholdAtMedian && reordered.size() / 2 > minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity [" + meanCapacity + "] is greater than the median," + " so threshold is that reqd to get the min high cap peers " + thresholdAtMinHighCap);
            }
            this._thresholdCapacityValue = thresholdAtMinHighCap;
        } else if (reordered.size() / 2 >= minHighCapacityPeers) {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity [" + meanCapacity + "] is skewed under the median," + " so use the median threshold " + thresholdAtMedian);
            }
            this._thresholdCapacityValue = thresholdAtMedian;
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Our average capacity is doing well [" + meanCapacity + "], but there aren't enough of them " + numExceedingMean);
            }
            this._thresholdCapacityValue = Math.max(thresholdAtMinHighCap, thresholdAtLowest);
        }
        if (this._thresholdCapacityValue <= (double)CapacityCalculator.GROWTH_FACTOR) {
            this._thresholdCapacityValue = (double)CapacityCalculator.GROWTH_FACTOR + 1.0E-4;
        }
    }

    private void locked_calculateSpeedThreshold(Set reordered) {
        this.locked_calculateSpeedThresholdMean(reordered);
    }

    private void locked_calculateSpeedThresholdMean(Set reordered) {
        PeerProfile profile;
        double total = 0.0;
        int count = 0;
        Iterator iter = reordered.iterator();
        while (iter.hasNext() && (profile = (PeerProfile)iter.next()).getCapacityValue() >= this._thresholdCapacityValue) {
            total += profile.getSpeedValue();
            ++count;
        }
        if (count > 0) {
            this._thresholdSpeedValue = total / (double)count;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Threshold value for speed: " + this._thresholdSpeedValue + " out of speeds: " + count);
        }
    }

    private static final double avg(double total, double quantity) {
        if (total > 0.0 && quantity > 0.0) {
            return total / quantity;
        }
        return 0.0;
    }

    private PeerProfile locked_getProfile(Hash peer) {
        PeerProfile cur = (PeerProfile)this._notFailingPeers.get(peer);
        if (cur != null) {
            return cur;
        }
        cur = (PeerProfile)this._failingPeers.get(peer);
        return cur;
    }

    private void locked_selectPeers(Map peers, int howMany, Set toExclude, Set matches) {
        this.locked_selectPeers(peers, howMany, toExclude, matches, 0);
    }

    private void locked_selectPeers(Map peers, int howMany, Set toExclude, Set matches, int mask) {
        ArrayList all = new ArrayList(peers.keySet());
        if (toExclude != null) {
            all.removeAll(toExclude);
        }
        all.removeAll(matches);
        all.remove(this._us);
        Collections.shuffle(all, this._random);
        for (int i = 0; matches.size() < howMany && i < all.size(); ++i) {
            Hash peer = (Hash)all.get(i);
            boolean ok = this.isSelectable(peer);
            if (ok) {
                boolean bl = ok = mask <= 0 || this.notRestricted(peer, matches, mask);
                if (!ok && this._log.shouldLog(30)) {
                    this._log.warn("IP restriction prevents " + peer + " from joining " + matches);
                }
            }
            if (ok) {
                matches.add(peer);
                continue;
            }
            matches.remove(peer);
        }
    }

    private boolean notRestricted(Hash peer, Set matches, int mask) {
        if (mask <= 0) {
            return true;
        }
        if (matches.size() <= 0) {
            return true;
        }
        RouterInfo pinfo = this._context.netDb().lookupRouterInfoLocally(peer);
        if (pinfo == null) {
            return false;
        }
        Set paddr = pinfo.getAddresses();
        if (paddr == null || paddr.size() == 0) {
            return false;
        }
        ArrayList pladdr = new ArrayList(paddr);
        ArrayList lmatches = new ArrayList(matches);
        for (int i = 0; i < matches.size(); ++i) {
            Set maddr;
            RouterInfo minfo = this._context.netDb().lookupRouterInfoLocally((Hash)lmatches.get(i));
            if (minfo == null || (maddr = minfo.getAddresses()) == null || maddr.size() == 0) continue;
            ArrayList mladdr = new ArrayList(maddr);
            String oldphost = null;
            for (int j = 0; j < paddr.size(); ++j) {
                InetAddress pi;
                String phost;
                Properties pprops;
                RouterAddress pa = (RouterAddress)pladdr.get(j);
                if (pa == null || (pprops = pa.getOptions()) == null || (phost = pprops.getProperty("host")) == null || oldphost != null && oldphost.equals(phost)) continue;
                oldphost = phost;
                try {
                    pi = InetAddress.getByName(phost);
                }
                catch (UnknownHostException uhe) {
                    continue;
                }
                if (pi == null) continue;
                byte[] pib = pi.getAddress();
                String oldmhost = null;
                for (int k = 0; k < maddr.size(); ++k) {
                    InetAddress mi;
                    String mhost;
                    Properties mprops;
                    RouterAddress ma = (RouterAddress)mladdr.get(k);
                    if (ma == null || (mprops = ma.getOptions()) == null || (mhost = mprops.getProperty("host")) == null || oldmhost != null && oldmhost.equals(mhost)) continue;
                    oldmhost = mhost;
                    try {
                        mi = InetAddress.getByName(mhost);
                    }
                    catch (UnknownHostException uhe) {
                        continue;
                    }
                    if (mi == null) continue;
                    byte[] mib = mi.getAddress();
                    for (int m = 0; m < mask && pib[m] == mib[m]; ++m) {
                        if (m != mask - 1) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isSelectable(Hash peer) {
        NetworkDatabaseFacade netDb = this._context.netDb();
        if (netDb == null) {
            return true;
        }
        if (this._context.router() == null) {
            return true;
        }
        if (this._context.shitlist() != null && this._context.shitlist().isShitlisted(peer)) {
            return false;
        }
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (null != info) {
            if (info.getIdentity().isHidden()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Peer " + peer.toBase64() + " is marked as hidden, disallowing its use");
                }
                return false;
            }
            boolean exclude = TunnelPeerSelector.shouldExclude(this._context, info);
            return !exclude;
        }
        return false;
    }

    private void locked_placeProfile(PeerProfile profile) {
        if (profile.getIsFailing()) {
            if (!this.shouldDrop(profile)) {
                this._failingPeers.put(profile.getPeer(), profile);
            }
            this._fastPeers.remove(profile.getPeer());
            this._highCapacityPeers.remove(profile.getPeer());
            this._wellIntegratedPeers.remove(profile.getPeer());
            this._notFailingPeers.remove(profile.getPeer());
            this._notFailingPeersList.remove(profile.getPeer());
        } else {
            this._failingPeers.remove(profile.getPeer());
            this._fastPeers.remove(profile.getPeer());
            this._highCapacityPeers.remove(profile.getPeer());
            this._wellIntegratedPeers.remove(profile.getPeer());
            this._notFailingPeers.put(profile.getPeer(), profile);
            this._notFailingPeersList.add(profile.getPeer());
            if (this._thresholdCapacityValue <= profile.getCapacityValue() && this.isSelectable(profile.getPeer())) {
                this._highCapacityPeers.put(profile.getPeer(), profile);
                if (this._log.shouldLog(10)) {
                    this._log.debug("High capacity: \t" + profile.getPeer().toBase64());
                }
                if (this._thresholdSpeedValue <= profile.getSpeedValue()) {
                    if (!profile.getIsActive()) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("Skipping fast mark [!active] for " + profile.getPeer().toBase64());
                        }
                    } else {
                        this._fastPeers.put(profile.getPeer(), profile);
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Fast: \t" + profile.getPeer().toBase64());
                        }
                    }
                }
            }
            if (this._thresholdIntegrationValue <= profile.getIntegrationValue()) {
                this._wellIntegratedPeers.put(profile.getPeer(), profile);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Integrated: \t" + profile.getPeer().toBase64());
                }
            }
        }
    }

    private boolean shouldDrop(PeerProfile profile) {
        return false;
    }

    protected int getMinimumFastPeers() {
        block5: {
            String val = this._context.getProperty(PROP_MINIMUM_FAST_PEERS, "8");
            if (val != null) {
                try {
                    int rv = Integer.parseInt(val);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("router context said profileOrganizer.minFastPeers=" + val);
                    }
                    return rv;
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(30)) break block5;
                    this._log.warn("Minimum fast peers improperly set in the router environment [" + val + "]", (Throwable)nfe);
                }
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("no config for profileOrganizer.minFastPeers, using 8");
        }
        return 8;
    }

    protected int getMinimumHighCapacityPeers() {
        block5: {
            String val = this._context.getProperty(PROP_MINIMUM_HIGH_CAPACITY_PEERS, "10");
            if (val != null) {
                try {
                    int rv = Integer.parseInt(val);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("router context said profileOrganizer.minHighCapacityPeers=" + val);
                    }
                    return rv;
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(30)) break block5;
                    this._log.warn("Minimum high capacity peers improperly set in the router environment [" + val + "]", (Throwable)nfe);
                }
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("no config for profileOrganizer.minHighCapacityPeers, using 10");
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    public static void main(String[] args) {
        RouterContext ctx = new RouterContext(null);
        ProfileOrganizer organizer = new ProfileOrganizer(ctx);
        organizer.setUs(Hash.FAKE_HASH);
        ProfilePersistenceHelper helper = new ProfilePersistenceHelper(ctx);
        for (int i = 0; i < args.length; ++i) {
            PeerProfile profile = helper.readProfile(new File(args[i]));
            if (profile == null) {
                System.err.println("Could not load profile " + args[i]);
                continue;
            }
            organizer.addProfile(profile);
        }
        organizer.reorganize();
        DecimalFormat fmt = new DecimalFormat("0,000.0");
        fmt.setPositivePrefix("+");
        for (Hash peer : organizer.selectAllPeers()) {
            PeerProfile profile = organizer.getProfile(peer);
            if (!profile.getIsActive()) {
                System.out.println("Peer " + profile.getPeer().toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "IF+R" : (organizer.isHighCapacity(peer) ? "IR  " : (organizer.isFailing(peer) ? "IX  " : "I   "))) + "]: " + "\t Speed:\t" + fmt.format(profile.getSpeedValue()) + " Reliability:\t" + fmt.format(profile.getReliabilityValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive() + " Failing?\t" + profile.getIsFailing());
                continue;
            }
            System.out.println("Peer " + profile.getPeer().toBase64().substring(0, 4) + " [" + (organizer.isFast(peer) ? "F+R " : (organizer.isHighCapacity(peer) ? "R   " : (organizer.isFailing(peer) ? "X   " : "    "))) + "]: " + "\t Speed:\t" + fmt.format(profile.getSpeedValue()) + " Reliability:\t" + fmt.format(profile.getReliabilityValue()) + " Capacity:\t" + fmt.format(profile.getCapacityValue()) + " Integration:\t" + fmt.format(profile.getIntegrationValue()) + " Active?\t" + profile.getIsActive() + " Failing?\t" + profile.getIsFailing());
        }
        System.out.println("Thresholds:");
        System.out.println("Speed:       " + ProfileOrganizer.num(organizer.getSpeedThreshold()) + " (" + organizer.countFastPeers() + " fast peers)");
        System.out.println("Capacity:    " + ProfileOrganizer.num(organizer.getCapacityThreshold()) + " (" + organizer.countHighCapacityPeers() + " reliable peers)");
    }
}

