/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.Calculator;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class StrictSpeedCalculator
extends Calculator {
    private Log _log;
    private RouterContext _context;

    public StrictSpeedCalculator(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(StrictSpeedCalculator.class);
    }

    public double calc(PeerProfile profile) {
        return this.countSuccesses(profile);
    }

    private double countSuccesses(PeerProfile profile) {
        RateStat success = profile.getTunnelHistory().getProcessSuccessRate();
        RateStat failure = profile.getTunnelHistory().getProcessFailureRate();
        return this.messagesPerMinute(success, failure);
    }

    private double messagesPerMinute(RateStat success, RateStat failure) {
        double rv = 0.0;
        if (success != null) {
            Rate rate = null;
            long[] periods = success.getPeriods();
            for (int i = 0; !(i >= periods.length || (rate = success.getRate(periods[i])) != null && rate.getCurrentTotalValue() > 0.0); ++i) {
            }
            double value = rate.getCurrentTotalValue();
            rv = (value += rate.getLastTotalValue()) * 10.0 * 60.0 * 1000.0 / (double)rate.getPeriod();
            Rate fail = failure.getRate(rate.getPeriod());
            if (fail.getCurrentTotalValue() > 0.0) {
                rv /= fail.getCurrentTotalValue();
            }
        }
        return rv;
    }
}

