/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelHistory {
    private RouterContext _context;
    private Log _log;
    private volatile long _lifetimeAgreedTo;
    private volatile long _lifetimeRejected;
    private volatile long _lastAgreedTo;
    private volatile long _lastRejectedCritical;
    private volatile long _lastRejectedBandwidth;
    private volatile long _lastRejectedTransient;
    private volatile long _lastRejectedProbabalistic;
    private volatile long _lifetimeFailed;
    private volatile long _lastFailed;
    private RateStat _rejectRate;
    private RateStat _failRate;
    private RateStat _processSuccessRate;
    private RateStat _processFailureRate;
    private String _statGroup;
    public static final int TUNNEL_REJECT_PROBABALISTIC_REJECT = 10;
    public static final int TUNNEL_REJECT_TRANSIENT_OVERLOAD = 20;
    public static final int TUNNEL_REJECT_BANDWIDTH = 30;
    public static final int TUNNEL_REJECT_CRIT = 50;
    private static final String NL = System.getProperty("line.separator");

    public TunnelHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(TunnelHistory.class);
        this._statGroup = statGroup;
        this.createRates(statGroup);
    }

    private void createRates(String statGroup) {
        this._rejectRate = new RateStat("tunnelHistory.rejectRate", "How often does this peer reject a tunnel request?", statGroup, new long[]{60000L, 600000L, 1800000L, 3600000L, 86400000L});
        this._failRate = new RateStat("tunnelHistory.failRate", "How often do tunnels this peer accepts fail?", statGroup, new long[]{60000L, 600000L, 1800000L, 3600000L, 86400000L});
        this._processSuccessRate = new RateStat("tunnelHistory.processSuccessRate", "How many messages does a tunnel process?", statGroup, new long[]{300000L, 600000L, 1800000L, 3600000L, 86400000L});
        this._processFailureRate = new RateStat("tunnelHistory.processfailureRate", "How many messages does a tunnel fail?", statGroup, new long[]{300000L, 600000L, 1800000L, 3600000L, 86400000L});
        this._rejectRate.setStatLog(this._context.statManager().getStatLog());
        this._failRate.setStatLog(this._context.statManager().getStatLog());
        this._processSuccessRate.setStatLog(this._context.statManager().getStatLog());
        this._processFailureRate.setStatLog(this._context.statManager().getStatLog());
    }

    public long getLifetimeAgreedTo() {
        return this._lifetimeAgreedTo;
    }

    public long getLifetimeRejected() {
        return this._lifetimeRejected;
    }

    public long getLifetimeFailed() {
        return this._lifetimeFailed;
    }

    public long getLastAgreedTo() {
        return this._lastAgreedTo;
    }

    public long getLastRejectedCritical() {
        return this._lastRejectedCritical;
    }

    public long getLastRejectedBandwidth() {
        return this._lastRejectedBandwidth;
    }

    public long getLastRejectedTransient() {
        return this._lastRejectedTransient;
    }

    public long getLastRejectedProbabalistic() {
        return this._lastRejectedProbabalistic;
    }

    public long getLastFailed() {
        return this._lastFailed;
    }

    public void incrementProcessed(int processedSuccessfully, int failedProcessing) {
        if (processedSuccessfully > 0) {
            this._processSuccessRate.addData((long)processedSuccessfully, 0L);
        }
        if (failedProcessing > 0) {
            this._processFailureRate.addData((long)failedProcessing, 0L);
        }
    }

    public void incrementAgreedTo() {
        ++this._lifetimeAgreedTo;
        this._lastAgreedTo = this._context.clock().now();
    }

    public void incrementRejected(int severity) {
        ++this._lifetimeRejected;
        if (severity >= 50) {
            this._lastRejectedCritical = this._context.clock().now();
            this._rejectRate.addData(1L, 1L);
        } else if (severity >= 30) {
            this._lastRejectedBandwidth = this._context.clock().now();
            this._rejectRate.addData(1L, 1L);
        } else if (severity >= 20) {
            this._lastRejectedTransient = this._context.clock().now();
        } else if (severity >= 10) {
            this._lastRejectedProbabalistic = this._context.clock().now();
        }
    }

    public void incrementFailed(int pct) {
        ++this._lifetimeFailed;
        this._failRate.addData((long)pct, 1L);
        this._lastFailed = this._context.clock().now();
    }

    public void setLifetimeAgreedTo(long num) {
        this._lifetimeAgreedTo = num;
    }

    public void setLifetimeRejected(long num) {
        this._lifetimeRejected = num;
    }

    public void setLifetimeFailed(long num) {
        this._lifetimeFailed = num;
    }

    public void setLastAgreedTo(long when) {
        this._lastAgreedTo = when;
    }

    public void setLastRejectedCritical(long when) {
        this._lastRejectedCritical = when;
    }

    public void setLastRejectedBandwidth(long when) {
        this._lastRejectedBandwidth = when;
    }

    public void setLastRejectedTransient(long when) {
        this._lastRejectedTransient = when;
    }

    public void setLastRejectedProbabalistic(long when) {
        this._lastRejectedProbabalistic = when;
    }

    public void setLastFailed(long when) {
        this._lastFailed = when;
    }

    public RateStat getRejectionRate() {
        return this._rejectRate;
    }

    public RateStat getFailedRate() {
        return this._failRate;
    }

    public RateStat getProcessSuccessRate() {
        return this._processSuccessRate;
    }

    public RateStat getProcessFailureRate() {
        return this._processFailureRate;
    }

    public void coalesceStats() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Coallescing stats");
        }
        this._rejectRate.coalesceStats();
        this._failRate.coalesceStats();
        this._processFailureRate.coalesceStats();
        this._processSuccessRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        StringBuffer buf = new StringBuffer(512);
        buf.append(NL);
        buf.append("#################").append(NL);
        buf.append("# Tunnel history").append(NL);
        buf.append("###").append(NL);
        this.add(buf, "lastAgreedTo", this._lastAgreedTo, "When did the peer last agree to participate in a tunnel?  (milliseconds since the epoch)");
        this.add(buf, "lastFailed", this._lastFailed, "When was the last time a tunnel that the peer agreed to participate failed?  (milliseconds since the epoch)");
        this.add(buf, "lastRejectedCritical", this._lastRejectedCritical, "When was the last time the peer refused to participate in a tunnel?  (milliseconds since the epoch)");
        this.add(buf, "lastRejectedBandwidth", this._lastRejectedBandwidth, "When was the last time the peer refused to participate in a tunnel?  (milliseconds since the epoch)");
        this.add(buf, "lastRejectedTransient", this._lastRejectedTransient, "When was the last time the peer refused to participate in a tunnel?  (milliseconds since the epoch)");
        this.add(buf, "lastRejectedProbabalistic", this._lastRejectedProbabalistic, "When was the last time the peer refused to participate in a tunnel?  (milliseconds since the epoch)");
        this.add(buf, "lifetimeAgreedTo", this._lifetimeAgreedTo, "How many tunnels has the peer ever agreed to participate in?");
        this.add(buf, "lifetimeFailed", this._lifetimeFailed, "How many tunnels has the peer ever agreed to participate in that failed prematurely?");
        this.add(buf, "lifetimeRejected", this._lifetimeRejected, "How many tunnels has the peer ever refused to participate in?");
        out.write(buf.toString().getBytes());
        this._rejectRate.store(out, "tunnelHistory.rejectRate");
        this._failRate.store(out, "tunnelHistory.failRate");
        this._processSuccessRate.store(out, "tunnelHistory.processSuccessRate");
        this._processFailureRate.store(out, "tunnelHistory.processFailureRate");
    }

    private void add(StringBuffer buf, String name, long val, String description) {
        buf.append("# ").append(name.toUpperCase()).append(NL).append("# ").append(description).append(NL);
        buf.append("tunnels.").append(name).append('=').append(val).append(NL).append(NL);
    }

    public void load(Properties props) {
        this._lastAgreedTo = TunnelHistory.getLong(props, "tunnels.lastAgreedTo");
        this._lastFailed = TunnelHistory.getLong(props, "tunnels.lastFailed");
        this._lastRejectedCritical = TunnelHistory.getLong(props, "tunnels.lastRejectedCritical");
        this._lastRejectedBandwidth = TunnelHistory.getLong(props, "tunnels.lastRejectedBandwidth");
        this._lastRejectedTransient = TunnelHistory.getLong(props, "tunnels.lastRejectedTransient");
        this._lastRejectedProbabalistic = TunnelHistory.getLong(props, "tunnels.lastRejectedProbabalistic");
        this._lifetimeAgreedTo = TunnelHistory.getLong(props, "tunnels.lifetimeAgreedTo");
        this._lifetimeFailed = TunnelHistory.getLong(props, "tunnels.lifetimeFailed");
        this._lifetimeRejected = TunnelHistory.getLong(props, "tunnels.lifetimeRejected");
        try {
            this._rejectRate.load(props, "tunnelHistory.rejectRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.rejectRate");
            }
            this._failRate.load(props, "tunnelHistory.failRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.failRate");
            }
            this._processFailureRate.load(props, "tunnelHistory.processFailureRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.processFailureRate");
            }
            this._processSuccessRate.load(props, "tunnelHistory.processSuccessRate", true);
            if (this._log.shouldLog(10)) {
                this._log.debug("Loading tunnelHistory.processSuccessRate");
            }
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("TunnelHistory rates are corrupt, resetting", (Throwable)iae);
            this.createRates(this._statGroup);
        }
    }

    private static final long getLong(Properties props, String key) {
        String val = props.getProperty(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        return 0L;
    }
}

