/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.BootNetworkDbJob;
import net.i2p.router.startup.BuildTrustedLinksJob;
import net.i2p.util.Log;

public class BootCommSystemJob
extends JobImpl {
    private Log _log;
    public static final String PROP_USE_TRUSTED_LINKS = "router.trustedLinks";

    public BootCommSystemJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(BootCommSystemJob.class);
    }

    public String getName() {
        return "Boot Communication System";
    }

    public void runJob() {
        this.getContext().commSystem().startup();
        this.getContext().tunnelManager().startup();
        this.getContext().peerManager().startup();
        BootNetworkDbJob bootDb = new BootNetworkDbJob(this.getContext());
        boolean useTrusted = false;
        String useTrustedStr = this.getContext().router().getConfigSetting(PROP_USE_TRUSTED_LINKS);
        if (useTrustedStr != null) {
            useTrusted = Boolean.TRUE.toString().equalsIgnoreCase(useTrustedStr);
        }
        if (useTrusted) {
            this._log.debug("Using trusted links...");
            this.getContext().jobQueue().addJob(new BuildTrustedLinksJob(this.getContext(), bootDb));
            return;
        }
        this._log.debug("Not using trusted links - boot db");
        this.getContext().jobQueue().addJob(bootDb);
    }
}

