/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;

public class ClientAppConfig {
    private static final long STARTUP_DELAY = 120000L;
    private static final String PROP_CLIENT_CONFIG_FILENAME = "router.clientConfigFile";
    private static final String DEFAULT_CLIENT_CONFIG_FILENAME = "clients.config";
    private static final String PREFIX = "clientApp.";
    public String className;
    public String clientName;
    public String args;
    public long delay;
    public boolean disabled;

    public ClientAppConfig(String cl, String client, String a, long d, boolean dis) {
        this.className = cl;
        this.clientName = client;
        this.args = a;
        this.delay = d;
        this.disabled = dis;
    }

    private static Properties getClientAppProps(RouterContext ctx) {
        Properties rv = new Properties();
        String clientConfigFile = ctx.getProperty(PROP_CLIENT_CONFIG_FILENAME, DEFAULT_CLIENT_CONFIG_FILENAME);
        File cfgFile = new File(clientConfigFile);
        if (!cfgFile.exists()) {
            return ctx.router().getConfigMap();
        }
        try {
            DataHelper.loadProps((Properties)rv, (File)cfgFile);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return rv;
    }

    public static List getClientApps(RouterContext ctx) {
        String className;
        Properties clientApps = ClientAppConfig.getClientAppProps(ctx);
        ArrayList<ClientAppConfig> rv = new ArrayList<ClientAppConfig>(5);
        int i = 0;
        while ((className = clientApps.getProperty(PREFIX + i + ".main")) != null) {
            long delay;
            String clientName = clientApps.getProperty(PREFIX + i + ".name");
            String args = clientApps.getProperty(PREFIX + i + ".args");
            String delayStr = clientApps.getProperty(PREFIX + i + ".delay");
            String onBoot = clientApps.getProperty(PREFIX + i + ".onBoot");
            String disabled = clientApps.getProperty(PREFIX + i + ".startOnLoad");
            ++i;
            boolean dis = disabled != null && "false".equals(disabled);
            boolean onStartup = false;
            if (onBoot != null) {
                onStartup = "true".equals(onBoot) || "yes".equals(onBoot);
            }
            long l = delay = onStartup ? 0L : 120000L;
            if (delayStr != null && !onStartup) {
                try {
                    delay = 1000 * Integer.parseInt(delayStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            rv.add(new ClientAppConfig(className, clientName, args, delay, dis));
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientAppConfig(RouterContext ctx, List apps) {
        String clientConfigFile = ctx.getProperty(PROP_CLIENT_CONFIG_FILENAME, DEFAULT_CLIENT_CONFIG_FILENAME);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(clientConfigFile);
            StringBuffer buf = new StringBuffer(2048);
            for (int i = 0; i < apps.size(); ++i) {
                ClientAppConfig app = (ClientAppConfig)apps.get(i);
                buf.append(PREFIX).append(i).append(".main=").append(app.className).append("\n");
                buf.append(PREFIX).append(i).append(".name=").append(app.clientName).append("\n");
                buf.append(PREFIX).append(i).append(".args=").append(app.args).append("\n");
                buf.append(PREFIX).append(i).append(".delay=").append(app.delay / 1000L).append("\n");
                buf.append(PREFIX).append(i).append(".startOnLoad=").append(!app.disabled).append("\n");
            }
            fos.write(buf.toString().getBytes());
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

