/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.RouterIdentity;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.util.Log;

public class BandwidthLimitedOutputStream
extends FilterOutputStream {
    private RouterIdentity _peer;
    private String _peerTarget;
    private RouterContext _context;
    private Log _log;
    private FIFOBandwidthLimiter.Request _currentRequest;

    public BandwidthLimitedOutputStream(RouterContext context, OutputStream source, RouterIdentity peer) {
        super(source);
        this._context = context;
        this._peer = peer;
        this._peerTarget = peer != null ? peer.getHash().toBase64() : "unknown";
        this._log = context.logManager().getLog(BandwidthLimitedOutputStream.class);
        this._currentRequest = null;
    }

    public FIFOBandwidthLimiter.Request getCurrentRequest() {
        return this._currentRequest;
    }

    public void write(int val) throws IOException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Writing a single byte!", (Throwable)new Exception("Single byte from..."));
        }
        long before = this._context.clock().now();
        FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestOutbound(1, this._peerTarget);
        req.waitForNextAllocation();
        long waited = this._context.clock().now() - before;
        if (waited > 1000L && this._log.shouldLog(30)) {
            this._log.warn("Waiting to write a byte took too long [" + waited + "ms");
        }
        this.out.write(val);
    }

    public void write(byte[] src) throws IOException {
        this.write(src, 0, src.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] src, int off, int len) throws IOException {
        if (this._log.shouldLog(10)) {
            this._log.debug("Writing " + len + " bytes");
        }
        if (src == null) {
            return;
        }
        if (len <= 0) {
            return;
        }
        if (len + off > src.length) {
            throw new IllegalArgumentException("wtf are you thinking?  len=" + len + ", off=" + off + ", data=" + src.length);
        }
        this._currentRequest = this._context.bandwidthLimiter().requestOutbound(len, this._peerTarget);
        int written = 0;
        while (written < len) {
            int allocated = len - this._currentRequest.getPendingOutboundRequested();
            int toWrite = allocated - written;
            if (toWrite > 0) {
                try {
                    this.out.write(src, off + written, toWrite);
                }
                catch (IOException ioe) {
                    this._currentRequest.abort();
                    this._currentRequest = null;
                    throw ioe;
                }
                written += toWrite;
            }
            this._currentRequest.waitForNextAllocation();
        }
        BandwidthLimitedOutputStream bandwidthLimitedOutputStream = this;
        synchronized (bandwidthLimitedOutputStream) {
            this._currentRequest = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        BandwidthLimitedOutputStream bandwidthLimitedOutputStream = this;
        synchronized (bandwidthLimitedOutputStream) {
            if (this._currentRequest != null) {
                this._currentRequest.abort();
            }
        }
        super.close();
    }
}

