/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class ACKSender
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private UDPTransport _transport;
    private PacketBuilder _builder;
    private List _peersToACK;
    private boolean _alive;
    static final int ACK_FREQUENCY = 500;

    public ACKSender(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ACKSender.class);
        this._transport = transport;
        this._peersToACK = new ArrayList(4);
        this._builder = new PacketBuilder(this._context, transport);
        this._alive = true;
        this._context.statManager().createRateStat("udp.sendACKCount", "how many ack messages were sent to a peer", "udp", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("udp.ackFrequency", "how long ago did we send an ACK to this peer?", "udp", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("udp.sendACKRemaining", "when we ack a peer, how many peers are left waiting to ack?", "udp", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("udp.abortACK", "How often do we schedule up an ACK send only to find it had already been sent (through piggyback)?", "udp", new long[]{60000L, 3600000L});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ackPeer(PeerState peer) {
        List list = this._peersToACK;
        synchronized (list) {
            if (!this._peersToACK.contains(peer)) {
                this._peersToACK.add(peer);
            }
            this._peersToACK.notifyAll();
        }
    }

    public void startup() {
        this._alive = true;
        I2PThread t = new I2PThread((Runnable)this, "UDP ACK sender");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._alive = false;
        List list = this._peersToACK;
        synchronized (list) {
            this._peersToACK.clear();
            this._peersToACK.notifyAll();
        }
    }

    private long ackFrequency(long timeSinceACK, long rtt) {
        if (timeSinceACK < 2000L) {
            return Math.max(rtt / 2L, 500L);
        }
        return 500L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._alive) {
            PeerState peer = null;
            long now = this._context.clock().now();
            long remaining = -1L;
            try {
                List list = this._peersToACK;
                synchronized (list) {
                    for (int i = 0; i < this._peersToACK.size(); ++i) {
                        PeerState cur = (PeerState)this._peersToACK.get(i);
                        long wanted = cur.getWantedACKSendSince();
                        long delta = wanted + this.ackFrequency(now - cur.getLastACKSend(), cur.getRTT()) - now;
                        if ((wanted <= 0L || delta >= 0L) && !cur.unsentACKThresholdReached()) continue;
                        this._peersToACK.remove(i);
                        peer = cur;
                        break;
                    }
                    if (peer == null) {
                        if (this._peersToACK.size() <= 0) {
                            this._peersToACK.wait();
                        } else {
                            this._peersToACK.wait(50L);
                        }
                    } else {
                        remaining = this._peersToACK.size();
                    }
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (peer == null) continue;
            long lastSend = peer.getLastACKSend();
            long wanted = peer.getWantedACKSendSince();
            List ackBitfields = peer.retrieveACKBitfields(false);
            if (wanted < 0L) {
                this._log.error("wtf, why are we acking something they dont want?  remaining=" + remaining + ", peer=" + peer + ", bitfields=" + ackBitfields);
            }
            if (ackBitfields != null && ackBitfields.size() > 0) {
                this._context.statManager().addRateData("udp.sendACKCount", (long)ackBitfields.size(), 0L);
                if (remaining > 0L) {
                    this._context.statManager().addRateData("udp.sendACKRemaining", remaining, 0L);
                }
                now = this._context.clock().now();
                if (lastSend < 0L) {
                    lastSend = now - 1L;
                }
                this._context.statManager().addRateData("udp.ackFrequency", now - lastSend, now - wanted);
                UDPPacket ack = this._builder.buildACK(peer, ackBitfields);
                ack.markType(1);
                ack.setFragmentCount(-1);
                ack.setMessageType(42);
                if (this._log.shouldLog(20)) {
                    this._log.info("Sending ACK for " + ackBitfields);
                }
                boolean ok = peer.allocateSendingBytes(ack.getPacket().getLength(), true);
                this._transport.send(ack);
                if (wanted <= 0L || wanted > peer.getWantedACKSendSince()) continue;
                if (this._log.shouldLog(30)) {
                    this._log.warn("Rerequesting ACK for peer " + peer);
                }
                this.ackPeer(peer);
                continue;
            }
            this._context.statManager().addRateData("udp.abortACK", 1L, 0L);
        }
    }
}

