/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterIdentity;
import net.i2p.data.SessionKey;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

public class PacketBuilder {
    private I2PAppContext _context;
    private Log _log;
    private UDPTransport _transport;
    private static final ByteCache _ivCache = ByteCache.getInstance((int)64, (int)16);
    private static final ByteCache _hmacCache = ByteCache.getInstance((int)64, (int)32);
    private static final ByteCache _blockCache = ByteCache.getInstance((int)64, (int)16);
    static final int PROTOCOL_VERSION = 0;
    private static final int ACK_PRIORITY = 1;
    private static final byte SESSION_CREATED_FLAG_BYTE = 16;
    private static final byte SESSION_REQUEST_FLAG_BYTE = 0;
    private static final int MAX_IDENTITY_FRAGMENT_SIZE = 512;
    private static final byte SESSION_CONFIRMED_FLAG_BYTE = 32;
    private static final byte PEER_TEST_FLAG_BYTE = 112;
    private static final byte PEER_RELAY_REQUEST_FLAG_BYTE = 48;
    private static final byte PEER_RELAY_INTRO_FLAG_BYTE = 80;
    private static final byte PEER_RELAY_RESPONSE_FLAG_BYTE = 64;

    public PacketBuilder(I2PAppContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._transport = transport;
        this._log = ctx.logManager().getLog(PacketBuilder.class);
        this._context.statManager().createRateStat("udp.packetAuthTime", "How long it takes to encrypt and MAC a packet for sending", "udp", new long[]{60000L});
        this._context.statManager().createRateStat("udp.packetAuthTimeSlow", "How long it takes to encrypt and MAC a packet for sending (when its slow)", "udp", new long[]{60000L, 600000L});
    }

    public UDPPacket buildPacket(OutboundMessageState state, int fragment, PeerState peer) {
        return this.buildPacket(state, fragment, peer, null, null);
    }

    public UDPPacket buildPacket(OutboundMessageState state, int fragment, PeerState peer, List ackIdsRemaining, List partialACKsRemaining) {
        int start;
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        StringBuffer msg = null;
        boolean acksIncluded = false;
        if (this._log.shouldLog(20)) {
            msg = new StringBuffer(128);
            msg.append("Send to ").append(peer.getRemotePeer().toBase64());
            msg.append(" msg ").append(state.getMessageId()).append(":").append(fragment);
            if (fragment == state.getFragmentCount() - 1) {
                msg.append("*");
            }
        }
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = start = 32;
        int n = off++;
        data[n] = (byte)(data[n] | 0x60);
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)now);
        int n2 = off += 4;
        data[n2] = (byte)(data[n2] | 4);
        if (ackIdsRemaining != null && ackIdsRemaining.size() > 0) {
            int n3 = off;
            data[n3] = (byte)(data[n3] | 0xFFFFFF80);
        }
        if (partialACKsRemaining != null && partialACKsRemaining.size() > 0) {
            int n4 = off;
            data[n4] = (byte)(data[n4] | 0x40);
        }
        ++off;
        if (ackIdsRemaining != null && ackIdsRemaining.size() > 0) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)ackIdsRemaining.size());
            ++off;
            for (int i = 0; i < ackIdsRemaining.size(); ++i) {
                Long ackId = (Long)ackIdsRemaining.get(i);
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)ackId);
                off += 4;
                if (msg != null) {
                    msg.append(" full ack: ").append(ackId);
                }
                acksIncluded = true;
            }
        }
        if (partialACKsRemaining != null && partialACKsRemaining.size() > 0) {
            int origNumRemaining = partialACKsRemaining.size();
            int numPartialOffset = off++;
            for (int i = 0; i < partialACKsRemaining.size(); ++i) {
                ACKBitfield bitfield = (ACKBitfield)partialACKsRemaining.get(i);
                if (bitfield.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bitfield.getMessageId());
                off += 4;
                int bits = bitfield.fragmentCount();
                int size = bits / 7 + 1;
                for (int curByte = 0; curByte < size; ++curByte) {
                    if (curByte + 1 < size) {
                        int n5 = off;
                        data[n5] = (byte)(data[n5] | 0xFFFFFF80);
                    }
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n6 = off;
                        data[n6] = (byte)(data[n6] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                partialACKsRemaining.remove(i);
                if (msg != null) {
                    msg.append(" partial ack: ").append(bitfield);
                }
                acksIncluded = true;
                --i;
            }
            DataHelper.toLong((byte[])data, (int)numPartialOffset, (int)1, (long)(origNumRemaining - partialACKsRemaining.size()));
        }
        if (msg != null && acksIncluded) {
            this._log.debug(msg.toString());
        }
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)1L);
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)state.getMessageId());
        int n7 = off += 4;
        data[n7] = (byte)(data[n7] | fragment << 1);
        if (fragment == state.getFragmentCount() - 1) {
            int n8 = off;
            data[n8] = (byte)(data[n8] | 1);
        }
        ++off;
        int size = state.fragmentSize(fragment);
        if (size < 0) {
            packet.release();
            return null;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)2, (long)size);
        int n9 = off;
        data[n9] = (byte)(data[n9] & 0x3F);
        int sizeWritten = state.writeFragment(data, off += 2, fragment);
        if (sizeWritten != size) {
            this._log.error("Size written: " + sizeWritten + " but size: " + size + " for fragment " + fragment + " of " + state.getMessageId());
            packet.release();
            return null;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Size written: " + sizeWritten + " for fragment " + fragment + " of " + state.getMessageId());
        }
        if ((size = sizeWritten) < 0) {
            packet.release();
            return null;
        }
        int padSize = 16 - (off += size) % 16;
        if (padSize > 0) {
            ByteArray block = _blockCache.acquire();
            this._context.random().nextBytes(block.getData());
            System.arraycopy(block.getData(), 0, data, off, padSize);
            _blockCache.release(block);
            off += padSize;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        this.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        if (this._log.shouldLog(20)) {
            this._log.info(msg.toString());
        }
        return packet;
    }

    public UDPPacket buildPing(PeerState peer) {
        return this.buildACK(peer, new ArrayList(0));
    }

    public UDPPacket buildACK(PeerState peer, List ackBitfields) {
        int i;
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        StringBuffer msg = null;
        if (this._log.shouldLog(10)) {
            msg = new StringBuffer(128);
            msg.append("building ACK packet to ").append(peer.getRemotePeer().toBase64().substring(0, 6));
        }
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        int n = off++;
        data[n] = (byte)(data[n] | 0x60);
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)now);
        off += 4;
        int fullACKCount = 0;
        int partialACKCount = 0;
        for (i = 0; i < ackBitfields.size(); ++i) {
            if (((ACKBitfield)ackBitfields.get(i)).receivedComplete()) {
                ++fullACKCount;
                continue;
            }
            ++partialACKCount;
        }
        if (fullACKCount > 0) {
            int n2 = off;
            data[n2] = (byte)(data[n2] | 0xFFFFFF80);
        }
        if (partialACKCount > 0) {
            int n3 = off;
            data[n3] = (byte)(data[n3] | 0x40);
        }
        ++off;
        if (fullACKCount > 0) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)fullACKCount);
            ++off;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bf = (ACKBitfield)ackBitfields.get(i);
                if (!bf.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bf.getMessageId());
                off += 4;
                if (msg == null) continue;
                msg.append(" full ack: ").append(bf.getMessageId());
            }
        }
        if (partialACKCount > 0) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)partialACKCount);
            ++off;
            for (i = 0; i < ackBitfields.size(); ++i) {
                ACKBitfield bitfield = (ACKBitfield)ackBitfields.get(i);
                if (bitfield.receivedComplete()) continue;
                DataHelper.toLong((byte[])data, (int)off, (int)4, (long)bitfield.getMessageId());
                off += 4;
                int bits = bitfield.fragmentCount();
                int size = bits / 7 + 1;
                for (int curByte = 0; curByte < size; ++curByte) {
                    if (curByte + 1 < size) {
                        int n4 = off;
                        data[n4] = (byte)(data[n4] | 0xFFFFFF80);
                    }
                    for (int curBit = 0; curBit < 7; ++curBit) {
                        if (!bitfield.received(curBit + 7 * curByte)) continue;
                        int n5 = off;
                        data[n5] = (byte)(data[n5] | (byte)(1 << curBit));
                    }
                    ++off;
                }
                if (msg == null) continue;
                msg.append(" partial ack: ").append(bitfield);
            }
        }
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)0L);
        ++off;
        if (msg != null) {
            this._log.debug(msg.toString());
        }
        if (off % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, peer.getCurrentCipherKey(), peer.getCurrentMACKey());
        this.setTo(packet, peer.getRemoteIPAddress(), peer.getRemotePort());
        return packet;
    }

    public UDPPacket buildSessionCreatedPacket(InboundEstablishState state, int externalPort, SessionKey ourIntroKey) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        state.prepareSessionCreated();
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 16;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        off += 4;
        byte[] sentIP = state.getSentIP();
        if (sentIP == null || sentIP.length <= 0 || this._transport != null && !this._transport.isValid(sentIP)) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did our sent IP become invalid? " + state);
            }
            state.fail();
            packet.release();
            return null;
        }
        System.arraycopy(state.getSentY(), 0, data, off, state.getSentY().length);
        DataHelper.toLong((byte[])data, (int)(off += state.getSentY().length), (int)1, (long)sentIP.length);
        System.arraycopy(sentIP, 0, data, ++off, sentIP.length);
        DataHelper.toLong((byte[])data, (int)(off += sentIP.length), (int)2, (long)state.getSentPort());
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)4, (long)state.getSentRelayTag());
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)state.getSentSignedOnTime());
        System.arraycopy(state.getSentSignature().getData(), 0, data, off += 4, 40);
        off += 40;
        long l = this._context.random().nextLong();
        if (l < 0L) {
            l = 0L - l;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)8, (long)l);
        off += 8;
        if (this._log.shouldLog(10)) {
            StringBuffer buf = new StringBuffer(128);
            buf.append("Sending sessionCreated:");
            buf.append(" AliceIP: ").append(Base64.encode((byte[])sentIP));
            buf.append(" AlicePort: ").append(state.getSentPort());
            buf.append(" BobIP: ").append(Base64.encode((byte[])state.getReceivedOurIP()));
            buf.append(" BobPort: ").append(externalPort);
            buf.append(" RelayTag: ").append(state.getSentRelayTag());
            buf.append(" SignedOn: ").append(state.getSentSignedOnTime());
            buf.append(" signature: ").append(Base64.encode((byte[])state.getSentSignature().getData()));
            buf.append("\nRawCreated: ").append(Base64.encode((byte[])data, (int)0, (int)off));
            buf.append("\nsignedTime: ").append(Base64.encode((byte[])data, (int)(off - 8 - 40 - 4), (int)4));
            this._log.debug(buf.toString());
        }
        ByteArray iv = _ivCache.acquire();
        this._context.random().nextBytes(iv.getData());
        int encrWrite = 48;
        int sigBegin = off - encrWrite;
        this._context.aes().encrypt(data, sigBegin, data, sigBegin, state.getCipherKey(), iv.getData(), encrWrite);
        if (off % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, ourIntroKey, ourIntroKey, iv);
        this.setTo(packet, to, state.getSentPort());
        _ivCache.release(iv);
        packet.setMessageType(53);
        return packet;
    }

    public UDPPacket buildSessionRequestPacket(OutboundEstablishState state) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] toIP = state.getSentIP();
        if (this._transport != null && !this._transport.isValid(toIP)) {
            packet.release();
            return null;
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(toIP);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 0;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending request with time = " + new Date(now * 1000L));
        }
        System.arraycopy(state.getSentX(), 0, data, off += 4, state.getSentX().length);
        DataHelper.toLong((byte[])data, (int)(off += state.getSentX().length), (int)1, (long)state.getSentIP().length);
        System.arraycopy(toIP, 0, data, ++off, state.getSentIP().length);
        DataHelper.toLong((byte[])data, (int)(off += toIP.length), (int)2, (long)state.getSentPort());
        if ((off += 2) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, state.getIntroKey(), state.getIntroKey());
        this.setTo(packet, to, state.getSentPort());
        packet.setMessageType(52);
        return packet;
    }

    public UDPPacket[] buildSessionConfirmedPackets(OutboundEstablishState state, RouterIdentity ourIdentity) {
        byte[] identity = ourIdentity.toByteArray();
        int numFragments = identity.length / 512;
        if (numFragments * 512 != identity.length) {
            ++numFragments;
        }
        UDPPacket[] packets = new UDPPacket[numFragments];
        for (int i = 0; i < numFragments; ++i) {
            packets[i] = this.buildSessionConfirmedPacket(state, i, numFragments, identity);
        }
        return packets;
    }

    public UDPPacket buildSessionConfirmedPacket(OutboundEstablishState state, int fragmentNum, int numFragments, byte[] identity) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(state.getSentIP());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(40)) {
                this._log.error("How did we think this was a valid IP?  " + state.getRemoteHostId().toString());
            }
            packet.release();
            return null;
        }
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 32;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        int n = off += 4;
        data[n] = (byte)(data[n] | fragmentNum << 4);
        int n2 = off++;
        data[n2] = (byte)(data[n2] | numFragments & 0xF);
        int curFragSize = 512;
        if (fragmentNum == numFragments - 1 && identity.length % 512 != 0) {
            curFragSize = identity.length % 512;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)2, (long)curFragSize);
        int curFragOffset = fragmentNum * 512;
        System.arraycopy(identity, curFragOffset, data, off += 2, curFragSize);
        off += curFragSize;
        if (fragmentNum == numFragments - 1) {
            DataHelper.toLong((byte[])data, (int)off, (int)4, (long)state.getSentSignedOnTime());
            int paddingRequired = 0;
            if (((off += 4) + 40) % 16 != 0) {
                paddingRequired += 16 - (off + 40) % 16;
            }
            for (int i = 0; i < paddingRequired; ++i) {
                data[off] = (byte)this._context.random().nextInt(255);
                ++off;
            }
            System.arraycopy(state.getSentSignature().getData(), 0, data, off, 40);
            packet.getPacket().setLength(off + 40);
            this.authenticate(packet, state.getCipherKey(), state.getMACKey());
        } else {
            if (off % 16 != 0) {
                off += 16 - off % 16;
            }
            packet.getPacket().setLength(off);
            this.authenticate(packet, state.getCipherKey(), state.getMACKey());
        }
        this.setTo(packet, to, state.getSentPort());
        packet.setMessageType(51);
        return packet;
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toIntroKey, long nonce, SessionKey aliceIntroKey) {
        return this.buildPeerTestFromAlice(toIP, toPort, toIntroKey, toIntroKey, nonce, aliceIntroKey);
    }

    public UDPPacket buildPeerTestFromAlice(InetAddress toIP, int toPort, SessionKey toCipherKey, SessionKey toMACKey, long nonce, SessionKey aliceIntroKey) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 112;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Bob with time = " + new Date(now * 1000L));
        }
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)nonce);
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)0L);
        DataHelper.toLong((byte[])data, (int)(++off), (int)2, (long)0L);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        if ((off += 32) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, toCipherKey, toMACKey);
        this.setTo(packet, toIP, toPort);
        packet.setMessageType(50);
        return packet;
    }

    public UDPPacket buildPeerTestToAlice(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, SessionKey charlieIntroKey, long nonce) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 112;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Alice with time = " + new Date(now * 1000L));
        }
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(charlieIntroKey.getData(), 0, data, off += 2, 32);
        if ((off += 32) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, aliceIntroKey, aliceIntroKey);
        this.setTo(packet, aliceIP, alicePort);
        packet.setMessageType(49);
        return packet;
    }

    public UDPPacket buildPeerTestToCharlie(InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, InetAddress charlieIP, int charliePort, SessionKey charlieCipherKey, SessionKey charlieMACKey) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 112;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Charlie with time = " + new Date(now * 1000L));
        }
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        if ((off += 32) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, charlieCipherKey, charlieMACKey);
        this.setTo(packet, charlieIP, charliePort);
        packet.setMessageType(48);
        return packet;
    }

    public UDPPacket buildPeerTestToBob(InetAddress bobIP, int bobPort, InetAddress aliceIP, int alicePort, SessionKey aliceIntroKey, long nonce, SessionKey bobCipherKey, SessionKey bobMACKey) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 112;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending peer test " + nonce + " to Bob with time = " + new Date(now * 1000L));
        }
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)nonce);
        byte[] ip = aliceIP.getAddress();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alicePort);
        System.arraycopy(aliceIntroKey.getData(), 0, data, off += 2, 32);
        if ((off += 32) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, bobCipherKey, bobMACKey);
        this.setTo(packet, bobIP, bobPort);
        packet.setMessageType(47);
        return packet;
    }

    private byte[] getOurExplicitIP() {
        return null;
    }

    private int getOurExplicitPort() {
        return 0;
    }

    public UDPPacket[] buildRelayRequest(UDPTransport transport, OutboundEstablishState state, SessionKey ourIntroKey) {
        UDPAddress addr = state.getRemoteAddress();
        int count = addr.getIntroducerCount();
        if (count <= 0) {
            return new UDPPacket[0];
        }
        UDPPacket[] rv = new UDPPacket[count];
        for (int i = 0; i < count; ++i) {
            InetAddress iaddr = addr.getIntroducerHost(i);
            int iport = addr.getIntroducerPort(i);
            byte[] ikey = addr.getIntroducerKey(i);
            long tag = addr.getIntroducerTag(i);
            if (ikey == null || iport <= 0 || iaddr == null || tag <= 0L) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Cannot build a relay request to " + state.getRemoteIdentity().calculateHash().toBase64() + ", as their UDP address is invalid: addr=" + addr + " index=" + i);
                continue;
            }
            if (!transport.isValid(iaddr.getAddress())) continue;
            rv[i] = this.buildRelayRequest(iaddr, iport, ikey, tag, ourIntroKey, state.getIntroNonce(), true);
        }
        return rv;
    }

    public UDPPacket buildRelayRequest(InetAddress introHost, int introPort, byte[] introKey, long introTag, SessionKey ourIntroKey, long introNonce, boolean encrypt) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        byte[] ourIP = this.getOurExplicitIP();
        int ourPort = this.getOurExplicitPort();
        data[off] = 48;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(20)) {
            this._log.info("Sending intro relay request to " + introHost + ":" + introPort);
        }
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)4, (long)introTag);
        off += 4;
        if (ourIP != null) {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)ourIP.length);
            System.arraycopy(ourIP, 0, data, ++off, ourIP.length);
            off += ourIP.length;
        } else {
            DataHelper.toLong((byte[])data, (int)off, (int)1, (long)0L);
            ++off;
        }
        DataHelper.toLong((byte[])data, (int)off, (int)2, (long)ourPort);
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)0L);
        ++off;
        System.arraycopy(ourIntroKey.getData(), 0, data, off += 0, 32);
        off += 32;
        if (this._log.shouldLog(10)) {
            this._log.debug("wrote alice intro key: " + Base64.encode((byte[])data, (int)(off - 32), (int)32) + " with nonce " + introNonce + " size=" + (off + 4 + (16 - (off + 4) % 16)) + " and data: " + Base64.encode((byte[])data, (int)0, (int)off));
        }
        DataHelper.toLong((byte[])data, (int)off, (int)4, (long)introNonce);
        if ((off += 4) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        if (encrypt) {
            this.authenticate(packet, new SessionKey(introKey), new SessionKey(introKey));
        }
        this.setTo(packet, introHost, introPort);
        packet.setMessageType(46);
        return packet;
    }

    public UDPPacket buildRelayIntro(RemoteHostId alice, PeerState charlie, UDPPacketReader.RelayRequestReader request) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 80;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        if (this._log.shouldLog(20)) {
            this._log.info("Sending intro to " + charlie + " for " + alice);
        }
        byte[] ip = alice.getIP();
        DataHelper.toLong((byte[])data, (int)(off += 4), (int)1, (long)ip.length);
        System.arraycopy(ip, 0, data, ++off, ip.length);
        DataHelper.toLong((byte[])data, (int)(off += ip.length), (int)2, (long)alice.getPort());
        int sz = request.readChallengeSize();
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)sz);
        ++off;
        if (sz > 0) {
            request.readChallengeSize(data, off);
            off += sz;
        }
        if (off % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, charlie.getCurrentCipherKey(), charlie.getCurrentMACKey());
        this.setTo(packet, charlie.getRemoteIPAddress(), charlie.getRemotePort());
        packet.setMessageType(45);
        return packet;
    }

    public UDPPacket buildRelayResponse(RemoteHostId alice, PeerState charlie, long nonce, SessionKey aliceIntroKey) {
        InetAddress aliceAddr = null;
        try {
            aliceAddr = InetAddress.getByAddress(alice.getIP());
        }
        catch (UnknownHostException uhe) {
            return null;
        }
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        data[off] = 64;
        long now = this._context.clock().now() / 1000L;
        DataHelper.toLong((byte[])data, (int)(++off), (int)4, (long)now);
        off += 4;
        if (this._log.shouldLog(20)) {
            this._log.info("Sending relay response to " + alice + " for " + charlie + " with alice's intro key " + aliceIntroKey.toBase64());
        }
        byte[] charlieIP = charlie.getRemoteIP();
        DataHelper.toLong((byte[])data, (int)off, (int)1, (long)charlieIP.length);
        System.arraycopy(charlieIP, 0, data, ++off, charlieIP.length);
        DataHelper.toLong((byte[])data, (int)(off += charlieIP.length), (int)2, (long)charlie.getRemotePort());
        byte[] aliceIP = alice.getIP();
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)1, (long)aliceIP.length);
        System.arraycopy(aliceIP, 0, data, ++off, aliceIP.length);
        DataHelper.toLong((byte[])data, (int)(off += aliceIP.length), (int)2, (long)alice.getPort());
        DataHelper.toLong((byte[])data, (int)(off += 2), (int)4, (long)nonce);
        if ((off += 4) % 16 != 0) {
            off += 16 - off % 16;
        }
        packet.getPacket().setLength(off);
        this.authenticate(packet, aliceIntroKey, aliceIntroKey);
        this.setTo(packet, aliceAddr, alice.getPort());
        packet.setMessageType(44);
        return packet;
    }

    public UDPPacket buildHolePunch(UDPPacketReader reader) {
        UDPPacket packet = UDPPacket.acquire(this._context, false);
        byte[] data = packet.getPacket().getData();
        Arrays.fill(data, 0, data.length, (byte)0);
        int off = 32;
        int ipSize = reader.getRelayIntroReader().readIPSize();
        byte[] ip = new byte[ipSize];
        reader.getRelayIntroReader().readIP(ip, 0);
        int port = reader.getRelayIntroReader().readPort();
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IP for alice to hole punch to is invalid", (Throwable)uhe);
            }
            packet.release();
            return null;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Sending relay hole punch to " + to + ":" + port);
        }
        packet.getPacket().setLength(0);
        this.setTo(packet, to, port);
        packet.setMessageType(43);
        return packet;
    }

    private void setTo(UDPPacket packet, InetAddress ip, int port) {
        packet.getPacket().setAddress(ip);
        packet.getPacket().setPort(port);
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey) {
        ByteArray iv = _ivCache.acquire();
        this._context.random().nextBytes(iv.getData());
        this.authenticate(packet, cipherKey, macKey, iv);
        _ivCache.release(iv);
    }

    private void authenticate(UDPPacket packet, SessionKey cipherKey, SessionKey macKey, ByteArray iv) {
        long before = System.currentTimeMillis();
        int encryptOffset = packet.getPacket().getOffset() + 16 + 16;
        int encryptSize = packet.getPacket().getLength() - 16 - 16 - packet.getPacket().getOffset();
        byte[] data = packet.getPacket().getData();
        this._context.aes().encrypt(data, encryptOffset, data, encryptOffset, cipherKey, iv.getData(), encryptSize);
        int off = packet.getPacket().getOffset();
        System.arraycopy(data, encryptOffset, data, off, encryptSize);
        System.arraycopy(iv.getData(), 0, data, off += encryptSize, 16);
        DataHelper.toLong((byte[])data, (int)(off += 16), (int)2, (long)(encryptSize ^ 0));
        int hmacOff = packet.getPacket().getOffset();
        int hmacLen = encryptSize + 16 + 2;
        ByteArray ba = _hmacCache.acquire();
        this._context.hmac().calculate(macKey, data, hmacOff, hmacLen, ba.getData(), 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("Authenticating " + packet.getPacket().getLength() + "\nIV: " + Base64.encode((byte[])iv.getData()) + "\nraw mac: " + Base64.encode((byte[])ba.getData()) + "\nMAC key: " + macKey.toBase64());
        }
        System.arraycopy(data, hmacOff, data, encryptOffset, encryptSize);
        System.arraycopy(ba.getData(), 0, data, hmacOff, 16);
        System.arraycopy(iv.getData(), 0, data, hmacOff + 16, 16);
        _hmacCache.release(ba);
        long timeToAuth = System.currentTimeMillis() - before;
        this._context.statManager().addRateData("udp.packetAuthTime", timeToAuth, timeToAuth);
        if (timeToAuth > 100L) {
            this._context.statManager().addRateData("udp.packetAuthTimeSlow", timeToAuth, timeToAuth);
        }
    }
}

