/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.File;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.i2p.data.ByteArray;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.UDPEndpoint;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

public class UDPEndpointTest {
    private RouterContext _context;
    private Log _log;
    private UDPEndpoint[] _endpoints;
    private boolean _beginTest;
    private List _sentNotReceived;

    public UDPEndpointTest(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(UDPEndpointTest.class);
        this._sentNotReceived = Collections.synchronizedList(new ArrayList(1000));
    }

    public void runTest(int numPeers) {
        this._log.debug("Run test(" + numPeers + ")");
        try {
            this._endpoints = new UDPEndpoint[numPeers];
            int base = 2000 + this._context.random().nextInt(10000);
            for (int i = 0; i < numPeers; ++i) {
                UDPEndpoint endpoint;
                this._log.debug("Building " + i);
                this._endpoints[i] = endpoint = new UDPEndpoint(this._context, null, base + i, null);
                endpoint.startup();
                I2PThread read = new I2PThread((Runnable)new TestRead(endpoint), "Test read " + i);
                I2PThread write = new I2PThread((Runnable)new TestWrite(endpoint), "Test write " + i);
                read.start();
                write.start();
            }
        }
        catch (SocketException se) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error initializing", (Throwable)se);
            }
            return;
        }
        this._beginTest = true;
        this._log.debug("Test begin");
    }

    public static void main(String[] args) {
        try {
            System.out.println("Current dir: " + new File(".").getCanonicalPath());
        }
        catch (Exception e) {
            // empty catch block
        }
        new File("udpEndpointTest.stats").delete();
        Properties props = new Properties();
        props.setProperty("stat.logFile", "udpEndpointTest.stats");
        props.setProperty("stat.logFilters", "*");
        UDPEndpointTest test = new UDPEndpointTest(new RouterContext(null, props));
        test.runTest(2);
    }

    private class TestWrite
    implements Runnable {
        private UDPEndpoint _endpoint;

        public TestWrite(UDPEndpoint peer) {
            this._endpoint = peer;
        }

        public void run() {
            while (!UDPEndpointTest.this._beginTest) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {}
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            UDPEndpointTest.this._log.debug("Beginning to write");
            int curPacket = 0;
            if (curPacket < 10000) {
                byte[] data = new byte[1024];
                UDPEndpointTest.this._context.random().nextBytes(data);
                int curPeer = curPacket % UDPEndpointTest.this._endpoints.length;
                if (UDPEndpointTest.this._endpoints[curPeer] == this._endpoint) {
                    ++curPeer;
                }
                if (curPeer >= UDPEndpointTest.this._endpoints.length) {
                    curPeer = 0;
                }
                boolean priority = true;
                long expiration = -1L;
                UDPPacket packet = UDPPacket.acquire(UDPEndpointTest.this._context, true);
                throw new RuntimeException("fixme");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private class TestRead
    implements Runnable {
        private UDPEndpoint _endpoint;

        public TestRead(UDPEndpoint peer) {
            this._endpoint = peer;
        }

        public void run() {
            while (!UDPEndpointTest.this._beginTest) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            UDPEndpointTest.this._log.debug("Beginning to read");
            long start = System.currentTimeMillis();
            int received = 0;
            while (true) {
                UDPPacket packet = this._endpoint.receive();
                ByteArray ba = new ByteArray(packet.getPacket().getData(), 0, packet.getPacket().getLength());
                boolean removed = UDPEndpointTest.this._sentNotReceived.remove(ba);
                int outstanding = UDPEndpointTest.this._sentNotReceived.size();
                if (!removed) {
                    UDPEndpointTest.this._log.error("Received a packet that we weren't expecting: " + packet);
                } else {
                    UDPEndpointTest.this._log.debug("Received an expected packet (" + received + ") with outstanding: " + outstanding);
                    ++received;
                }
                if (received % 10000 == 0) {
                    long time = System.currentTimeMillis() - start;
                    UDPEndpointTest.this._log.debug("Received " + received + " in " + time);
                }
                packet.release();
            }
        }
    }
}

