/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.util.ByteCache;
import net.i2p.util.DecayingBloomFilter;

public class BloomFilterIVValidator
implements IVValidator {
    private I2PAppContext _context;
    private DecayingBloomFilter _filter;
    private ByteCache _ivXorCache = ByteCache.getInstance((int)32, (int)16);
    private static final int HALFLIFE_MS = 600000;

    public BloomFilterIVValidator(I2PAppContext ctx, int KBps) {
        this._context = ctx;
        this._filter = new DecayingBloomFilter(ctx, 600000, 16);
        ctx.statManager().createRateStat("tunnel.duplicateIV", "Note that a duplicate IV was received", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
    }

    public boolean receiveIV(byte[] ivData, int ivOffset, byte[] payload, int payloadOffset) {
        ByteArray buf = this._ivXorCache.acquire();
        DataHelper.xor((byte[])ivData, (int)ivOffset, (byte[])payload, (int)payloadOffset, (byte[])buf.getData(), (int)0, (int)16);
        boolean dup = this._filter.add(buf.getData());
        this._ivXorCache.release(buf);
        if (dup) {
            this._context.statManager().addRateData("tunnel.duplicateIV", 1L, 1L);
        }
        return !dup;
    }

    public void destroy() {
        this._filter.stopDecaying();
    }
}

