/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageHandler;
import net.i2p.router.tunnel.FragmentedMessage;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class FragmentHandler {
    private I2PAppContext _context;
    private Log _log;
    private Map _fragmentedMessages;
    private DefragmentedReceiver _receiver;
    private int _completed;
    private int _failed;
    static long MAX_DEFRAGMENT_TIME = 60000L;
    private static final ByteCache _cache = ByteCache.getInstance((int)512, (int)1024);
    private static final ByteCache _validateCache = ByteCache.getInstance((int)512, (int)1024);
    static final byte MASK_IS_SUBSEQUENT = -128;
    static final byte MASK_TYPE = 96;
    static final byte MASK_FRAGMENTED = 8;
    static final byte MASK_EXTENDED = 4;
    private static final int MASK_FRAGMENT_NUM = 126;
    static final short TYPE_LOCAL = 0;
    static final short TYPE_TUNNEL = 1;
    static final short TYPE_ROUTER = 2;

    public FragmentHandler(I2PAppContext context, DefragmentedReceiver receiver) {
        this._context = context;
        this._log = context.logManager().getLog(FragmentHandler.class);
        this._fragmentedMessages = new HashMap(4);
        this._receiver = receiver;
        this._context.statManager().createRateStat("tunnel.smallFragments", "How many pad bytes are in small fragments?", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.fullFragments", "How many tunnel messages use the full data area?", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.fragmentedComplete", "How many fragments were in a completely received message?", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.fragmentedDropped", "How many fragments were in a partially received yet failed message?", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
        this._context.statManager().createRateStat("tunnel.corruptMessage", "How many corrupted messages arrived?", "Tunnels", new long[]{600000L, 3600000L, 10800000L, 86400000L});
    }

    public void receiveTunnelMessage(byte[] preprocessed, int offset, int length) {
        boolean ok = this.verifyPreprocessed(preprocessed, offset, length);
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Unable to verify preprocessed data (pre.length=" + preprocessed.length + " off=" + offset + " len=" + length);
            }
            _cache.release(new ByteArray(preprocessed));
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
            return;
        }
        offset += 16;
        offset += 4;
        int padding = 0;
        while (preprocessed[offset] != 0) {
            ++offset;
            ++padding;
        }
        ++offset;
        if (this._log.shouldLog(10)) {
            this._log.debug("Fragments begin at offset=" + offset + " padding=" + padding);
        }
        try {
            while (offset < length) {
                int off = this.receiveFragment(preprocessed, offset, length);
                if (off < 0) {
                    this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
                    return;
                }
                offset = off;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
        }
        catch (NullPointerException npe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Corrupt fragment received: offset = " + offset, (Throwable)npe);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
        }
        catch (RuntimeException e) {
            if (this._log.shouldLog(40)) {
                this._log.error("Corrupt fragment received: offset = " + offset, (Throwable)e);
            }
            this._context.statManager().addRateData("tunnel.corruptMessage", 1L, 1L);
            throw e;
        }
        finally {
            _cache.release(new ByteArray(preprocessed));
        }
    }

    public int getCompleteCount() {
        return this._completed;
    }

    public int getFailedCount() {
        return this._failed;
    }

    private boolean verifyPreprocessed(byte[] preprocessed, int offset, int length) {
        Hash v;
        boolean eq;
        int paddingEnd = 20;
        while (preprocessed[offset + paddingEnd] != 0) {
            if (offset + ++paddingEnd < length) continue;
            if (this._log.shouldLog(30)) {
                this._log.warn("cannot verify, going past the end [off=" + offset + " len=" + length + " paddingEnd=" + paddingEnd + " data:\n" + Base64.encode((byte[])preprocessed, (int)offset, (int)length));
            }
            return false;
        }
        ByteArray ba = _validateCache.acquire();
        byte[] preV = ba.getData();
        int validLength = length - offset - ++paddingEnd + 16;
        System.arraycopy(preprocessed, offset + paddingEnd, preV, 0, validLength - 16);
        System.arraycopy(preprocessed, 0, preV, validLength - 16, 16);
        if (this._log.shouldLog(10)) {
            this._log.debug("endpoint IV: " + Base64.encode((byte[])preV, (int)(validLength - 16), (int)16));
        }
        if (!(eq = DataHelper.eq((byte[])(v = this._context.sha().calculateHash(preV, 0, validLength)).getData(), (int)0, (byte[])preprocessed, (int)(offset + 16), (int)4))) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Corrupt tunnel message - verification fails: \n" + Base64.encode((byte[])preprocessed, (int)(offset + 16), (int)4) + "\n" + Base64.encode((byte[])v.getData(), (int)0, (int)4));
            }
            if (this._log.shouldLog(30)) {
                this._log.warn("nomatching endpoint: # pad bytes: " + (paddingEnd - 20 - 1) + "\n" + " offset=" + offset + " length=" + length + " paddingEnd=" + paddingEnd + Base64.encode((byte[])preprocessed, (int)offset, (int)length));
            }
        }
        _validateCache.release(ba);
        if (eq) {
            int excessPadding = paddingEnd - 21;
            if (excessPadding > 0) {
                this._context.statManager().addRateData("tunnel.smallFragments", (long)excessPadding, 0L);
            } else {
                this._context.statManager().addRateData("tunnel.fullFragments", 1L, 0L);
            }
        }
        return eq;
    }

    private int receiveFragment(byte[] preprocessed, int offset, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("CONTROL: " + Integer.toHexString(preprocessed[offset]) + " / " + "/" + Base64.encode((byte[])preprocessed, (int)offset, (int)1) + " at offset " + offset);
        }
        if (0 == (preprocessed[offset] & 0xFFFFFF80)) {
            return this.receiveInitialFragment(preprocessed, offset, length);
        }
        return this.receiveSubsequentFragment(preprocessed, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveInitialFragment(byte[] preprocessed, int offset, int length) {
        boolean ok;
        if (this._log.shouldLog(10)) {
            this._log.debug("initial begins at " + offset + " for " + length);
        }
        int type = (preprocessed[offset] & 0x60) >>> 5;
        boolean fragmented = 0 != (preprocessed[offset] & 8);
        boolean extended = 0 != (preprocessed[offset] & 4);
        ++offset;
        TunnelId tunnelId = null;
        Hash router = null;
        long messageId = -1L;
        if (type == 1) {
            if (offset + 4 >= preprocessed.length) {
                return -1;
            }
            long id = DataHelper.fromLong((byte[])preprocessed, (int)offset, (int)4);
            tunnelId = new TunnelId(id);
            offset += 4;
        }
        if (type == 2 || type == 1) {
            byte[] h = new byte[32];
            if (offset + 32 >= preprocessed.length) {
                return -1;
            }
            System.arraycopy(preprocessed, offset, h, 0, 32);
            router = new Hash(h);
            offset += 32;
        }
        if (fragmented) {
            if (offset + 4 >= preprocessed.length) {
                return -1;
            }
            messageId = DataHelper.fromLong((byte[])preprocessed, (int)offset, (int)4);
            if (this._log.shouldLog(10)) {
                this._log.debug("reading messageId " + messageId + " at offset " + offset + " type = " + type + " router = " + (router != null ? router.toBase64().substring(0, 4) : "n/a") + " tunnelId = " + tunnelId);
            }
            offset += 4;
        }
        if (extended) {
            int extendedSize = (int)DataHelper.fromLong((byte[])preprocessed, (int)offset, (int)1);
            ++offset;
            offset += extendedSize;
        }
        if (offset + 2 >= preprocessed.length) {
            return -1;
        }
        int size = (int)DataHelper.fromLong((byte[])preprocessed, (int)offset, (int)2);
        offset += 2;
        boolean isNew = false;
        FragmentedMessage msg = null;
        if (fragmented) {
            Map map = this._fragmentedMessages;
            synchronized (map) {
                msg = (FragmentedMessage)this._fragmentedMessages.get(new Long(messageId));
                if (msg == null) {
                    msg = new FragmentedMessage(this._context);
                    this._fragmentedMessages.put(new Long(messageId), msg);
                    isNew = true;
                }
            }
        } else {
            msg = new FragmentedMessage(this._context);
        }
        if (!(ok = msg.receive(messageId, preprocessed, offset, size, !fragmented, router, tunnelId))) {
            return -1;
        }
        if (msg.isComplete()) {
            if (fragmented) {
                Map map = this._fragmentedMessages;
                synchronized (map) {
                    this._fragmentedMessages.remove(new Long(messageId));
                }
            }
            if (msg.getExpireEvent() != null) {
                SimpleTimer.getInstance().removeEvent(msg.getExpireEvent());
            }
            this.receiveComplete(msg);
        } else {
            this.noteReception(msg.getMessageId(), 0, msg);
        }
        if (isNew && fragmented && !msg.isComplete()) {
            RemoveFailed evt = new RemoveFailed(msg);
            msg.setExpireEvent(evt);
            if (this._log.shouldLog(10)) {
                this._log.debug("In " + MAX_DEFRAGMENT_TIME + " dropping " + messageId);
            }
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)evt, MAX_DEFRAGMENT_TIME);
        }
        offset += size;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling finished message " + msg.getMessageId() + " at offset " + offset);
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receiveSubsequentFragment(byte[] preprocessed, int offset, int length) {
        if (this._log.shouldLog(10)) {
            this._log.debug("subsequent begins at " + offset + " for " + length);
        }
        int fragmentNum = (preprocessed[offset] & 0x7E) >>> 1;
        boolean isLast = 0 != (preprocessed[offset] & 1);
        long messageId = DataHelper.fromLong((byte[])preprocessed, (int)(++offset), (int)4);
        int size = (int)DataHelper.fromLong((byte[])preprocessed, (int)(offset += 4), (int)2);
        offset += 2;
        if (messageId < 0L) {
            throw new RuntimeException("Preprocessed message was invalid [messageId =" + messageId + " size=" + size + " offset=" + offset + " fragment=" + fragmentNum);
        }
        boolean isNew = false;
        FragmentedMessage msg = null;
        Map map = this._fragmentedMessages;
        synchronized (map) {
            msg = (FragmentedMessage)this._fragmentedMessages.get(new Long(messageId));
            if (msg == null) {
                msg = new FragmentedMessage(this._context);
                this._fragmentedMessages.put(new Long(messageId), msg);
                isNew = true;
            }
        }
        boolean ok = msg.receive(messageId, fragmentNum, preprocessed, offset, size, isLast);
        if (!ok) {
            return -1;
        }
        if (msg.isComplete()) {
            Map map2 = this._fragmentedMessages;
            synchronized (map2) {
                this._fragmentedMessages.remove(new Long(messageId));
            }
            if (msg.getExpireEvent() != null) {
                SimpleTimer.getInstance().removeEvent(msg.getExpireEvent());
            }
            this._context.statManager().addRateData("tunnel.fragmentedComplete", (long)msg.getFragmentCount(), msg.getLifetime());
            this.receiveComplete(msg);
        } else {
            this.noteReception(msg.getMessageId(), fragmentNum, msg);
        }
        if (isNew && !msg.isComplete()) {
            RemoveFailed evt = new RemoveFailed(msg);
            msg.setExpireEvent(evt);
            if (this._log.shouldLog(10)) {
                this._log.debug("In " + MAX_DEFRAGMENT_TIME + " dropping " + msg.getMessageId() + "/" + fragmentNum);
            }
            SimpleTimer.getInstance().addEvent((SimpleTimer.TimedEvent)evt, MAX_DEFRAGMENT_TIME);
        }
        return offset += size;
    }

    private void receiveComplete(FragmentedMessage msg) {
        block9: {
            if (msg == null) {
                return;
            }
            ++this._completed;
            String stringified = null;
            if (this._log.shouldLog(10)) {
                stringified = msg.toString();
            }
            try {
                int fragmentCount = msg.getFragmentCount();
                byte[] data = msg.toByteArray();
                if (this._log.shouldLog(10)) {
                    this._log.debug("RECV(" + data.length + "): " + Base64.encode((byte[])data) + " " + this._context.sha().calculateHash(data).toBase64());
                }
                I2NPMessage m = new I2NPMessageHandler(this._context).readMessage(data);
                this.noteReception(m.getUniqueId(), fragmentCount - 1, "complete: ");
                this.noteCompletion(m.getUniqueId());
                this._receiver.receiveComplete(m, msg.getTargetRouter(), msg.getTargetTunnel());
            }
            catch (IOException ioe) {
                if (stringified == null) {
                    stringified = msg.toString();
                }
                if (this._log.shouldLog(40)) {
                    this._log.error("Error receiving fragmented message (corrupt?): " + stringified, (Throwable)ioe);
                }
            }
            catch (I2NPMessageException ime) {
                if (stringified == null) {
                    stringified = msg.toString();
                }
                if (!this._log.shouldLog(40)) break block9;
                this._log.error("Error receiving fragmented message (corrupt?): " + stringified, (Throwable)((Object)ime));
            }
        }
    }

    protected void noteReception(long messageId, int fragmentId, Object status) {
    }

    protected void noteCompletion(long messageId) {
    }

    protected void noteFailure(long messageId, String status) {
    }

    private class RemoveFailed
    implements SimpleTimer.TimedEvent {
        private FragmentedMessage _msg;

        public RemoveFailed(FragmentedMessage msg) {
            this._msg = msg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeReached() {
            boolean removed = false;
            Map map = FragmentHandler.this._fragmentedMessages;
            synchronized (map) {
                removed = null != FragmentHandler.this._fragmentedMessages.remove(new Long(this._msg.getMessageId()));
            }
            if (removed && !this._msg.getReleased()) {
                FragmentHandler.this._failed++;
                FragmentHandler.this.noteFailure(this._msg.getMessageId(), this._msg.toString());
                if (FragmentHandler.this._log.shouldLog(30)) {
                    FragmentHandler.this._log.warn("Dropped failed fragmented message: " + this._msg);
                }
                FragmentHandler.this._context.statManager().addRateData("tunnel.fragmentedDropped", (long)this._msg.getFragmentCount(), this._msg.getLifetime());
                this._msg.failed();
            }
        }
    }

    public static interface DefragmentedReceiver {
        public void receiveComplete(I2NPMessage var1, Hash var2, TunnelId var3);
    }
}

