/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.Map;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.TunnelId;
import net.i2p.router.tunnel.TunnelCreatorConfig;

public class HopConfig {
    private byte[] _receiveTunnelId = null;
    private TunnelId _receiveTunnel;
    private Hash _receiveFrom = null;
    private byte[] _sendTunnelId = null;
    private TunnelId _sendTunnel;
    private Hash _sendTo = null;
    private SessionKey _layerKey = null;
    private SessionKey _ivKey = null;
    private SessionKey _replyKey;
    private ByteArray _replyIV;
    private long _creation = -1L;
    private long _expiration = -1L;
    private Map _options = null;
    private long _messagesProcessed = 0L;
    private long _oldMessagesProcessed = 0L;
    private long _messagesSent = 0L;
    private long _oldMessagesSent = 0L;
    public static final int REPLY_IV_LENGTH = 16;

    public byte[] getReceiveTunnelId() {
        return this._receiveTunnelId;
    }

    public TunnelId getReceiveTunnel() {
        if (this._receiveTunnel == null) {
            this._receiveTunnel = this.getTunnel(this._receiveTunnelId);
        }
        return this._receiveTunnel;
    }

    public void setReceiveTunnelId(byte[] id) {
        this._receiveTunnelId = id;
    }

    public void setReceiveTunnelId(TunnelId id) {
        this._receiveTunnelId = DataHelper.toLong((int)4, (long)id.getTunnelId());
    }

    public Hash getReceiveFrom() {
        return this._receiveFrom;
    }

    public void setReceiveFrom(Hash from) {
        this._receiveFrom = from;
    }

    public byte[] getSendTunnelId() {
        return this._sendTunnelId;
    }

    public TunnelId getSendTunnel() {
        if (this._sendTunnel == null) {
            this._sendTunnel = this.getTunnel(this._sendTunnelId);
        }
        return this._sendTunnel;
    }

    public void setSendTunnelId(byte[] id) {
        this._sendTunnelId = id;
    }

    private TunnelId getTunnel(byte[] id) {
        if (id == null) {
            return null;
        }
        return new TunnelId(DataHelper.fromLong((byte[])id, (int)0, (int)id.length));
    }

    public Hash getSendTo() {
        return this._sendTo;
    }

    public void setSendTo(Hash to) {
        this._sendTo = to;
    }

    public SessionKey getLayerKey() {
        return this._layerKey;
    }

    public void setLayerKey(SessionKey key) {
        this._layerKey = key;
    }

    public SessionKey getIVKey() {
        return this._ivKey;
    }

    public void setIVKey(SessionKey key) {
        this._ivKey = key;
    }

    public SessionKey getReplyKey() {
        return this._replyKey;
    }

    public void setReplyKey(SessionKey key) {
        this._replyKey = key;
    }

    public ByteArray getReplyIV() {
        return this._replyIV;
    }

    public void setReplyIV(ByteArray iv) {
        this._replyIV = iv;
    }

    public long getExpiration() {
        return this._expiration;
    }

    public void setExpiration(long when) {
        this._expiration = when;
    }

    public long getCreation() {
        return this._creation;
    }

    public void setCreation(long when) {
        this._creation = when;
    }

    public Map getOptions() {
        return this._options;
    }

    public void setOptions(Map options) {
        this._options = options;
    }

    public void incrementProcessedMessages() {
        ++this._messagesProcessed;
    }

    public long getProcessedMessagesCount() {
        return this._messagesProcessed;
    }

    public long getRecentMessagesCount() {
        long rv = this._messagesProcessed - this._oldMessagesProcessed;
        this._oldMessagesProcessed = this._messagesProcessed;
        return rv;
    }

    public void incrementSentMessages() {
        ++this._messagesSent;
    }

    public long getSentMessagesCount() {
        return this._messagesSent;
    }

    public long getRecentSentMessagesCount() {
        long rv = this._messagesSent - this._oldMessagesSent;
        this._oldMessagesSent = this._messagesSent;
        return rv;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        if (this._receiveTunnelId != null) {
            buf.append("recv on ");
            buf.append(DataHelper.fromLong((byte[])this._receiveTunnelId, (int)0, (int)4));
            buf.append(" ");
        }
        if (this._sendTo != null) {
            buf.append("send to ").append(this._sendTo.toBase64().substring(0, 4)).append(":");
            if (this._sendTunnelId != null) {
                buf.append(DataHelper.fromLong((byte[])this._sendTunnelId, (int)0, (int)4));
            }
        }
        buf.append(" expiring on ").append(TunnelCreatorConfig.format(this._expiration));
        buf.append(" having transferred ").append(this._messagesProcessed).append("KB");
        return buf.toString();
    }
}

