/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundMessageDistributor;
import net.i2p.router.tunnel.RouterFragmentHandler;
import net.i2p.util.Log;

public class TunnelParticipant {
    private RouterContext _context;
    private Log _log;
    private HopConfig _config;
    private HopProcessor _processor;
    private InboundEndpointProcessor _inboundEndpointProcessor;
    private InboundMessageDistributor _inboundDistributor;
    private FragmentHandler _handler;
    private RouterInfo _nextHopCache;
    private int _periodMessagesTransferred;
    private long _lastCoallesced = System.currentTimeMillis();

    public TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this(ctx, config, processor, null);
    }

    public TunnelParticipant(RouterContext ctx, InboundEndpointProcessor inEndProc) {
        this(ctx, null, null, inEndProc);
    }

    private TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor, InboundEndpointProcessor inEndProc) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelParticipant.class);
        this._config = config;
        this._processor = processor;
        if (config == null || config.getSendTo() == null) {
            this._handler = new RouterFragmentHandler(ctx, (FragmentHandler.DefragmentedReceiver)new DefragmentedHandler());
        }
        this._inboundEndpointProcessor = inEndProc;
        if (inEndProc != null) {
            this._inboundDistributor = new InboundMessageDistributor(ctx, inEndProc.getDestination());
        }
        if (this._config != null && this._config.getSendTo() != null) {
            this._nextHopCache = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            if (this._nextHopCache == null) {
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new Found(this._context), null, 60000L);
            }
        }
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        boolean ok = false;
        if (this._processor != null) {
            ok = this._processor.process(msg.getData(), 0, msg.getData().length, recvFrom);
        } else if (this._inboundEndpointProcessor != null) {
            ok = this._inboundEndpointProcessor.retrievePreprocessedData(msg.getData(), 0, msg.getData().length, recvFrom);
        }
        if (!ok) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Failed to dispatch " + msg + ": processor=" + this._processor + " inboundEndpoint=" + this._inboundEndpointProcessor);
            }
            return;
        }
        if (this._config != null && this._config.getSendTo() != null) {
            this._config.incrementProcessedMessages();
            RouterInfo ri = this._nextHopCache;
            if (ri == null) {
                ri = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            }
            if (ri != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Send off to nextHop directly (" + this._config.getSendTo().toBase64().substring(0, 4) + " for " + msg);
                }
                this.send(this._config, msg, ri);
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Lookup the nextHop (" + this._config.getSendTo().toBase64().substring(0, 4) + " for " + msg);
                }
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new SendJob(this._context, msg), new TimeoutJob(this._context, msg), 10000L);
            }
        } else {
            this._inboundEndpointProcessor.getConfig().incrementProcessedMessages();
            if (this._log.shouldLog(10)) {
                this._log.debug("Receive fragment: on " + this._config + ": " + msg);
            }
            this._handler.receiveTunnelMessage(msg.getData(), 0, msg.getData().length);
        }
    }

    public int getCompleteCount() {
        if (this._handler != null) {
            return this._handler.getCompleteCount();
        }
        return 0;
    }

    public int getFailedCount() {
        if (this._handler != null) {
            return this._handler.getFailedCount();
        }
        return 0;
    }

    private void send(HopConfig config, TunnelDataMessage msg, RouterInfo ri) {
        if (this._context.tunnelDispatcher().shouldDropParticipatingMessage()) {
            return;
        }
        this._config.incrementSentMessages();
        long oldId = msg.getUniqueId();
        long newId = this._context.random().nextLong(0xFFFFFFFFL);
        this._context.messageHistory().wrap("TunnelDataMessage", oldId, "TunnelDataMessage", newId);
        msg.setUniqueId(newId);
        msg.setMessageExpiration(this._context.clock().now() + 10000L);
        OutNetMessage m = new OutNetMessage(this._context);
        msg.setTunnelId(config.getSendTunnel());
        m.setMessage(msg);
        m.setExpiration(msg.getMessageExpiration());
        m.setTarget(ri);
        m.setPriority(200);
        if (this._log.shouldLog(10)) {
            this._log.debug("Forward on from " + this._config + ": " + msg);
        }
        this._context.outNetMessagePool().add(m);
    }

    public String toString() {
        if (this._config != null) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("participant at ").append(this._config.toString());
            return buf.toString();
        }
        return "inbound endpoint";
    }

    private class TimeoutJob
    extends JobImpl {
        private TunnelDataMessage _msg;

        public TimeoutJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        public String getName() {
            return "timeout looking for next hop info";
        }

        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                return;
            }
            RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
            if (ri != null) {
                TunnelParticipant.this._nextHopCache = ri;
                if (TunnelParticipant.this._log.shouldLog(40)) {
                    TunnelParticipant.this._log.error("Lookup the nextHop (" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 4) + " failed, but we found it!!  where do we go for " + TunnelParticipant.this._config + "?  msg dropped: " + this._msg);
                }
            } else if (TunnelParticipant.this._log.shouldLog(40)) {
                TunnelParticipant.this._log.error("Lookup the nextHop (" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 4) + " failed!  where do we go for " + TunnelParticipant.this._config + "?  msg dropped: " + this._msg);
            }
        }
    }

    private class SendJob
    extends JobImpl {
        private TunnelDataMessage _msg;

        public SendJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        public String getName() {
            return "forward a tunnel message";
        }

        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, TunnelParticipant.this._nextHopCache);
            } else {
                RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
                if (ri != null) {
                    TunnelParticipant.this._nextHopCache = ri;
                    TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, ri);
                } else if (TunnelParticipant.this._log.shouldLog(40)) {
                    TunnelParticipant.this._log.error("Lookup the nextHop (" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 4) + " failed!  where do we go for " + TunnelParticipant.this._config + "?  msg dropped: " + this._msg);
                }
            }
        }
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (TunnelParticipant.this._log.shouldLog(10)) {
                TunnelParticipant.this._log.debug("Receive complete: on " + TunnelParticipant.this._config + ": " + msg);
            }
            TunnelParticipant.this._inboundDistributor.distribute(msg, toRouter, toTunnel);
        }
    }

    private class Found
    extends JobImpl {
        public Found(RouterContext ctx) {
            super(ctx);
        }

        public String getName() {
            return "Next hop info found";
        }

        public void runJob() {
            if (TunnelParticipant.this._nextHopCache == null) {
                TunnelParticipant.this._nextHopCache = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
            }
        }
    }
}

