/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.pool.BuildHandler;
import net.i2p.router.tunnel.pool.BuildRequestor;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.stat.StatManager;
import net.i2p.util.Log;

class BuildExecutor
implements Runnable {
    private RouterContext _context;
    private Log _log;
    private TunnelPoolManager _manager;
    private List _currentlyBuilding;
    private boolean _isRunning;
    private BuildHandler _handler;
    private boolean _repoll;
    private List _recentBuildIds = new ArrayList(100);

    public BuildExecutor(RouterContext ctx, TunnelPoolManager mgr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._manager = mgr;
        this._currentlyBuilding = new ArrayList(10);
        this._context.statManager().createRateStat("tunnel.concurrentBuilds", "How many builds are going at once", "Tunnels", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("tunnel.concurrentBuildsLagged", "How many builds are going at once when we reject further builds, due to job lag (period is lag)", "Tunnels", new long[]{60000L, 300000L, 3600000L});
        this._context.statManager().createRateStat("tunnel.buildExploratoryExpire", "How often an exploratory tunnel times out during creation", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildClientExpire", "How often a client tunnel times out during creation", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildExploratorySuccess", "How often an exploratory tunnel is fully built", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildClientSuccess", "How often a client tunnel is fully built", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildExploratoryReject", "How often an exploratory tunnel is rejected", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildClientReject", "How often a client tunnel is rejected", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildRequestTime", "How long it takes to build a tunnel request", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.buildRequestZeroHopTime", "How long it takes to build a zero hop tunnel", "Tunnels", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("tunnel.pendingRemaining", "How many inbound requests are pending after a pass (period is how long the pass takes)?", "Tunnels", new long[]{60000L, 600000L});
        StatManager statMgr = this._context.statManager();
        this._context.router().getRouterInfo();
        String bwTiers = "KLMNO";
        for (int i = 0; i < bwTiers.length(); ++i) {
            String bwTier = String.valueOf(bwTiers.charAt(i));
            statMgr.createRateStat("tunnel.tierAgree" + bwTier, "Agreed joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
            statMgr.createRateStat("tunnel.tierReject" + bwTier, "Rejected joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
            statMgr.createRateStat("tunnel.tierExpire" + bwTier, "Expired joins from " + bwTier, "Tunnels", new long[]{60000L, 600000L});
        }
        statMgr.createRateStat("tunnel.tierAgreeUnknown", "Agreed joins from unknown", "Tunnels", new long[]{60000L, 600000L});
        statMgr.createRateStat("tunnel.tierRejectUnknown", "Rejected joins from unknown", "Tunnels", new long[]{60000L, 600000L});
        statMgr.createRateStat("tunnel.tierExpireUnknown", "Expired joins from unknown", "Tunnels", new long[]{60000L, 600000L});
        this._repoll = false;
        this._handler = new BuildHandler(ctx, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allowed() {
        String prop;
        int maxKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        int allowed = maxKBps / 6;
        if (allowed < 2) {
            allowed = 2;
        }
        if (allowed > 10) {
            allowed = 10;
        }
        if ((prop = this._context.getProperty("router.tunnelConcurrentBuilds")) != null) {
            try {
                allowed = Integer.valueOf(prop);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ArrayList<TunnelCreatorConfig> expired = null;
        int concurrent = 0;
        long expireBefore = this._context.clock().now() + 600000L - 10000L;
        List list = this._currentlyBuilding;
        synchronized (list) {
            for (int i = 0; i < this._currentlyBuilding.size(); ++i) {
                TunnelCreatorConfig cfg = (TunnelCreatorConfig)this._currentlyBuilding.get(i);
                if (cfg.getExpiration() > expireBefore) continue;
                this._currentlyBuilding.remove(i);
                --i;
                if (expired == null) {
                    expired = new ArrayList<TunnelCreatorConfig>();
                }
                expired.add(cfg);
            }
            concurrent = this._currentlyBuilding.size();
            allowed -= concurrent;
        }
        if (expired != null) {
            for (int i = 0; i < expired.size(); ++i) {
                PooledTunnelCreatorConfig cfg = (PooledTunnelCreatorConfig)expired.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Timed out waiting for reply asking for " + cfg);
                }
                for (int iPeer = 0; iPeer < cfg.getLength(); ++iPeer) {
                    Hash peer = cfg.getPeer(iPeer);
                    if (peer.toBase64().equals(this._context.routerHash().toBase64())) continue;
                    RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                    String bwTier = "Unknown";
                    if (ri != null) {
                        bwTier = ri.getBandwidthTier();
                    }
                    this._context.statManager().addRateData("tunnel.tierExpire" + bwTier, 1L, 0L);
                    this.didNotReply(cfg.getReplyMessageId(), peer);
                    this._context.profileManager().tunnelTimedOut(peer);
                }
                TunnelPool pool = cfg.getTunnelPool();
                if (pool != null) {
                    pool.buildComplete(cfg);
                }
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratoryExpire", 1L, 0L);
                    continue;
                }
                this._context.statManager().addRateData("tunnel.buildClientExpire", 1L, 0L);
            }
        }
        this._context.statManager().addRateData("tunnel.concurrentBuilds", (long)concurrent, 0L);
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > 2000L && this._context.router().getUptime() > 300000L) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Too lagged [" + lag + "], don't allow building");
            }
            this._context.statManager().addRateData("tunnel.concurrentBuildsLagged", (long)concurrent, lag);
            return 0;
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._isRunning = true;
        ArrayList<TunnelPool> wanted = new ArrayList<TunnelPool>(8);
        ArrayList pools = new ArrayList(8);
        int pendingRemaining = 0;
        long afterBuildReal = 0L;
        long afterHandleInbound = 0L;
        while (!this._manager.isShutdown()) {
            try {
                this._repoll = pendingRemaining > 0;
                this._manager.listPools(pools);
                for (int i = 0; i < pools.size(); ++i) {
                    TunnelPool pool = (TunnelPool)pools.get(i);
                    if (!pool.isAlive()) continue;
                    int howMany = pool.countHowManyToBuild();
                    for (int j = 0; j < howMany; ++j) {
                        wanted.add(pool);
                    }
                }
                this._handler.handleInboundReplies();
                int allowed = this.allowed();
                allowed = this.buildZeroHopTunnels(wanted, allowed);
                int realBuilt = 0;
                TunnelManagerFacade mgr = this._context.tunnelManager();
                if (mgr == null || mgr.selectInboundTunnel() == null || mgr.selectOutboundTunnel() == null) {
                    List j = this._currentlyBuilding;
                    synchronized (j) {
                        if (!this._repoll) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("No tunnel to build with (allowed=" + allowed + ", wanted=" + wanted.size() + ", pending=" + pendingRemaining + "), wait for a while");
                            }
                            this._currentlyBuilding.wait(1000 + this._context.random().nextInt(1000));
                        }
                    }
                }
                if (allowed > 0 && wanted.size() > 0) {
                    Collections.shuffle(wanted, (Random)this._context.random());
                    if (allowed > 2) {
                        allowed = 2;
                    }
                    for (int i = 0; i < allowed && wanted.size() > 0; ++i) {
                        TunnelPool pool = (TunnelPool)wanted.remove(0);
                        PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
                        if (cfg != null) {
                            if (cfg.getLength() <= 1 && !pool.needFallback()) {
                                if (this._log.shouldLog(10)) {
                                    this._log.debug("We don't need more fallbacks for " + pool);
                                }
                                --i;
                                pool.buildComplete(cfg);
                                continue;
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug("Configuring new tunnel " + i + " for " + pool + ": " + cfg);
                            }
                            List list = this._currentlyBuilding;
                            synchronized (list) {
                                this._currentlyBuilding.add(cfg);
                            }
                            this.buildTunnel(pool, cfg);
                            ++realBuilt;
                            this._handler.handleInboundReplies();
                            continue;
                        }
                        --i;
                    }
                }
                try {
                    List i = this._currentlyBuilding;
                    synchronized (i) {
                        if (!this._repoll) {
                            this._currentlyBuilding.wait(2000 + this._context.random().nextInt(2000));
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                afterBuildReal = System.currentTimeMillis();
                pendingRemaining = this._handler.handleInboundRequests();
                afterHandleInbound = System.currentTimeMillis();
                if (pendingRemaining > 0) {
                    this._context.statManager().addRateData("tunnel.pendingRemaining", (long)pendingRemaining, afterHandleInbound - afterBuildReal);
                }
                wanted.clear();
                pools.clear();
            }
            catch (Exception e) {
                if (!this._log.shouldLog(50)) continue;
                this._log.log(50, "B0rked in the tunnel builder", (Throwable)e);
            }
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Done building");
        }
        this._isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int buildZeroHopTunnels(List wanted, int allowed) {
        for (int i = 0; i < wanted.size(); ++i) {
            TunnelPool pool = (TunnelPool)wanted.get(0);
            if (pool.getSettings().getLength() != 0) continue;
            PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
            if (cfg != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Configuring short tunnel " + i + " for " + pool + ": " + cfg);
                }
                List list = this._currentlyBuilding;
                synchronized (list) {
                    this._currentlyBuilding.add(cfg);
                }
                this.buildTunnel(pool, cfg);
                if (cfg.getLength() > 1) {
                    --allowed;
                }
                wanted.remove(i);
                --i;
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Configured a null tunnel");
        }
        return allowed;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildTunnel(TunnelPool pool, PooledTunnelCreatorConfig cfg) {
        long beforeBuild = System.currentTimeMillis();
        BuildRequestor.request(this._context, pool, cfg, this);
        long buildTime = System.currentTimeMillis() - beforeBuild;
        if (cfg.getLength() <= 1) {
            this._context.statManager().addRateData("tunnel.buildRequestZeroHopTime", buildTime, buildTime);
        } else {
            this._context.statManager().addRateData("tunnel.buildRequestTime", buildTime, buildTime);
        }
        long id = cfg.getReplyMessageId();
        if (id > 0L) {
            List list = this._recentBuildIds;
            synchronized (list) {
                while (this._recentBuildIds.size() > 64) {
                    this._recentBuildIds.remove(0);
                }
                this._recentBuildIds.add(new Long(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildComplete(PooledTunnelCreatorConfig cfg, TunnelPool pool) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Build complete for " + cfg);
        }
        pool.buildComplete(cfg);
        List list = this._currentlyBuilding;
        synchronized (list) {
            this._currentlyBuilding.remove(cfg);
            this._currentlyBuilding.notifyAll();
        }
        long expireBefore = this._context.clock().now() + 600000L - 10000L;
        if (cfg.getExpiration() <= expireBefore && this._log.shouldLog(20)) {
            this._log.info("Build complete for expired tunnel: " + cfg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRecentlyBuilding(long replyId) {
        List list = this._recentBuildIds;
        synchronized (list) {
            return this._recentBuildIds.contains(new Long(replyId));
        }
    }

    public void buildSuccessful(PooledTunnelCreatorConfig cfg) {
        this._manager.buildComplete(cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repoll() {
        List list = this._currentlyBuilding;
        synchronized (list) {
            this._repoll = true;
            this._currentlyBuilding.notifyAll();
        }
    }

    private void didNotReply(long tunnel, Hash peer) {
        if (this._log.shouldLog(20)) {
            this._log.info(tunnel + ": Peer " + peer.toBase64() + " did not reply to the tunnel join request");
        }
    }

    List locked_getCurrentlyBuilding() {
        return this._currentlyBuilding;
    }

    public int getInboundBuildQueueSize() {
        return this._handler.getInboundBuildQueueSize();
    }
}

