/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.TunnelId;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class TunnelPool {
    private RouterContext _context;
    private Log _log;
    private TunnelPoolSettings _settings;
    private ArrayList _tunnels;
    private TunnelPeerSelector _peerSelector;
    private TunnelPoolManager _manager;
    private boolean _alive;
    private long _lifetimeProcessed;
    private TunnelInfo _lastSelected;
    private long _lastSelectionPeriod;
    private int _expireSkew;
    private long _started;
    private long _lastRateUpdate;
    private long _lastLifetimeProcessed;
    private final String _rateName;
    private static final int TUNNEL_LIFETIME = 600000;
    private List _inProgress = new ArrayList();

    public TunnelPool(RouterContext ctx, TunnelPoolManager mgr, TunnelPoolSettings settings, TunnelPeerSelector sel) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPool.class);
        this._manager = mgr;
        this._settings = settings;
        this._tunnels = new ArrayList(settings.getLength() + settings.getBackupQuantity());
        this._peerSelector = sel;
        this._alive = false;
        this._lastSelectionPeriod = 0L;
        this._lastSelected = null;
        this._lifetimeProcessed = 0L;
        this._expireSkew = this._context.random().nextInt(90000);
        this._lastRateUpdate = this._started = System.currentTimeMillis();
        this._lastLifetimeProcessed = 0L;
        this._rateName = "tunnel.Bps." + (this._settings.isExploratory() ? "exploratory" : this._settings.getDestinationNickname()) + (this._settings.isInbound() ? ".in" : ".out");
        this.refreshSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        this._alive = true;
        this._lastRateUpdate = this._started = System.currentTimeMillis();
        this._lastLifetimeProcessed = 0L;
        this._manager.getExecutor().repoll();
        if (this._settings.isInbound() && this._settings.getDestination() != null) {
            LeaseSet ls = null;
            ArrayList arrayList = this._tunnels;
            synchronized (arrayList) {
                ls = this.locked_buildNewLeaseSet();
            }
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
            }
        }
        this._context.statManager().createRateStat(this._rateName, "Tunnel Bandwidth", "Tunnels", new long[]{300000L});
    }

    public void shutdown() {
        this._alive = false;
        this._lastSelectionPeriod = 0L;
        this._lastSelected = null;
        this._context.statManager().removeRateStat(this._rateName);
    }

    TunnelPoolManager getManager() {
        return this._manager;
    }

    void refreshSettings() {
        if (this._settings.getDestination() != null) {
            return;
        }
        if (this._settings.isExploratory()) {
            Properties props = this._context.router().getConfigMap();
            if (this._settings.isInbound()) {
                this._settings.readFromProperties("router.inboundPool.", props);
            } else {
                this._settings.readFromProperties("router.outboundPool.", props);
            }
        }
    }

    private long curPeriod() {
        long period = this._context.clock().now();
        long ms = period % 1000L;
        period = ms > 500L ? period - ms + 500L : (period -= ms);
        return period;
    }

    private long getLifetime() {
        return System.currentTimeMillis() - this._started;
    }

    public TunnelInfo selectTunnel() {
        return this.selectTunnel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TunnelInfo selectTunnel(boolean allowRecurseOnFail) {
        boolean avoidZeroHop = this.getSettings().getLength() + this.getSettings().getLengthVariance() > 0;
        long period = this.curPeriod();
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            if (this._lastSelectionPeriod == period && this._lastSelected != null && this._lastSelected.getExpiration() > period && this._tunnels.contains(this._lastSelected)) {
                return this._lastSelected;
            }
            this._lastSelectionPeriod = period;
            this._lastSelected = null;
            if (this._tunnels.size() <= 0) {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": No tunnels to select from");
                }
            } else {
                TunnelInfo info;
                int i;
                Collections.shuffle(this._tunnels, (Random)this._context.random());
                TunnelInfo backloggedTunnel = null;
                if (avoidZeroHop) {
                    for (i = 0; i < this._tunnels.size(); ++i) {
                        info = (TunnelInfo)this._tunnels.get(i);
                        if (info.getLength() <= 1 || info.getExpiration() <= this._context.clock().now()) continue;
                        if (this._settings.isInbound() || !this._context.commSystem().isBacklogged(info.getPeer(1))) {
                            this._lastSelected = info;
                            return info;
                        }
                        backloggedTunnel = info;
                    }
                    if (backloggedTunnel != null) {
                        if (this._log.shouldLog(30)) {
                            this._log.warn(this.toString() + ": All tunnels are backlogged");
                        }
                        return backloggedTunnel;
                    }
                }
                for (i = 0; i < this._tunnels.size(); ++i) {
                    info = (TunnelInfo)this._tunnels.get(i);
                    if (info.getExpiration() <= this._context.clock().now()) continue;
                    if (this._settings.isInbound() || info.getLength() <= 1 || !this._context.commSystem().isBacklogged(info.getPeer(1))) {
                        this._lastSelected = info;
                        return info;
                    }
                    backloggedTunnel = info;
                }
                if (backloggedTunnel != null) {
                    return backloggedTunnel;
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": after " + this._tunnels.size() + " tries, no unexpired ones were found: " + this._tunnels);
                }
            }
        }
        if (this._alive && this._settings.getAllowZeroHop()) {
            this.buildFallback();
        }
        if (allowRecurseOnFail) {
            return this.selectTunnel(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TunnelInfo getTunnel(TunnelId gatewayId) {
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            for (int i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = (TunnelInfo)this._tunnels.get(i);
                if (this._settings.isInbound()) {
                    if (!info.getReceiveTunnelId(0).equals((Object)gatewayId)) continue;
                    return info;
                }
                if (!info.getSendTunnelId(0).equals((Object)gatewayId)) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listTunnels() {
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            return new ArrayList(this._tunnels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needFallback() {
        int needed = this._settings.getBackupQuantity() + this._settings.getQuantity();
        int fallbacks = 0;
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            for (int i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = (TunnelInfo)this._tunnels.get(i);
                if (info.getLength() > 1 || ++fallbacks < needed) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listPending() {
        List list = this._inProgress;
        synchronized (list) {
            return new ArrayList(this._inProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTunnelCount() {
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            return this._tunnels.size();
        }
    }

    public TunnelPoolSettings getSettings() {
        return this._settings;
    }

    public void setSettings(TunnelPoolSettings settings) {
        this._settings = settings;
        if (this._settings != null) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.toString() + ": Settings updated on the pool: " + settings);
            }
            this._manager.getExecutor().repoll();
        }
    }

    public TunnelPeerSelector getSelector() {
        return this._peerSelector;
    }

    public boolean isAlive() {
        return this._alive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            return this._tunnels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTunnel(TunnelInfo info) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.toString() + ": Adding tunnel " + info, (Throwable)new Exception("Creator"));
        }
        LeaseSet ls = null;
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            this._tunnels.add(info);
            if (this._settings.isInbound() && this._settings.getDestination() != null) {
                ls = this.locked_buildNewLeaseSet();
            }
        }
        if (ls != null) {
            this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTunnel(TunnelInfo info) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.toString() + ": Removing tunnel " + info);
        }
        int remaining = 0;
        LeaseSet ls = null;
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            this._tunnels.remove(info);
            if (this._settings.isInbound() && this._settings.getDestination() != null) {
                ls = this.locked_buildNewLeaseSet();
            }
            remaining = this._tunnels.size();
            if (this._lastSelected == info) {
                this._lastSelected = null;
                this._lastSelectionPeriod = 0L;
            }
        }
        this._manager.getExecutor().repoll();
        this._lifetimeProcessed += info.getProcessedMessagesCount();
        this.updateRate();
        long lifetimeConfirmed = info.getVerifiedBytesTransferred();
        long lifetime = 600000L;
        for (int i = 0; i < info.getLength(); ++i) {
            this._context.profileManager().tunnelLifetimePushed(info.getPeer(i), lifetime, lifetimeConfirmed);
        }
        if (this._alive && this._settings.isInbound() && this._settings.getDestination() != null) {
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
            } else {
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.toString() + ": unable to build a new leaseSet on removal (" + remaining + " remaining), request a new tunnel");
                }
                if (this._settings.getAllowZeroHop()) {
                    this.buildFallback();
                }
            }
        }
        boolean connected = true;
        if (this._settings.getDestination() != null && !this._context.clientManager().isLocal(this._settings.getDestination())) {
            connected = false;
        }
        if (this.getTunnelCount() <= 0 && !connected) {
            this._manager.removeTunnels(this._settings.getDestination());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tunnelFailed(PooledTunnelCreatorConfig cfg) {
        if (this._log.shouldLog(30)) {
            this._log.warn(this.toString() + ": Tunnel failed: " + cfg);
        }
        LeaseSet ls = null;
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            this._tunnels.remove(cfg);
            if (this._settings.isInbound() && this._settings.getDestination() != null) {
                ls = this.locked_buildNewLeaseSet();
            }
            if (this._lastSelected == cfg) {
                this._lastSelected = null;
                this._lastSelectionPeriod = 0L;
            }
        }
        this._manager.tunnelFailed();
        this.tellProfileFailed(cfg);
        this._lifetimeProcessed += cfg.getProcessedMessagesCount();
        this.updateRate();
        if (this._settings.isInbound() && this._settings.getDestination() != null && ls != null) {
            this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
        }
    }

    private void tellProfileFailed(PooledTunnelCreatorConfig cfg) {
        int len = cfg.getLength();
        if (len < 2) {
            return;
        }
        int start = 0;
        int end = len;
        if (cfg.isInbound()) {
            --end;
        } else {
            ++start;
        }
        for (int i = start; i < end; ++i) {
            int pct = 100 / (len - 1);
            if (cfg.isInbound() && len > 2) {
                pct = i == start ? (pct *= 2) : (pct /= 2);
            }
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Blaming " + cfg.getPeer(i) + ' ' + pct + '%');
            }
            this._context.profileManager().tunnelFailed(cfg.getPeer(i), pct);
        }
    }

    void updateRate() {
        long now = this._context.clock().now();
        long et = now - this._lastRateUpdate;
        if (et > 120000L) {
            long bw = 1024L * (this._lifetimeProcessed - this._lastLifetimeProcessed) * 1000L / et;
            this._context.statManager().addRateData(this._rateName, bw, 0L);
            this._lastRateUpdate = now;
            this._lastLifetimeProcessed = this._lifetimeProcessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshLeaseSet() {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.toString() + ": refreshing leaseSet on tunnel expiration (but prior to grace timeout)");
        }
        LeaseSet ls = null;
        if (this._settings.isInbound() && this._settings.getDestination() != null) {
            ArrayList arrayList = this._tunnels;
            synchronized (arrayList) {
                ls = this.locked_buildNewLeaseSet();
            }
            if (ls != null) {
                this._context.clientManager().requestLeaseSet(this._settings.getDestination(), ls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean buildFallback() {
        int quantity = this._settings.getBackupQuantity() + this._settings.getQuantity();
        int usable = 0;
        ArrayList arrayList = this._tunnels;
        synchronized (arrayList) {
            usable = this._tunnels.size();
        }
        if (usable > 0) {
            return false;
        }
        if (this._settings.getAllowZeroHop()) {
            if (this._settings.getLength() + this._settings.getLengthVariance() > 0 && this._settings.getDestination() != null && this._context.profileOrganizer().countActivePeers() > 0) {
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.toString() + ": building a fallback tunnel (usable: " + usable + " needed: " + quantity + ")");
            }
            this._manager.getExecutor().buildTunnel(this, this.configureNewTunnel(true));
            return true;
        }
        return false;
    }

    private LeaseSet locked_buildNewLeaseSet() {
        if (!this._alive) {
            return null;
        }
        int wanted = this._settings.getQuantity();
        if (this._tunnels.size() < wanted) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Not enough tunnels (" + this._tunnels.size() + ", wanted " + wanted + ")");
            }
            return null;
        }
        long expireAfter = this._context.clock().now();
        TreeSet<Lease> leases = new TreeSet<Lease>(new LeaseComparator());
        for (int i = 0; i < this._tunnels.size(); ++i) {
            TunnelInfo tunnel = (TunnelInfo)this._tunnels.get(i);
            if (tunnel.getExpiration() <= expireAfter) continue;
            TunnelId inId = tunnel.getReceiveTunnelId(0);
            Hash gw = tunnel.getPeer(0);
            if (inId == null || gw == null) {
                this._log.error(this.toString() + ": wtf, tunnel has no inbound gateway/tunnelId? " + tunnel);
                continue;
            }
            Lease lease = new Lease();
            lease.setEndDate(new Date(tunnel.getExpiration()));
            lease.setTunnelId(inId);
            lease.setGateway(gw);
            leases.add(lease);
        }
        if (leases.size() < wanted) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.toString() + ": Not enough leases (" + leases.size() + ", wanted " + wanted + ")");
            }
            return null;
        }
        LeaseSet ls = new LeaseSet();
        Iterator iter = leases.iterator();
        for (int i = 0; i < wanted; ++i) {
            ls.addLease((Lease)iter.next());
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.toString() + ": built new leaseSet: " + ls);
        }
        return ls;
    }

    public long getLifetimeProcessed() {
        return this._lifetimeProcessed;
    }

    private final String buildRateName() {
        if (this._settings.isExploratory()) {
            return "tunnel.buildRatio.exploratory." + (this._settings.isInbound() ? "in" : "out");
        }
        return "tunnel.buildRatio.l" + this._settings.getLength() + "v" + this._settings.getLengthVariance() + (this._settings.isInbound() ? ".in" : ".out");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countHowManyToBuild() {
        int i;
        Rate r;
        if (this._settings.getDestination() != null && !this._context.clientManager().isLocal(this._settings.getDestination())) {
            return 0;
        }
        int wanted = this.getSettings().getBackupQuantity() + this.getSettings().getQuantity();
        boolean allowZeroHop = this.getSettings().getLength() + this.getSettings().getLengthVariance() <= 0;
        int avg = 0;
        RateStat rs = this._context.statManager().getRate(this.buildRateName());
        if (rs == null) {
            this._context.statManager().createRateStat(this.buildRateName(), "Tunnel Build Frequency", "Tunnels", new long[]{600000L});
            rs = this._context.statManager().getRate(this.buildRateName());
        }
        if (rs != null && (r = rs.getRate(600000L)) != null) {
            avg = (int)(600000.0 * r.getAverageValue() / (double)wanted);
        }
        if (avg > 0 && avg < 200000) {
            int inProgress;
            int[] expireTime;
            int PANIC_FACTOR = 4;
            avg += 60000;
            if (this._settings.isExploratory()) {
                avg += 60000;
            }
            long now = this._context.clock().now();
            int expireSoon = 0;
            int expireLater = 0;
            int fallback = 0;
            ArrayList arrayList = this._tunnels;
            synchronized (arrayList) {
                expireTime = new int[this._tunnels.size()];
                for (int i2 = 0; i2 < this._tunnels.size(); ++i2) {
                    TunnelInfo info = (TunnelInfo)this._tunnels.get(i2);
                    if (allowZeroHop || info.getLength() > 1) {
                        int timeToExpire = (int)(info.getExpiration() - now);
                        if (timeToExpire > 0 && timeToExpire < avg) {
                            expireTime[expireSoon++] = timeToExpire;
                            continue;
                        }
                        ++expireLater;
                        continue;
                    }
                    if (info.getExpiration() - now <= (long)avg) continue;
                    ++fallback;
                }
            }
            List i2 = this._inProgress;
            synchronized (i2) {
                inProgress = this._inProgress.size();
            }
            int remainingWanted = wanted - expireLater - inProgress;
            if (allowZeroHop) {
                remainingWanted -= fallback;
            }
            int rv = 0;
            int latesttime = 0;
            if (remainingWanted > 0) {
                if (remainingWanted > expireSoon) {
                    rv = 4 * (remainingWanted - expireSoon);
                    remainingWanted = expireSoon;
                }
                for (int i3 = 0; i3 < remainingWanted; ++i3) {
                    int latestidx = 0;
                    for (int j = 0; j < expireSoon; ++j) {
                        if (expireTime[j] <= latesttime) continue;
                        latesttime = expireTime[j];
                        latestidx = j;
                    }
                    expireTime[latestidx] = 0;
                    if (latesttime > avg / 2) {
                        ++rv;
                        continue;
                    }
                    rv += 2 + 2 * ((avg / 2 - latesttime) / (avg / 2));
                }
            }
            if (rv > 0 && this._log.shouldLog(10)) {
                this._log.debug("New Count: rv: " + rv + " allow? " + allowZeroHop + " avg " + avg + " latesttime " + latesttime + " soon " + expireSoon + " later " + expireLater + " std " + wanted + " inProgress " + inProgress + " fallback " + fallback + " for " + this.toString());
            }
            this._context.statManager().addRateData(this.buildRateName(), (long)(rv + inProgress), 0L);
            return rv;
        }
        long expireAfter = this._context.clock().now() + (long)this._expireSkew;
        int expire30s = 0;
        int expire90s = 0;
        int expire150s = 0;
        int expire210s = 0;
        int expire270s = 0;
        int expireLater = 0;
        int fallback = 0;
        ArrayList rv = this._tunnels;
        synchronized (rv) {
            boolean enough = this._tunnels.size() > wanted;
            for (i = 0; i < this._tunnels.size(); ++i) {
                TunnelInfo info = (TunnelInfo)this._tunnels.get(i);
                if (allowZeroHop || info.getLength() > 1) {
                    long timeToExpire = info.getExpiration() - expireAfter;
                    if (timeToExpire <= 0L) continue;
                    if (timeToExpire <= 30000L) {
                        ++expire30s;
                        continue;
                    }
                    if (timeToExpire <= 90000L) {
                        ++expire90s;
                        continue;
                    }
                    if (timeToExpire <= 150000L) {
                        ++expire150s;
                        continue;
                    }
                    if (timeToExpire <= 210000L) {
                        ++expire210s;
                        continue;
                    }
                    if (timeToExpire <= 270000L) {
                        ++expire270s;
                        continue;
                    }
                    ++expireLater;
                    continue;
                }
                if (info.getExpiration() <= expireAfter) continue;
                ++fallback;
            }
        }
        int inProgress = 0;
        List enough = this._inProgress;
        synchronized (enough) {
            inProgress = this._inProgress.size();
            for (i = 0; i < this._inProgress.size(); ++i) {
                PooledTunnelCreatorConfig cfg = (PooledTunnelCreatorConfig)this._inProgress.get(i);
                if (cfg.getLength() > 1) continue;
                ++fallback;
            }
        }
        int rv2 = this.countHowManyToBuild(allowZeroHop, expire30s, expire90s, expire150s, expire210s, expire270s, expireLater, wanted, inProgress, fallback);
        this._context.statManager().addRateData(this.buildRateName(), rv2 > 0 || inProgress > 0 ? 1L : 0L, 0L);
        return rv2;
    }

    private int countHowManyToBuild(boolean allowZeroHop, int expire30s, int expire90s, int expire150s, int expire210s, int expire270s, int expireLater, int standardAmount, int inProgress, int fallback) {
        long lifetime;
        int i;
        int rv = 0;
        int remainingWanted = standardAmount - expireLater;
        if (allowZeroHop) {
            remainingWanted -= fallback;
        }
        for (i = 0; i < expire270s && remainingWanted > 0; --remainingWanted, ++i) {
        }
        if (remainingWanted > 0) {
            for (i = 0; i < expire210s && remainingWanted > 0; --remainingWanted, ++i) {
            }
            if (remainingWanted > 0) {
                for (i = 0; i < expire150s && remainingWanted > 0; --remainingWanted, ++i) {
                }
                if (remainingWanted > 0) {
                    for (i = 0; i < expire90s && remainingWanted > 0; --remainingWanted, ++i) {
                    }
                    if (remainingWanted > 0) {
                        for (i = 0; i < expire30s && remainingWanted > 0; --remainingWanted, ++i) {
                        }
                        if (remainingWanted > 0) {
                            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                            rv += expire210s;
                            rv += 2 * expire150s;
                            rv += 4 * expire90s;
                            rv += 6 * expire30s;
                            rv += 6 * remainingWanted;
                            rv -= inProgress;
                            rv -= expireLater;
                        } else {
                            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                            rv += expire210s;
                            rv += 2 * expire150s;
                            rv += 4 * expire90s;
                            rv += 6 * expire30s;
                            rv -= inProgress;
                            rv -= expireLater;
                        }
                    } else {
                        rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                        rv += expire210s;
                        rv += 2 * expire150s;
                        rv += 4 * expire90s;
                        rv -= inProgress;
                        rv -= expireLater;
                    }
                } else {
                    rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                    rv += expire210s;
                    rv += 2 * expire150s;
                    rv -= inProgress;
                    rv -= expireLater;
                }
            } else {
                rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
                rv += expire210s;
                rv -= inProgress;
                rv -= expireLater;
            }
        } else {
            rv = expire270s > 0 && this._context.random().nextBoolean() ? 1 : 0;
            rv -= inProgress;
            rv -= expireLater;
        }
        if (allowZeroHop && rv > standardAmount) {
            rv = standardAmount;
        }
        if (rv + inProgress + expireLater + fallback > 4 * standardAmount) {
            rv = 4 * standardAmount - inProgress - expireLater - fallback;
        }
        if ((lifetime = this.getLifetime()) < 60000L && rv + inProgress + fallback >= standardAmount) {
            rv = standardAmount - inProgress - fallback;
        }
        if (rv > 0 && this._log.shouldLog(10)) {
            this._log.debug("Count: rv: " + rv + " allow? " + allowZeroHop + " 30s " + expire30s + " 90s " + expire90s + " 150s " + expire150s + " 210s " + expire210s + " 270s " + expire270s + " later " + expireLater + " std " + standardAmount + " inProgress " + inProgress + " fallback " + fallback + " for " + this.toString() + " up for " + lifetime);
        }
        if (rv < 0) {
            return 0;
        }
        return rv;
    }

    PooledTunnelCreatorConfig configureNewTunnel() {
        return this.configureNewTunnel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledTunnelCreatorConfig configureNewTunnel(boolean forceZeroHop) {
        TunnelPoolSettings settings = this.getSettings();
        List peers = null;
        long expiration = this._context.clock().now() + (long)settings.getDuration();
        if (!forceZeroHop) {
            peers = this._peerSelector.selectPeers(this._context, settings);
            if (peers == null || peers.size() <= 0) {
                if (peers == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No peers to put in the new tunnel! selectPeers returned null!  boo, hiss!");
                    }
                } else if (this._log.shouldLog(30)) {
                    this._log.warn("No peers to put in the new tunnel! selectPeers returned an empty list?!");
                }
                return null;
            }
        } else {
            peers = new ArrayList<Hash>(1);
            peers.add(this._context.routerHash());
        }
        PooledTunnelCreatorConfig cfg = new PooledTunnelCreatorConfig(this._context, peers.size(), settings.isInbound(), settings.getDestination());
        cfg.setTunnelPool(this);
        for (int i = 0; i < peers.size(); ++i) {
            int j = peers.size() - 1 - i;
            cfg.setPeer(j, (Hash)peers.get(i));
            HopConfig hop = cfg.getConfig(j);
            hop.setCreation(this._context.clock().now());
            hop.setExpiration(expiration);
            hop.setIVKey(this._context.keyGenerator().generateSessionKey());
            hop.setLayerKey(this._context.keyGenerator().generateSessionKey());
        }
        cfg.setExpiration(expiration);
        if (this._log.shouldLog(10)) {
            this._log.debug("Config contains " + peers + ": " + cfg);
        }
        List list = this._inProgress;
        synchronized (list) {
            this._inProgress.add(cfg);
        }
        return cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildComplete(PooledTunnelCreatorConfig cfg) {
        List list = this._inProgress;
        synchronized (list) {
            this._inProgress.remove(cfg);
        }
        cfg.setTunnelPool(this);
    }

    public String toString() {
        if (this._settings.isExploratory()) {
            if (this._settings.isInbound()) {
                return "Inbound exploratory pool";
            }
            return "Outbound exploratory pool";
        }
        StringBuffer rv = new StringBuffer(32);
        if (this._settings.isInbound()) {
            rv.append("Inbound client pool for ");
        } else {
            rv.append("Outbound client pool for ");
        }
        if (this._settings.getDestinationNickname() != null) {
            rv.append(this._settings.getDestinationNickname());
        } else {
            rv.append(this._settings.getDestination().toBase64().substring(0, 4));
        }
        return rv.toString();
    }

    class LeaseComparator
    implements Comparator {
        LeaseComparator() {
        }

        public int compare(Object l, Object r) {
            return ((Lease)r).getEndDate().compareTo(((Lease)l).getEndDate());
        }
    }
}

